/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.history;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.history.GlobalHistory;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.history.GlobalHistory;
import com.hello2morrow.sonargraph.core.persistence.history.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.history.XsdHistoryTable;
import com.hello2morrow.sonargraph.core.persistence.history.XsdTableEntry;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public final class HistoryTablePersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.core.persistence.history";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/core/persistence/history/history";
    private static final String FILE_NAME = "_globalHistory.xml";
    private final Version m_version;
    private final XmlPersistenceContext m_persistenceContext;
    private final ObjectFactory m_xsdFactory;
    private final AggregatingClassLoader m_aggregatingClassLoader;
    private final TFile m_directory;

    public HistoryTablePersistence(TFile directory, Version version, AggregatingClassLoader aggregatingClassLoader) {
        assert (directory != null) : "Parameter 'directory' of method 'HistoryTablePersistence' must not be null";
        assert (directory.exists() && directory.isDirectory() && directory.canWrite()) : "Parameter 'directory' must be an existing directory with write permissions";
        assert (version != null) : "Parameter 'version' of method 'HistoryTablePersistence' must not be null";
        assert (aggregatingClassLoader != null) : "Parameter 'aggregatingClassLoader' of method 'HistoryTablePersistence' must not be null";
        this.m_directory = directory;
        this.m_version = version;
        this.m_aggregatingClassLoader = aggregatingClassLoader;
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        this.m_xsdFactory = new ObjectFactory();
    }

    public OperationResult persist(com.hello2morrow.sonargraph.core.model.history.GlobalHistory historyTable) {
        assert (historyTable != null) : "Parameter 'historyTable' of method 'persist' must not be null";
        GlobalHistory xsdGlobalHistory = this.m_xsdFactory.createGlobalHistory();
        xsdGlobalHistory.setVersion(this.m_version.toString());
        xsdGlobalHistory.setCurrentIndex(historyTable.getUndoEntriesSize());
        XsdHistoryTable xsdHistoryTable = this.m_xsdFactory.createXsdHistoryTable();
        xsdGlobalHistory.setHistoryTable(xsdHistoryTable);
        for (GlobalHistory.Entry nextEntry : historyTable.getEntries()) {
            XsdTableEntry tableEntry = this.m_xsdFactory.createXsdTableEntry();
            tableEntry.setId(nextEntry.getFileId());
            tableEntry.setPath(nextEntry.getPath());
            tableEntry.setName(nextEntry.getIdentifyingPath());
            tableEntry.setCommandName(nextEntry.getCommandName());
            tableEntry.setClazz(nextEntry.getClazz().getCanonicalName());
            for (Modification nextModification : nextEntry.getModifications()) {
                tableEntry.getModifiaction().add(nextModification.name());
            }
            xsdHistoryTable.getEntry().add(tableEntry);
        }
        return this.saveToFile(xsdGlobalHistory);
    }

    private OperationResult saveToFile(GlobalHistory historyTable) {
        OperationResult result = new OperationResult("Persist global history");
        TFile file = new TFile((File)this.m_directory, FILE_NAME);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileOutputStream outputStream = new TFileOutputStream((File)file);){
                JaxbAdapter jaxbAdapter = JaxbAccess.createJaxbAdapter(this.m_aggregatingClassLoader, this.m_persistenceContext);
                jaxbAdapter.save((Object)historyTable, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, "Failed to save history to file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        return result;
    }
}

