/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.persistence.diff.IssueInfo;
import com.hello2morrow.sonargraph.core.persistence.diff.MetricInfo;
import com.hello2morrow.sonargraph.core.persistence.diff.ResolutionInfo;
import com.hello2morrow.sonargraph.core.persistence.diff.SystemInfo;
import com.hello2morrow.sonargraph.core.persistence.diff.WorkspaceInfo;
import com.hello2morrow.sonargraph.core.persistence.report.ReportHtmlWriter;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileWriter;
import groovy.lang.Writable;
import groovy.text.GStringTemplateEngine;
import groovy.text.Template;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemDiffHtmlWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemDiffHtmlWriter.class);
    private static final String TEMPLATE = "com/hello2morrow/sonargraph/core/persistence/systemdiff/html/SystemDiffHtmlReport";
    private final IReport m_currentReport;
    private final SoftwareSystemDiff m_softwareSystemDiff;

    public SystemDiffHtmlWriter(SoftwareSystemDiff softwareSystemDiff, IReport currentReport) {
        assert (softwareSystemDiff != null) : "Parameter 'softwareSystemDiff' of method 'SystemDiffHtmlWriter' must not be null";
        assert (currentReport != null) : "Parameter 'currentReport' of method 'SystemDiffHtmlWriter' must not be null";
        this.m_softwareSystemDiff = softwareSystemDiff;
        this.m_currentReport = currentReport;
    }

    public OperationResultWithOutcome<TFile> writeReport(TFile targetFile, String mainReportName) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'writeReport' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create HTML system diff report");
        TFile outputDirectory = targetFile.getParentFile();
        try {
            outputDirectory.mkdir(true);
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Creation of report output directory failed.", new Object[0]);
            return result;
        }
        try {
            ReportHtmlWriter.copyStaticResources(outputDirectory);
        }
        catch (Exception e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)e, "Failed to copy static HTML report resources", new Object[0]);
            return result;
        }
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("currentReport", this.m_currentReport);
        binding.put("systemDiff", this.m_softwareSystemDiff);
        binding.put("systemInfo", this.createSystemInfo(this.m_currentReport, this.m_softwareSystemDiff, targetFile));
        binding.put("metricInfo", new MetricInfo(this.m_softwareSystemDiff));
        binding.put("workspaceInfo", new WorkspaceInfo(this.m_softwareSystemDiff));
        binding.put("issueInfo", new IssueInfo(this.m_softwareSystemDiff));
        binding.put("resolutionInfo", new ResolutionInfo(this.m_softwareSystemDiff));
        binding.put("mainReport", mainReportName == null ? null : mainReportName + CoreFileType.REPORT_HTML.getDefaultExtension());
        long start = System.currentTimeMillis();
        try {
            URL templateUrl = CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.TEMPLATE, TEMPLATE);
            assert (templateUrl != null) : "standard HTML template not found";
            GStringTemplateEngine engine = new GStringTemplateEngine(this.getClass().getClassLoader());
            Template template = engine.createTemplate(templateUrl);
            Writable writable = template.make(binding);
            try {
                Throwable throwable = null;
                Object var13_17 = null;
                try (BufferedWriter bufferedWriter = new BufferedWriter((Writer)new TFileWriter(targetFile));){
                    writable.writeTo((Writer)bufferedWriter);
                    LOGGER.debug("{} ms needed to write HTML file '" + targetFile.getName() + "'", (Object)(System.currentTimeMillis() - start));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex, "Failed to write HTML report.", new Object[0]);
            }
        }
        catch (Exception e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e, "Error processing HTML report template", new Object[0]);
        }
        result.setOutcome((Object)targetFile);
        return result;
    }

    private SystemInfo createSystemInfo(IReport currentReport, SoftwareSystemDiff softwareSystemDiff, TFile targetFile) {
        assert (currentReport != null) : "Parameter 'currentReport' of method 'createReportDto' must not be null";
        assert (softwareSystemDiff != null) : "Parameter 'softwareSystemDiff' of method 'createReportDto' must not be null";
        assert (targetFile != null) : "Parameter 'targetFile' of method 'createBasicInfo' must not be null";
        SoftwareSystem softwareSystem = softwareSystemDiff.getParent(SoftwareSystem.class, new Class[0]);
        SystemInfo info = new SystemInfo(softwareSystem, softwareSystemDiff);
        info.setTargetFile(targetFile);
        return info;
    }
}

