/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.Analyzers;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboards;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.path.ArchitecturalViewsDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.path.TreeMapsDirectory;
import com.hello2morrow.sonargraph.core.model.path.VirtualModels;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.BaselinesDirectory;
import com.hello2morrow.sonargraph.core.model.system.IFiles;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemSettingsDirectory;
import com.hello2morrow.sonargraph.core.model.system.SystemDirectoryLocationInfo;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.system.WorkspaceProfiles;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGates;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Files
extends NamedElementContainer
implements IFiles,
IModifiablePathListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Files.class);
    private static final String NAME = "Files";
    private static final String SYSTYEM_DIRECTORY_SUFFIX = ".sonargraph";
    private final List<IModifiableFile> m_modifiableFiles = new ArrayList<IModifiableFile>();
    private final List<IModifiableFile> m_modifiedModifiableFiles = new ArrayList<IModifiableFile>();
    private final Set<IModifiableFile> m_additionalInformationModifiedModifiableFiles = new HashSet<IModifiableFile>();
    private final List<IModifiableFile> m_savedModifiableFiles = new ArrayList<IModifiableFile>();
    private final List<IModifiableFile> m_createdModifiableFiles = new ArrayList<IModifiableFile>();
    private final List<IModifiableFile> m_deletedModifiableFiles = new ArrayList<IModifiableFile>();
    private final List<IModifiableFile> m_reloadedModifiableFiles = new ArrayList<IModifiableFile>();
    private final List<IModifiableDirectory> m_createdModifiableDirectoryPaths = new ArrayList<IModifiableDirectory>();
    private final List<IModifiableDirectory> m_modifiedModifiableDirectoryPaths = new ArrayList<IModifiableDirectory>();
    private final List<IModifiableDirectory> m_deletedModifiableDirectoryPaths = new ArrayList<IModifiableDirectory>();
    private final Map<IModifiableFile, String> m_pathModifiedModifiableFiles = new LinkedHashMap<IModifiableFile, String>();
    private final SonargraphProduct m_product;
    private final boolean m_isTemporary;

    public static TFile getHiddenSystemsDirectory(SonargraphProduct product) {
        assert (product != null) : "Parameter 'product' of method 'getHiddenSystemsDirectory' must not be null";
        TFile userHomeDir = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        return new TFile((File)new TFile((File)userHomeDir, product.getDirectoryName()), "systems");
    }

    public static String getSystemDirectoryRelPath(String systemName) {
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'getRelPath' must not be empty";
        return "./" + systemName + SYSTYEM_DIRECTORY_SUFFIX;
    }

    public static String validateSystemOverwrite(TFile baseDirectory, String systemName) {
        TFile systemFile;
        assert (baseDirectory != null) : "Parameter 'directory' of method 'validateOverwrite' must not be null";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'validateOverwrite' must not be empty";
        StringBuilder builder = new StringBuilder();
        TFile systemDirectory = new TFile((File)baseDirectory, Files.getSystemDirectoryRelPath(systemName));
        if (systemDirectory.exists()) {
            builder.append("Directory '" + systemDirectory.getNormalizedAbsolutePath() + " already exists.");
        }
        if ((systemFile = new TFile((File)systemDirectory, "system.sonargraph")).exists()) {
            if (builder.length() > 0) {
                builder.append(StringUtility.LINE_SEPARATOR);
            }
            builder.append("System file '" + systemFile.getNormalizedAbsolutePath() + " already exists.");
        }
        return builder.length() == 0 ? null : builder.toString();
    }

    private static void setupStructure(Files files, TFile systemBaseDirectory, String systemId, String systemName) {
        String systemNameToUse;
        assert (files != null) : "Parameter 'files' of method 'setupStructure' must not be null";
        assert (systemBaseDirectory != null) : "Parameter 'systemBaseDirectory' of method 'setupStructure' must not be null";
        TFile normalizedSystemBaseDirectory = systemBaseDirectory.getNormalizedAbsoluteFile();
        SoftwareSystemBaseDirectory baseDirectory = new SoftwareSystemBaseDirectory((NamedElement)files, normalizedSystemBaseDirectory);
        files.addChild(baseDirectory);
        if (systemName != null) {
            assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'setupStructure' must not be empty";
            systemNameToUse = systemName;
        } else {
            systemNameToUse = "system";
        }
        TFile directoryOfSystemFile = new TFile((File)normalizedSystemBaseDirectory, systemNameToUse + SYSTYEM_DIRECTORY_SUFFIX);
        String relPathSystemDirectory = FileUtility.calculateRelativePath((TFile)directoryOfSystemFile, (TFile)normalizedSystemBaseDirectory);
        SoftwareSystemDirectory softwareSystemDirectory = new SoftwareSystemDirectory((NamedElement)baseDirectory, relPathSystemDirectory);
        baseDirectory.addChild(softwareSystemDirectory);
        if (systemName != null) {
            assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'setupStructure' must not be empty";
            TFile systemFile = new TFile((File)softwareSystemDirectory.getDirectoryFile(), "system.sonargraph");
            SoftwareSystemFile file = new SoftwareSystemFile(softwareSystemDirectory, systemFile, systemFile.lastModified(), systemId, files);
            softwareSystemDirectory.addChild(file);
        }
        softwareSystemDirectory.addChild(new Analyzers(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new ArchitecturalViewsDirectory(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new TreeMapsDirectory(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new Architecture(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new Dashboards(softwareSystemDirectory));
        VirtualModels virtualModels = new VirtualModels(softwareSystemDirectory);
        softwareSystemDirectory.addChild(virtualModels);
        virtualModels.addChild(new ParserModel(virtualModels));
        softwareSystemDirectory.addChild(new GroovyScripts(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new PluginConfigurations(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new SoftwareSystemSettingsDirectory(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new WorkspaceProfiles(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new QualityGates(softwareSystemDirectory));
        softwareSystemDirectory.addChild(new BaselinesDirectory(softwareSystemDirectory));
    }

    public Files(NamedElement parent, SonargraphProduct product, TFile systemBaseDirectory) {
        super(parent);
        assert (product != null) : "Parameter 'product' of method 'Files' must not be null";
        assert (systemBaseDirectory != null) : "Parameter 'systemBaseDirectory' of method 'Files' must not be null";
        this.m_product = product;
        this.m_isTemporary = false;
        Files.setupStructure(this, systemBaseDirectory, null, null);
    }

    public Files(NamedElement parent, SonargraphProduct product, TFile systemBaseDirectory, String systemId, String systemName, boolean isTemporary) {
        super(parent);
        TFile hiddenDataDirectoryFile;
        assert (product != null) : "Parameter 'product' of method 'Files' must not be null";
        assert (systemBaseDirectory != null) : "Parameter 'systemBaseDirectory' of method 'Files' must not be null";
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'Files' must not be empty";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'Files' must not be empty";
        this.m_product = product;
        this.m_isTemporary = isTemporary;
        Files.setupStructure(this, systemBaseDirectory, systemId, systemName);
        if (this.m_isTemporary && (hiddenDataDirectoryFile = this.getHiddenDataDirectoryFile()).exists()) {
            try {
                hiddenDataDirectoryFile.rm_r();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to delete already existing temporary hidden data directory", (Throwable)e);
            }
        }
    }

    private void reallocateSystemFileDirectories() {
        List<SoftwareSystemFilesDirectory> directories = this.getUniqueExistingChild(SoftwareSystemBaseDirectory.class).getUniqueExistingChild(SoftwareSystemDirectory.class).getChildren(SoftwareSystemFilesDirectory.class);
        directories.forEach(d -> d.reallocate());
    }

    public void finishInitializationFromSnapshot(String systemId, String systemName) {
        assert (systemId != null) : "Parameter 'systemId' of method 'finishInitializationFromSnapshot' must not be null";
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'finishInitializationFromSnapshot' must not be empty";
        SoftwareSystemDirectory softwareSystemDirectory = this.getUniqueExistingChild(SoftwareSystemBaseDirectory.class).getUniqueExistingChild(SoftwareSystemDirectory.class);
        TFile softwareSystemDirectoryFile = new TFile((File)softwareSystemDirectory.getBaseDirectory().getDirectoryFile(), systemName + SYSTYEM_DIRECTORY_SUFFIX);
        softwareSystemDirectory.setPath(softwareSystemDirectoryFile);
        SoftwareSystemFile softwareSystemFile = softwareSystemDirectory.getUniqueChild(SoftwareSystemFile.class);
        assert (softwareSystemFile == null) : "software system file already created: " + String.valueOf(softwareSystemFile);
        TFile systemFile = new TFile((File)softwareSystemDirectoryFile, "system.sonargraph");
        softwareSystemFile = new SoftwareSystemFile(softwareSystemDirectory, systemFile, systemFile.lastModified(), systemId, this);
        softwareSystemDirectory.addChild(softwareSystemFile);
        this.reallocateSystemFileDirectories();
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    public void writeNameTag(String systemName, OperationResult result) {
        assert (systemName != null && systemName.length() > 0) : "Parameter 'systemName' of method 'createNameTag' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'createNameTag' must not be null";
        FileUtility.createPropertiesFile((TFile)this.getHiddenDataDirectory(), (String)"nametag.txt", Arrays.asList(new Pair((Object)"Name", (Object)systemName), new Pair((Object)"Path", (Object)this.getSoftwareSystemFile().getAbsolutePath())), (OperationResult)result);
    }

    private TFile getHiddenDataDirectoryFile() {
        TFile userHomeDir = CoreResourceProviderAdapter.getInstance().getSonargraphUserHomeDir();
        TFile systemsInUserHomeDir = new TFile((File)userHomeDir, this.m_product.getDirectoryName() + "/systems");
        return new TFile((File)systemsInUserHomeDir, this.getSoftwareSystemFile().getFileId() + (this.m_isTemporary ? ".tmp" : ""));
    }

    @Override
    public TFile getHiddenDataDirectory() {
        TFile hiddenDataDirectory = this.getHiddenDataDirectoryFile();
        OperationResult result = new OperationResult("Get or create hidden data directory");
        FileUtility.getOrCreateDirectory((TFile)hiddenDataDirectory, (OperationResult)result);
        if (result.isFailure()) {
            LOGGER.error("Failed to create hidden data directory: " + result.toString());
        }
        return hiddenDataDirectory;
    }

    public void release() {
        TFile file;
        if (this.m_isTemporary && (file = this.getHiddenDataDirectory()) != null) {
            try {
                file.rm_r();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to delete temporary hidden data directory", (Throwable)e);
            }
        }
    }

    public SystemDirectoryLocationInfo getSystemDirectoryLocationInfo(String newSystemName) {
        assert (newSystemName != null && newSystemName.length() > 0) : "Parameter 'newSystemName' of method 'move' must not be empty";
        SoftwareSystemDirectory softwareSystemDirectory = this.getSystemDirectory();
        TFile currentSystemDirectory = softwareSystemDirectory.getFile();
        TFile newSystemDirectory = new TFile((File)this.getBaseDirectory().getFile(), Files.getSystemDirectoryRelPath(newSystemName));
        return new SystemDirectoryLocationInfo(currentSystemDirectory, newSystemDirectory, null);
    }

    public SystemDirectoryLocationInfo getSystemDirectoryLocationInfo(OperationResult result, String newSystemName, TFile newBaseDirectory) {
        assert (result != null) : "Parameter 'result' of method 'move' must not be null";
        assert (newSystemName != null && newSystemName.length() > 0) : "Parameter 'newSystemName' of method 'move' must not be empty";
        SoftwareSystemDirectory softwareSystemDirectory = this.getSystemDirectory();
        TFile currentSystemDirectory = softwareSystemDirectory.getFile();
        TFile baseDirectory = newBaseDirectory == null ? this.getBaseDirectory().getFile() : newBaseDirectory;
        TFile newSystemDirectory = new TFile((File)baseDirectory, Files.getSystemDirectoryRelPath(newSystemName));
        return new SystemDirectoryLocationInfo(currentSystemDirectory, newSystemDirectory, newBaseDirectory);
    }

    private void adaptFilesStructure(OperationResult result, SystemDirectoryLocationInfo info, boolean createNewFileIds) {
        assert (result != null) : "Parameter 'result' of method 'copy' must not be null";
        assert (info != null) : "Parameter 'info' of method 'copy' must not be null";
        TFile baseDir = info.getBaseDirectory();
        if (baseDir != null) {
            this.getBaseDirectory().setPath(baseDir);
        }
        this.getSystemDirectory().reallocate(FileUtility.calculateRelativePath((TFile)info.getNewDirectory(), (TFile)info.getNewDirectory().getParentFile()));
        this.reallocateSystemFileDirectories();
        for (IModifiableDirectory nextDirectory : this.getChildrenRecursively(IModifiableDirectory.class, IModifiableFile.class)) {
            nextDirectory.reallocate();
        }
        for (IModifiableFile nextModifiableFile : this.m_modifiableFiles) {
            nextModifiableFile.reallocate();
            if (createNewFileIds) {
                nextModifiableFile.createNewFileId();
            }
            nextModifiableFile.resetTimestamp();
        }
    }

    public void move(OperationResult result, SystemDirectoryLocationInfo info) {
        assert (result != null) : "Parameter 'result' of method 'move' must not be null";
        assert (info != null) : "Parameter 'info' of method 'move' must not be null";
        assert (info.locationIsDifferent()) : "Locations not different";
        try {
            info.getCurrentDirectory().mv((File)info.getNewDirectory());
            TrueZipFacade.clear();
            this.adaptFilesStructure(result, info, false);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)ex);
        }
    }

    public void copy(OperationResult result, SystemDirectoryLocationInfo info) {
        assert (result != null) : "Parameter 'result' of method 'copy' must not be null";
        assert (info != null) : "Parameter 'info' of method 'copy' must not be null";
        assert (info.locationIsDifferent()) : "Locations not different";
        try {
            info.getCurrentDirectory().cp_r((File)info.getNewDirectory());
            TrueZipFacade.clear();
            this.adaptFilesStructure(result, info, true);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)ex);
        }
    }

    private void assertModifiableFileStateChange(String stateChange, List<IModifiableFile> addedTo, IModifiableFile modifiableFile) {
        assert (stateChange != null && stateChange.length() > 0) : "Parameter 'stateChange' of method 'assertModifiableFileStateChange' must not be empty";
        assert (addedTo != null) : "Parameter 'addedTo' of method 'modifiableFileStateChange' must not be null";
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'modifiableFileStateChange' must not be null";
        if (this.m_modifiedModifiableFiles != addedTo && this.m_modifiedModifiableFiles.contains(modifiableFile)) assert (false) : "Failed to set '" + modifiableFile.getIdentifyingPath() + "' as '" + stateChange + "' already contained as 'modified'";
        if (this.m_savedModifiableFiles != addedTo && this.m_savedModifiableFiles.contains(modifiableFile)) assert (false) : "Failed to set '" + modifiableFile.getIdentifyingPath() + "' as '" + stateChange + "' already contained as 'saved'";
        if (this.m_createdModifiableFiles != addedTo && this.m_createdModifiableFiles.contains(modifiableFile)) assert (false) : "Failed to set '" + modifiableFile.getIdentifyingPath() + "' as '" + stateChange + "' already contained as 'created'";
        if (this.m_deletedModifiableFiles != addedTo && this.m_deletedModifiableFiles.contains(modifiableFile)) assert (false) : "Failed to set '" + modifiableFile.getIdentifyingPath() + "' as '" + stateChange + "' already contained as 'deleted'";
        if (this.m_reloadedModifiableFiles != addedTo && this.m_reloadedModifiableFiles.contains(modifiableFile)) assert (false) : "Failed to set '" + modifiableFile.getIdentifyingPath() + "' as '" + stateChange + "' already contained as 'reloaded'";
    }

    @Override
    public void created(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'created' must not be null";
        assert (!this.m_modifiableFiles.contains(modifiableFile)) : "Already registered as modifiable file: " + String.valueOf(modifiableFile);
        this.m_modifiableFiles.add(modifiableFile);
        assert (!this.m_createdModifiableFiles.contains(modifiableFile)) : "Already marked as 'created': " + String.valueOf(modifiableFile);
        this.m_createdModifiableFiles.add(modifiableFile);
        this.assertModifiableFileStateChange("created", this.m_createdModifiableFiles, modifiableFile);
    }

    @Override
    public void modified(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'modified' must not be null";
        assert (this.m_modifiableFiles.contains(modifiableFile)) : "Not registered as modifiable file: " + String.valueOf(modifiableFile);
        if (!this.m_modifiedModifiableFiles.contains(modifiableFile)) {
            this.m_modifiedModifiableFiles.add(modifiableFile);
            assert (!this.m_deletedModifiableFiles.contains(modifiableFile)) : "Already marked as 'deleted': " + String.valueOf(modifiableFile);
        }
    }

    @Override
    public void additionalInformationModified(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'additionalInformationModified' must not be null";
        this.m_additionalInformationModifiedModifiableFiles.add(modifiableFile);
    }

    @Override
    public void saved(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'saved' must not be null";
        assert (this.m_modifiableFiles.contains(modifiableFile)) : "Not registered as modifiable file: " + String.valueOf(modifiableFile);
        if (!this.m_savedModifiableFiles.contains(modifiableFile)) {
            this.m_savedModifiableFiles.add(modifiableFile);
        }
    }

    @Override
    public void reloaded(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'restored' must not be null";
        assert (this.m_modifiableFiles.contains(modifiableFile)) : "Not registered as modifiable file: " + String.valueOf(modifiableFile);
        assert (!this.m_reloadedModifiableFiles.contains(modifiableFile)) : "Already marked as 'reloaded': " + String.valueOf(modifiableFile);
        this.m_reloadedModifiableFiles.add(modifiableFile);
        this.assertModifiableFileStateChange("reloaded", this.m_reloadedModifiableFiles, modifiableFile);
    }

    @Override
    public void deleted(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'deleted' must not be null";
        assert (this.m_modifiableFiles.contains(modifiableFile)) : "Not registered as modifiable file: " + String.valueOf(modifiableFile);
        this.m_modifiableFiles.remove(modifiableFile);
        this.m_createdModifiableFiles.remove(modifiableFile);
        this.m_modifiedModifiableFiles.remove(modifiableFile);
        this.m_savedModifiableFiles.remove(modifiableFile);
        this.m_reloadedModifiableFiles.remove(modifiableFile);
        assert (!this.m_deletedModifiableFiles.contains(modifiableFile)) : "File already marked as 'deleted' :" + String.valueOf(modifiableFile);
        this.m_deletedModifiableFiles.add(modifiableFile);
    }

    @Override
    public void created(IModifiableDirectory directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'created' must not be null";
        assert (!this.m_createdModifiableDirectoryPaths.contains(directoryPath)) : "Already created: " + String.valueOf(directoryPath);
        this.m_createdModifiableDirectoryPaths.add(directoryPath);
    }

    @Override
    public void modified(IModifiableDirectory directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'modified' must not be null";
        assert (!this.m_modifiedModifiableDirectoryPaths.contains(directoryPath)) : "Already modified: " + String.valueOf(directoryPath);
        this.m_modifiedModifiableDirectoryPaths.add(directoryPath);
    }

    @Override
    public void deleted(IModifiableDirectory directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'deleted' must not be null";
        assert (!this.m_deletedModifiableDirectoryPaths.contains(directoryPath)) : "Already deleted: " + String.valueOf(directoryPath);
        this.m_deletedModifiableDirectoryPaths.add(directoryPath);
    }

    public List<IModifiableFile> consumeModifiedModifiableFiles() {
        ArrayList<IModifiableFile> modified = new ArrayList<IModifiableFile>(this.m_modifiedModifiableFiles);
        this.m_modifiedModifiableFiles.clear();
        return modified;
    }

    public List<IModifiableFile> consumeAdditionalInformationModifiedModifiableFiles() {
        ArrayList<IModifiableFile> modified = new ArrayList<IModifiableFile>(this.m_additionalInformationModifiedModifiableFiles);
        this.m_additionalInformationModifiedModifiableFiles.clear();
        return modified;
    }

    public List<IModifiableFile> consumeSavedModifiableFiles() {
        ArrayList<IModifiableFile> saved = new ArrayList<IModifiableFile>(this.m_savedModifiableFiles);
        this.m_savedModifiableFiles.clear();
        return saved;
    }

    public List<IModifiableFile> consumeCreatedModifiableFiles() {
        ArrayList<IModifiableFile> created = new ArrayList<IModifiableFile>(this.m_createdModifiableFiles);
        this.m_createdModifiableFiles.clear();
        return created;
    }

    public List<IModifiableFile> consumeDeletedModifiableFiles() {
        ArrayList<IModifiableFile> deleted = new ArrayList<IModifiableFile>(this.m_deletedModifiableFiles);
        this.m_deletedModifiableFiles.clear();
        return deleted;
    }

    public List<IModifiableFile> consumeReloadedModifiableFiles() {
        ArrayList<IModifiableFile> reloaded = new ArrayList<IModifiableFile>(this.m_reloadedModifiableFiles);
        this.m_reloadedModifiableFiles.clear();
        return reloaded;
    }

    public List<IModifiableDirectory> consumeCreatedModifiableDirectoryPaths() {
        ArrayList<IModifiableDirectory> created = new ArrayList<IModifiableDirectory>(this.m_createdModifiableDirectoryPaths);
        this.m_createdModifiableDirectoryPaths.clear();
        return created;
    }

    public List<IModifiableDirectory> consumeModifiedModifiableDirectoryPaths() {
        ArrayList<IModifiableDirectory> modified = new ArrayList<IModifiableDirectory>(this.m_modifiedModifiableDirectoryPaths);
        this.m_modifiedModifiableDirectoryPaths.clear();
        return modified;
    }

    public List<IModifiableDirectory> consumeDeletedModifiableDirectoryPaths() {
        ArrayList<IModifiableDirectory> deleted = new ArrayList<IModifiableDirectory>(this.m_deletedModifiableDirectoryPaths);
        this.m_deletedModifiableDirectoryPaths.clear();
        return deleted;
    }

    public Map<IModifiableFile, String> consumePathModifiedModifiableFiles() {
        LinkedHashMap<IModifiableFile, String> renamed = new LinkedHashMap<IModifiableFile, String>(this.m_pathModifiedModifiableFiles);
        this.m_pathModifiedModifiableFiles.clear();
        return renamed;
    }

    public boolean consumeAllModifiablePaths() {
        boolean consumed = false;
        consumed = !this.consumeModifiedModifiableFiles().isEmpty();
        consumed = !this.consumePathModifiedModifiableFiles().isEmpty() || consumed;
        consumed = !this.consumeAdditionalInformationModifiedModifiableFiles().isEmpty() || consumed;
        consumed = !this.consumeSavedModifiableFiles().isEmpty() || consumed;
        consumed = !this.consumeCreatedModifiableFiles().isEmpty() || consumed;
        consumed = !this.consumeDeletedModifiableFiles().isEmpty() || consumed;
        consumed = !this.consumeReloadedModifiableFiles().isEmpty() || consumed;
        consumed = !this.consumeCreatedModifiableDirectoryPaths().isEmpty() || consumed;
        consumed = !this.consumeModifiedModifiableDirectoryPaths().isEmpty() || consumed;
        consumed = !this.consumeDeletedModifiableDirectoryPaths().isEmpty() || consumed;
        return consumed;
    }

    @Override
    public void pathModified(IModifiableFile modifiableFile, String previousPath) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'moved' must not be null";
        assert (previousPath != null && previousPath.length() > 0) : "Parameter 'previousPath' of method 'moved' must not be empty";
        this.m_pathModifiedModifiableFiles.put(modifiableFile, previousPath);
        if (!this.m_modifiedModifiableFiles.contains(modifiableFile)) {
            this.m_modifiedModifiableFiles.add(modifiableFile);
        }
    }

    public List<IModifiableFile> getModifiableFilesNeedingSave() {
        ArrayList<IModifiableFile> needingSave = new ArrayList<IModifiableFile>();
        for (IModifiableFile next : this.m_modifiableFiles) {
            if (!next.needsSave()) continue;
            needingSave.add(next);
        }
        return Collections.unmodifiableList(needingSave);
    }

    @Override
    public boolean modifiableFilesNeedSave() {
        for (IModifiableFile next : this.m_modifiableFiles) {
            if (!next.needsSave()) continue;
            return true;
        }
        return false;
    }

    public List<IModifiableFile> getModifiableFiles() {
        return Collections.unmodifiableList(this.m_modifiableFiles);
    }

    public boolean modifiableFilesOrDirectoriesModified(boolean includeAdditionalInfo) {
        return !this.m_createdModifiableFiles.isEmpty() || !this.m_modifiedModifiableDirectoryPaths.isEmpty() || !this.m_deletedModifiableDirectoryPaths.isEmpty() || !this.m_deletedModifiableFiles.isEmpty() || !this.m_modifiedModifiableFiles.isEmpty() || !this.m_reloadedModifiableFiles.isEmpty() || !this.m_savedModifiableFiles.isEmpty() || includeAdditionalInfo && !this.m_additionalInformationModifiedModifiableFiles.isEmpty();
    }

    public List<Pair<IModifiableFile, ConflictState>> getConflictStates(List<IModifiableFile> files) {
        assert (files != null) : "Parameter 'files' of method 'getConflictStates' must not be null";
        ArrayList<Pair<IModifiableFile, ConflictState>> states = new ArrayList<Pair<IModifiableFile, ConflictState>>(files.size());
        for (IModifiableFile next : files) {
            if (!next.needsSave()) continue;
            if (!next.existsOnDisk()) {
                states.add((Pair<IModifiableFile, ConflictState>)new Pair((Object)next, (Object)ConflictState.NO_CONFLICT));
                continue;
            }
            if (!next.getFile().exists()) {
                states.add((Pair<IModifiableFile, ConflictState>)new Pair((Object)next, (Object)ConflictState.DELETED_ON_DISK));
                continue;
            }
            if (next.getFile().lastModified() != next.getTimestamp()) {
                states.add((Pair<IModifiableFile, ConflictState>)new Pair((Object)next, (Object)ConflictState.MODIFIED_ON_DISK));
                continue;
            }
            states.add((Pair<IModifiableFile, ConflictState>)new Pair((Object)next, (Object)ConflictState.NO_CONFLICT));
        }
        return states;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public SoftwareSystemBaseDirectory getBaseDirectory() {
        SoftwareSystemBaseDirectory baseDirectory = this.getUniqueChild(SoftwareSystemBaseDirectory.class);
        assert (baseDirectory != null) : "'baseDirectory' of method 'getBaseDirectory' must not be null";
        return baseDirectory;
    }

    @Override
    public SoftwareSystemDirectory getSystemDirectory() {
        SoftwareSystemBaseDirectory baseDirectory = this.getUniqueChild(SoftwareSystemBaseDirectory.class);
        assert (baseDirectory != null) : "'baseDirectory' of method 'getDataDirectory' must not be null";
        SoftwareSystemDirectory systemDirectory = baseDirectory.getUniqueChild(SoftwareSystemDirectory.class);
        assert (systemDirectory != null) : "'systemDirectory' of method 'getDataDirectory' must not be null";
        return systemDirectory;
    }

    @Override
    public TFile getSystemDirectoryFile() {
        return this.getSystemDirectory().getDirectoryFile();
    }

    public SoftwareSystemFile getSoftwareSystemFile() {
        return this.getSystemDirectory().getUniqueExistingChild(SoftwareSystemFile.class);
    }

    public Analyzers getAnalyzers() {
        return this.getSystemDirectory().getUniqueExistingChild(Analyzers.class);
    }

    public SoftwareSystemSettingsDirectory getSoftwareSystemSettingsDirectory() {
        return this.getSystemDirectory().getUniqueExistingChild(SoftwareSystemSettingsDirectory.class);
    }

    public GroovyScripts getGroovyScripts() {
        return this.getSystemDirectory().getUniqueExistingChild(GroovyScripts.class);
    }

    public Dashboards getDashboards() {
        return this.getSystemDirectory().getUniqueExistingChild(Dashboards.class);
    }

    public Architecture getArchitecture() {
        return this.getSystemDirectory().getUniqueExistingChild(Architecture.class);
    }

    public VirtualModels getVirtualModels() {
        return this.getSystemDirectory().getUniqueExistingChild(VirtualModels.class);
    }

    public ArchitecturalViewsDirectory getArchitecturalViews() {
        return this.getSystemDirectory().getUniqueExistingChild(ArchitecturalViewsDirectory.class);
    }

    public <D extends SoftwareSystemFilesDirectory> D getSoftwareSystemFilesDirectory(Class<D> directoryClass) {
        assert (directoryClass != null) : "Parameter 'directoryClass' of method 'getSoftwareSystemFilesDirectory' must not be null";
        return (D)((SoftwareSystemFilesDirectory)this.getSystemDirectory().getUniqueExistingChild(directoryClass));
    }

    public WorkspaceProfiles getWorkspaceProfilesDirectory() {
        return this.getSystemDirectory().getUniqueExistingChild(WorkspaceProfiles.class);
    }

    public PluginConfigurations getPluginConfigurationDirectory() {
        return this.getSystemDirectory().getUniqueExistingChild(PluginConfigurations.class);
    }

    public QualityGates getQualityGatesDirectory() {
        return this.getSystemDirectory().getUniqueExistingChild(QualityGates.class);
    }

    public BaselinesDirectory getBaselinesDirectory() {
        return this.getSystemDirectory().getUniqueExistingChild(BaselinesDirectory.class);
    }

    @Override
    public ParserModel getParserModel() {
        return this.getVirtualModels().getUniqueExistingChild(ParserModel.class);
    }

    @Override
    public List<VirtualModel> getAvailableVirtualModels() {
        return this.getVirtualModels().getChildrenRecursively(VirtualModel.class, new Class[0]);
    }

    @Override
    public void setSystemId(String systemId) {
        assert (systemId != null && systemId.length() > 0) : "Parameter 'systemId' of method 'setSystemId' must not be empty";
        this.getSoftwareSystemFile().setFileId(systemId);
    }

    @Override
    public TFile getSystemFile() {
        return this.getSoftwareSystemFile().getFile();
    }

    @Override
    public TFile getSystemBaseDirectory() {
        return this.getBaseDirectory().getDirectoryFile();
    }

    @Override
    public void setSystemNeedsSave(boolean needsSave) {
        this.getSoftwareSystemFile().setNeedsSave(needsSave);
    }

    @Override
    public boolean systemNeedsSave() {
        return this.getSoftwareSystemFile().needsSave();
    }

    @Override
    public long getSystemFileTimestamp() {
        return this.getSoftwareSystemFile().getTimestamp();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
    }

    public Optional<IModifiableFile> findById(String fileId) {
        assert (fileId != null) : "Parameter 'fileId' of method 'findById' must not be null";
        return this.m_modifiableFiles.stream().filter(f -> f.getFileId().equals(fileId)).findFirst();
    }

    public static enum ConflictState implements IStandardEnumeration
    {
        MODIFIED_ON_DISK("File has also been modified on disk"),
        DELETED_ON_DISK("File has been deleted on disk"),
        NO_CONFLICT("File has not been changed or deleted on disk");

        private String m_presentationName;

        private ConflictState(String presentationName) {
            this.m_presentationName = presentationName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_presentationName;
        }
    }
}

