/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;

public final class ScriptDependencyTreeNode
extends ScriptTreeNode {
    private final AggregatedDependency m_dependency;

    public ScriptDependencyTreeNode(AggregatedDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'ScriptDependencyNode' must not be null";
        this.m_dependency = dependency;
    }

    @Override
    public Element getElement() {
        return this.m_dependency.getNumberOfDependencies() == 1 ? this.m_dependency.getFirstDependency() : null;
    }

    @Override
    public String getImageResourceName() {
        return "Dependency";
    }

    @Override
    public String getName() {
        int lineNumber = this.m_dependency.getLineNumber();
        if (lineNumber == -1) {
            return this.m_dependency.getPresentationName(false) + " (" + this.m_dependency.getNumberOfDependencies() + " references)";
        }
        return this.m_dependency.getPresentationName(false) + " at line " + lineNumber;
    }
}

