/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.ICloneable;
import com.hello2morrow.sonargraph.core.model.element.IElementMapper;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class RefactoringStateHandler
implements IElementMapper {
    private final Map<NamedElement, NamedElement> m_originalToClone = new THashMap();
    private final Map<NamedElement, NamedElement> m_cloneToOriginal = new THashMap();
    private final Map<ElementWithIssues, DeletionState> m_deletedElements = new THashMap();
    private final Set<NamedElement> m_createdElements = new THashSet();

    public void reset() {
        ArrayList<NamedElement> toBeDeleted;
        if (!this.m_createdElements.isEmpty()) {
            toBeDeleted = new ArrayList<NamedElement>(this.m_createdElements);
            toBeDeleted.sort((n1, n2) -> n2.getName().compareTo(n1.getName()));
            for (NamedElement nextCreated : toBeDeleted) {
                assert (!this.m_cloneToOriginal.containsKey(nextCreated)) : "'nextCreated'  of method 'reset' must not be a clone: " + String.valueOf(nextCreated);
                NamedElement nextCreatedParent = nextCreated.getParent();
                if (nextCreatedParent == null) continue;
                nextCreatedParent.removeChild(nextCreated);
                nextCreated.setParent(null);
            }
        }
        if (!this.m_cloneToOriginal.isEmpty()) {
            toBeDeleted = new ArrayList<NamedElement>(this.m_cloneToOriginal.keySet());
            toBeDeleted.sort((n1, n2) -> n2.getName().compareTo(n1.getName()));
            for (NamedElement nextClone : toBeDeleted) {
                NamedElement nextCloneParent = nextClone.getParent();
                if (nextCloneParent == null) continue;
                nextCloneParent.performRemoveChild(nextClone);
                NamedElement nextCloneParentOriginal = this.getOriginal(nextCloneParent);
                if (nextCloneParent != nextCloneParentOriginal) {
                    nextCloneParentOriginal.performRemoveChild(nextClone);
                }
                nextClone.setParent(null);
            }
        }
        this.m_cloneToOriginal.clear();
        this.m_createdElements.clear();
        this.m_deletedElements.clear();
        this.m_originalToClone.clear();
    }

    public <T extends ICloneable> T getModifiableVersionOf(T toBeCloned) {
        assert (toBeCloned != null) : "Parameter 'toBeCloned' of method 'getModifiableVersionOf' must not be null";
        NamedElement toBeClonedAsNamedElement = toBeCloned.getNamedElement();
        if (this.m_createdElements.contains(toBeClonedAsNamedElement)) {
            return toBeCloned;
        }
        if (this.m_cloneToOriginal.get(toBeClonedAsNamedElement) != null) {
            return (T)((ICloneable)((Object)toBeClonedAsNamedElement));
        }
        NamedElement clone = this.m_originalToClone.get(toBeClonedAsNamedElement);
        if (clone != null) {
            return (T)((ICloneable)((Object)clone));
        }
        clone = toBeClonedAsNamedElement.clone();
        this.m_originalToClone.put(toBeClonedAsNamedElement, clone);
        this.m_cloneToOriginal.put(clone, toBeClonedAsNamedElement);
        return (T)((ICloneable)((Object)clone));
    }

    public boolean hasBeenAddedAsCreated(NamedElement candidate) {
        assert (candidate != null) : "Parameter 'candidate' of method 'hasBeenAddedAsCreated' must not be null";
        return this.m_createdElements.contains(candidate);
    }

    public void addCreated(NamedElement created) {
        assert (created != null) : "Parameter 'created' of method 'created' must not be null";
        assert (!this.m_createdElements.contains(created)) : "Already created: " + String.valueOf(created);
        this.m_createdElements.add(created);
    }

    private boolean removeChildFromParent(NamedElement child, NamedElement parent) {
        assert (child != null) : "Parameter 'child' of method 'removeChildFromParent' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'removeChildFromParent' must not be null";
        assert (child != parent) : "Same instances";
        if (parent.performRemoveChild(child)) {
            return true;
        }
        NamedElement originalChild = this.getOriginal(child);
        return originalChild != child && parent.performRemoveChild(originalChild);
    }

    public void moveToNewParent(ICloneable currentParent, IRefactorable toBeMoved, ICloneable newParent) {
        assert (currentParent != null) : "Parameter 'currentParent' of method 'moveToNewParent' must not be null";
        assert (toBeMoved != null) : "Parameter 'toBeMoved' of method 'moveToNewParent' must not be null";
        assert (newParent != null) : "Parameter 'newParent' of method 'moveToNewParent' must not be null";
        assert (currentParent != newParent) : "Different instances expected (1)";
        assert (currentParent != toBeMoved) : "Different instances expected (2)";
        assert (newParent != toBeMoved) : "Different instances expected (3)";
        NamedElement currentParentCloneAsNamedElement = this.getModifiableVersionOf(currentParent).getNamedElement();
        if (this.removeChildFromParent(toBeMoved.getNamedElement(), currentParentCloneAsNamedElement) && currentParentCloneAsNamedElement.removeOnLastChildRemoval()) {
            do {
                this.setIndirectlyDeleted(currentParentCloneAsNamedElement);
            } while ((currentParentCloneAsNamedElement = currentParentCloneAsNamedElement.getParent()).removeOnLastChildRemoval() && this.allChildrenDeleted(currentParentCloneAsNamedElement));
        }
        IRefactorable toBeMovedClone = this.getModifiableVersionOf(toBeMoved);
        ICloneable newParentClone = this.m_createdElements.contains(newParent.getNamedElement()) ? newParent : this.getModifiableVersionOf(newParent);
        toBeMovedClone.getNamedElement().setParent(newParentClone.getNamedElement());
        newParentClone.getNamedElement().addChild(toBeMovedClone.getNamedElement());
        this.m_deletedElements.remove(newParent.getNamedElement());
    }

    @Override
    public <T extends ElementWithIssues> T mapElement(T element) {
        if (element == null) {
            return null;
        }
        ElementWithIssues mappedElement = this.m_originalToClone.get(element);
        return (T)(mappedElement == null ? element : mappedElement);
    }

    @Override
    public <T extends ElementWithIssues> T getOriginal(T element) {
        assert (element != null) : "Parameter 'element' of method 'getOriginal' must not be null";
        ElementWithIssues original = this.m_cloneToOriginal.get(element);
        return (T)(original == null ? element : original);
    }

    @Override
    public RefactoringState getRefactoringState(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getRefactoringState' must not be null";
        DeletionState deletionState = this.m_deletedElements.get(element);
        if (deletionState != null) {
            switch (deletionState) {
                case DELETED: 
                case INDIRECTLY_DELETED: {
                    return RefactoringState.DELETED;
                }
            }
            assert (false) : "Unhandled deletion state: " + String.valueOf((Object)deletionState);
            return RefactoringState.NONE;
        }
        if (element instanceof IRefactorable) {
            Element original = this.m_cloneToOriginal.get(element);
            if (original != null) {
                return RefactoringState.REFACTORED;
            }
            if (this.m_createdElements.contains(element)) {
                return RefactoringState.REFACTORED;
            }
        }
        return RefactoringState.NONE;
    }

    @Override
    public void elementRemoved(Element element) {
        assert (element != null) : "Parameter 'element' of method 'elementRemoved' must not be null";
        NamedElement original = this.m_cloneToOriginal.remove(element);
        if (original != null) {
            NamedElement clone = this.m_originalToClone.remove(original);
            assert (clone == element) : "Clone does not match: " + String.valueOf(clone) + "/" + String.valueOf(element);
        } else {
            NamedElement clone = this.m_originalToClone.remove(element);
            if (clone != null) {
                original = this.m_cloneToOriginal.remove(clone);
                assert (original == element) : "Original does not match: " + String.valueOf(original) + "/" + String.valueOf(element);
            }
        }
        this.m_deletedElements.remove(element);
        this.m_createdElements.remove(element);
    }

    public boolean hasBeenDeleted(ElementWithIssues element) {
        DeletionState deletionState = this.m_deletedElements.get(element);
        return deletionState != null;
    }

    public boolean hasBeenDirectlyDeleted(ElementWithIssues element) {
        DeletionState deletionState = this.m_deletedElements.get(element);
        return deletionState != null ? deletionState == DeletionState.DELETED : false;
    }

    public boolean hasBeenIndirectlyDeleted(ElementWithIssues element) {
        DeletionState deletionState = this.m_deletedElements.get(element);
        return deletionState != null ? deletionState == DeletionState.INDIRECTLY_DELETED : false;
    }

    public void setDirectlyDeleted(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'setDeletionState' must not be null";
        this.m_deletedElements.put(element, DeletionState.DELETED);
    }

    public void setIndirectlyDeleted(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'setDeletionState' must not be null";
        this.m_deletedElements.put(element, DeletionState.INDIRECTLY_DELETED);
    }

    public boolean allChildrenDeleted(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'lastChildRemoved' must not be null";
        if (parent instanceof IComponent) {
            for (NamedElement namedElement : parent.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                if (this.hasBeenDeleted(namedElement)) continue;
                return false;
            }
        } else if (parent instanceof IRecursiveElement && !(parent instanceof ProgrammingElement)) {
            for (NamedElement namedElement : parent.getChildrenRecursively(parent.getClass(), IComponent.class, ProgrammingElement.class)) {
                if (this.hasBeenDeleted(namedElement)) continue;
                return false;
            }
            for (IComponent iComponent : parent.getChildren(IComponent.class)) {
                if (this.hasBeenDeleted(iComponent.getNamedElement())) continue;
                return false;
            }
        } else {
            for (NamedElement namedElement : parent.getChildren()) {
                if (this.hasBeenDeleted(namedElement)) continue;
                return false;
            }
        }
        return true;
    }

    static enum DeletionState {
        DELETED,
        INDIRECTLY_DELETED;

    }
}

