/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.LogicalStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IExternalContainer;
import com.hello2morrow.sonargraph.core.model.programming.ExternalElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalRoot;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public final class PhysicalElementBasedExternalLogicalRoot
extends LogicalRoot
implements IArchitectureFilterNamePrefixProvider,
IArchitectureFilterNameProvider {
    private final Map<NamedElement, ExternalElementContainer> m_elementToExternalElementContainer = new THashMap();
    private final NamedElement m_element;

    public PhysicalElementBasedExternalLogicalRoot(NamedElement parent, NamedElement element) {
        super(parent);
        assert (element != null) : "Parameter 'element' of method 'PhysicalElementBasedLogicalRoot' must not be null";
        assert (element.isExternal()) : "Must be external: " + String.valueOf(element);
        this.m_element = element;
    }

    @Override
    public NamedElement getPhysicalElement() {
        return this.m_element;
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return this.m_element.getImageResourceName();
    }

    @Override
    public void addChild(NamedElement child) {
        assert (child instanceof ExternalElementContainer) : "Parameter 'child' of method 'addChild' must not be null";
        super.addChild(child);
        ExternalElementContainer container = (ExternalElementContainer)child;
        this.m_elementToExternalElementContainer.put(container.getExternal(), container);
    }

    public void addMapping(NamedElement file, ExternalElementContainer container) {
        assert (file != null) : "Parameter 'file' of method 'addMapping' must not be null";
        assert (container != null) : "Parameter 'container' of method 'addMapping' must not be null";
        this.m_elementToExternalElementContainer.put(file, container);
    }

    public LogicalNamespace getGlobalNamespaceFor(IExternalContainer container) {
        assert (container != null) : "Parameter 'container' of method 'getGlobalNamespaceFor' must not be null";
        assert (container.getLanguage() == this.getLanguage()) : "not the same language (container/this): " + String.valueOf(container.getLanguage()) + "/" + String.valueOf(this.getLanguage());
        ExternalElementContainer logicalContainer = this.m_elementToExternalElementContainer.get(container.getElement());
        assert (logicalContainer != null) : "Missing external element container for " + String.valueOf(container.getElement());
        return logicalContainer.getChildren(LogicalNamespace.class).stream().filter(lns -> lns.isGlobal()).findFirst().orElse(null);
    }

    @Override
    public String getName() {
        return this.m_element.getName();
    }

    @Override
    public String getShortName() {
        return this.m_element.getShortName();
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public Language getLanguage() {
        return this.m_element.getLanguage();
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return this.m_element.getFullyQualifiedNamePart();
    }

    @Override
    public String getPresentationName(boolean parentIsPresented) {
        return this.m_element.getPresentationName(parentIsPresented);
    }

    @Override
    public String getDescription() {
        return this.m_element.getDescription();
    }

    @Override
    public IStructureItem getStructureItem() {
        return LogicalStructureItem.LOGICAL_NAMESPACE_ROOT;
    }

    @Override
    public String getArchitectureFilterNamePrefix() {
        return this.m_element.getShortName() + "/";
    }

    @Override
    public String getArchitectureFilterName() {
        return this.m_element.getShortName() + "/**";
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        return IDomainRoot.Domain.LOGICAL_MODULE_SCOPE;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPhysicalElementBasedExternalLogicalRoot(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitPhysicalElementBasedExternalLogicalRoot(PhysicalElementBasedExternalLogicalRoot var1);
    }
}

