/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.path;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class PhysicalRecursiveElement
extends NamedElementContainer
implements IRecursiveElement,
IRefactorable,
IRefactoringTarget {
    private IModelServiceProvider m_msp;
    private String m_shortName;

    public PhysicalRecursiveElement(NamedElement parent) {
        super(parent);
    }

    public PhysicalRecursiveElement(IModelServiceProvider msp, NamedElement parent, String shortName) {
        super(parent);
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'NamespaceFragment' must not be empty";
        this.m_shortName = shortName.intern();
        this.m_msp = msp;
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public final String getShortName() {
        return this.m_shortName;
    }

    public final void setShortName(String shortName) {
        assert (shortName != null && shortName.length() > 0) : "Parameter 'name' of method 'setShortName' must not be empty";
        this.m_shortName = shortName;
    }

    @Property
    public String getRelativeDirectoryPath() {
        return null;
    }

    public final TFile getPhysicalCorrespondent() {
        TFile directoryFile;
        IBaseDirectory baseDirectory;
        String relativeDirectoryPath = this.getRelativeDirectoryPath();
        if (relativeDirectoryPath != null && (baseDirectory = this.getParent(IBaseDirectory.class, new Class[0])) != null && (directoryFile = baseDirectory.getDirectoryFile()) != null) {
            if (relativeDirectoryPath.equals(".")) {
                return directoryFile;
            }
            assert (relativeDirectoryPath.startsWith("./")) : "Not the right format: " + relativeDirectoryPath;
            return new TFile((File)directoryFile, relativeDirectoryPath.substring("./".length()));
        }
        return null;
    }

    @Override
    @Property
    public final boolean isExternal() {
        return this.getParent().isExternal();
    }

    @Override
    public final String getOriginalName() {
        StringBuilder builder = new StringBuilder();
        this.appendShortName(builder, true);
        return builder.toString();
    }

    private void appendShortName(StringBuilder builder, boolean original) {
        NamedElement parent;
        assert (builder != null) : "Parameter 'builder' of method 'appendShortName' must not be null";
        NamedElement namedElement = parent = original ? this.getOriginal().getParent().getOriginal() : this.getParent();
        if (parent != null && this.getClass().isAssignableFrom(parent.getClass())) {
            ((PhysicalRecursiveElement)parent).appendShortName(builder, original);
            builder.append(this.getSeparator());
        }
        builder.append(original ? this.getOriginalShortName() : this.getShortName());
    }

    @Override
    public final String getName() {
        StringBuilder builder = new StringBuilder();
        this.appendShortName(builder, false);
        return builder.toString();
    }

    @Override
    @Property
    public final boolean isPart() {
        Class<?> clazz = this.getClass();
        for (NamedElement next : this.getChildren()) {
            if (clazz.isAssignableFrom(next.getClass())) continue;
            return false;
        }
        return true;
    }

    @Override
    @Property
    public final boolean isMixable() {
        return this.getChildren().size() == 1 && this.getChildren().get(0) instanceof IRecursiveElement;
    }

    @Override
    protected final void lastChildRemoved() {
        this.remove();
    }

    @Override
    public final boolean removeOnLastChildRemoval() {
        return true;
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    @Override
    public NamedElement getParent() {
        return this.getParent(this.m_msp);
    }

    @Override
    public List<NamedElement> getChildren() {
        return this.getChildren(this.m_msp);
    }

    @Override
    public NamedElement getOriginal() {
        return this.getOriginal(this.m_msp);
    }

    @Override
    public NamedElement getRepresentative() {
        return this.getRepresentative(this.m_msp);
    }

    @Override
    public final void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    public final IModelServiceProvider getModelServiceProvider() {
        return this.m_msp;
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    @Override
    public final ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    @Override
    public final IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_shortName);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_shortName = reader.readString();
    }

    @Override
    @Property
    public final String getInformation() {
        IDomainRoot context = this.getParent(IDomainRoot.class, new Class[0]);
        if (context != null) {
            return context.getDomainInfo();
        }
        return "";
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPhysicalRecursiveElement(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String toString() {
        if (this.m_msp != null && this.m_msp.getCurrentModel().getOriginal(this) != this) {
            StringBuilder builder = new StringBuilder("[Clone] ");
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitPhysicalRecursiveElement(PhysicalRecursiveElement var1);
    }
}

