/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PartialAlternativeInfo {
    private final List<ArchitecturalViewNode> m_replaceablePartialNodes;
    private final List<ArchitecturalViewNode> m_alternativeNodes;

    public PartialAlternativeInfo(List<ArchitecturalViewNode> replaceablePartialNodes, List<ArchitecturalViewNode> alternativeNodes) {
        assert (replaceablePartialNodes != null && !replaceablePartialNodes.isEmpty()) : "Parameter 'replaceablePartialNodes' of method 'PartialAlternativeInfo' must not be empty";
        assert (alternativeNodes != null && !alternativeNodes.isEmpty()) : "Parameter 'alternativeNodes' of method 'PartialAlternativeInfo' must not be empty";
        this.m_replaceablePartialNodes = new ArrayList<ArchitecturalViewNode>(replaceablePartialNodes);
        this.m_alternativeNodes = new ArrayList<ArchitecturalViewNode>(alternativeNodes);
        assert (Collections.disjoint(this.m_replaceablePartialNodes, this.m_alternativeNodes)) : "Must not have nodes in common";
    }

    public boolean containsReplaceableNNodes() {
        return !this.m_replaceablePartialNodes.isEmpty();
    }

    public List<ArchitecturalViewNode> getAlternativeNodes() {
        return Collections.unmodifiableList(this.m_alternativeNodes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        if (this.containsReplaceableNNodes()) {
            builder.append(" contains ").append(this.m_replaceablePartialNodes.size()).append(" replaceable node(s) with ").append(this.m_alternativeNodes.size()).append(" alternative node(s)");
            for (ArchitecturalViewElement architecturalViewElement : this.m_replaceablePartialNodes) {
                builder.append("\n");
                builder.append("Replaceable: ").append(architecturalViewElement.getElementInfo(true, false));
            }
            for (ArchitecturalViewElement architecturalViewElement : this.m_alternativeNodes) {
                builder.append("\n");
                builder.append("Alternative: ").append(architecturalViewElement.getElementInfo(true, false));
            }
        } else {
            builder.append(" is empty");
        }
        return builder.toString();
    }
}

