/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOperationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public final class ExplorationViewOnDemand
extends NamedElementContainer
implements IExplorationViewRepresentationOwner {
    private final ExplorationViewStructureMode m_mode;
    private final NamedElement m_reveal;
    private final ArchitectureFile m_architectureFile;
    private final Map<NamedElement, Artifact> m_artifactMapping;
    private final AnalyzerCycleGroup m_cycleGroup;
    private final Date m_timestamp;
    private Set<NamedElement> m_namedElements;
    private Set<ParserDependency> m_focusParserDependencies;
    private ArchitecturalViewNode m_nodeToBeRevealed;

    public ExplorationViewOnDemand(ExplorationViewStructureMode mode, Set<NamedElement> namedElements, Set<ParserDependency> focusParserDependencies, NamedElement reveal, ArchitectureFile architectureFile) {
        super(null);
        assert (mode != null) : "Parameter 'mode' of method 'ExplorationViewOnDemand' must not be null";
        assert (namedElements != null) : "Parameter 'elements' of method 'ExplorationViewOnDemand' must not be null";
        assert (focusParserDependencies != null) : "Parameter 'focusParserDependencies' of method 'ExplorationViewOnDemand' must not be null";
        this.m_mode = mode;
        this.m_namedElements = namedElements.isEmpty() ? Collections.emptySet() : new THashSet(namedElements);
        this.m_artifactMapping = architectureFile != null ? new THashMap() : null;
        this.m_focusParserDependencies = focusParserDependencies.isEmpty() ? Collections.emptySet() : new THashSet(focusParserDependencies);
        this.m_reveal = reveal;
        this.m_architectureFile = architectureFile;
        this.m_cycleGroup = null;
        this.m_timestamp = new Date();
    }

    public ExplorationViewOnDemand(ExplorationViewStructureMode mode, AnalyzerCycleGroup cycleGroup, ArchitectureFile architectureFile) {
        super(null);
        assert (mode != null) : "Parameter 'mode' of method 'ExplorationViewOnDemand' must not be null";
        assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'ExplorationViewOnDemand' must not be null";
        this.m_mode = mode;
        this.m_namedElements = Collections.emptySet();
        this.m_artifactMapping = architectureFile != null ? new THashMap() : null;
        this.m_focusParserDependencies = Collections.emptySet();
        this.m_reveal = null;
        this.m_architectureFile = architectureFile;
        this.m_cycleGroup = cycleGroup;
        this.m_timestamp = new Date();
    }

    @Override
    public String getImageResourceName() {
        return "ExplorationView";
    }

    public void setNamedElements(Set<NamedElement> namedElements) {
        assert (namedElements != null) : "Parameter 'namedElements' of method 'setNamedElements' must not be null";
        if (!namedElements.isEmpty()) {
            this.m_namedElements = new THashSet(namedElements);
        }
    }

    public void setArtifactMapping(Map<NamedElement, Artifact> artifactMapping) {
        assert (artifactMapping != null) : "Parameter 'artifactMapping' of method 'setArtifactMapping' must not be null";
        assert (this.m_architectureFile != null) : "'m_architectureFile' of method 'setArtifactMapping' must not be null";
        this.m_artifactMapping.putAll(artifactMapping);
    }

    public void setFocusParserDependencies(Set<ParserDependency> focusParserDependencies) {
        assert (focusParserDependencies != null) : "Parameter 'focusParserDependencies' of method 'setFocusParserDependencies' must not be null";
        this.m_focusParserDependencies = new THashSet(focusParserDependencies);
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    public ExplorationViewStructureMode getStructureMode() {
        return this.m_mode;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return String.valueOf(this.hashCode());
    }

    public ArchitectureFile getArchitectureFile() {
        return this.m_architectureFile;
    }

    public Map<NamedElement, Artifact> getArtifactMapping() {
        return this.m_artifactMapping != null ? Collections.unmodifiableMap(this.m_artifactMapping) : null;
    }

    public AnalyzerCycleGroup getCycleGroup() {
        return this.m_cycleGroup;
    }

    public Set<NamedElement> getNamedElements() {
        return Collections.unmodifiableSet(this.m_namedElements);
    }

    public Set<ParserDependency> getFocusParserDependencies() {
        return Collections.unmodifiableSet(this.m_focusParserDependencies);
    }

    public NamedElement getToBeRevealed() {
        return this.m_reveal;
    }

    public void setNodeToReveal(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'setNodeToReveal' must not be null";
        this.m_nodeToBeRevealed = node;
    }

    public ArchitecturalViewNode getNodeToBeRevealed() {
        return this.m_nodeToBeRevealed;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public String getShortName() {
        return (String)(this.m_architectureFile == null ? "" : this.m_architectureFile.getIdentifyingPath() + ": ") + StringUtility.getTimeDateStringFromLocale((Date)this.m_timestamp);
    }

    @Override
    public String getId() {
        return this.getShortName();
    }

    @Override
    public String getViewImageResourceName() {
        return "ExplorationView";
    }

    @Override
    public ExplorationViewOperationMode getOperationMode() {
        if (this.m_architectureFile != null) {
            return this.m_mode.isLogical() ? ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_LOGICAL : ExplorationViewOperationMode.ARCHITECTURE_EXPLORATION_PHYSICAL;
        }
        return this.m_mode.isLogical() ? ExplorationViewOperationMode.SYSTEM_EXPLORATION_LOGICAL : ExplorationViewOperationMode.SYSTEM_EXPLORATION_PHYSICAL;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] " + this.getShortName() + " (" + this.m_mode.name() + ")";
    }
}

