/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewOperationExecutor;
import com.hello2morrow.sonargraph.core.model.path.FilePath;

public abstract class ArchitecturalViewOperation
extends NamedElement
implements IArchitecturalViewOperation {
    public static final String INHERITED_OPERATION_IMAGE_RESOURCE_NAME = "OperationInherited";
    private final PresentationMode m_presentationMode;
    private NamedElement m_inheritedFrom;
    private int m_index;

    public ArchitecturalViewOperation(NamedElement parent, PresentationMode presentationMode) {
        super(parent);
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'ArchitecturalViewOperation' must not be null";
        this.m_presentationMode = presentationMode;
    }

    protected ArchitecturalViewOperation(NamedElement parent, ArchitecturalViewOperation copyOf) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ArchitecturalViewOperation' must not be null";
        assert (copyOf != null) : "Parameter 'copyOf' of method 'ArchitecturalViewOperation' must not be null";
        this.m_presentationMode = copyOf.m_presentationMode;
    }

    @Override
    public final PresentationMode getPresentationMode() {
        return this.m_presentationMode;
    }

    public final NamedElement getInheritedFrom() {
        return this.m_inheritedFrom;
    }

    public final void setInheritedFrom(NamedElement inheritedFrom) {
        this.m_inheritedFrom = inheritedFrom;
    }

    @Override
    public final int getIndex() {
        return this.m_index;
    }

    public final void setIndex(int index) {
        this.m_index = index;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        return super.getFullyQualifiedNamePart() + Element.INNER_NAME_PARTS_SEPARATOR + this.m_index;
    }

    @Override
    public final NamedElement getNamedElement() {
        return this;
    }

    @Override
    public final FilePath getDefiningFile() {
        return this.getParent(FilePath.class, new Class[0]);
    }

    @Override
    public ImageDecoratorInfo getImageResourceDecoratorInfo() {
        if (this.hasIssues(CoreIssueId.ARCHITECTURAL_VIEW_OPERATION_NOT_APPLICABLE)) {
            return new ImageDecoratorInfo("WarningMarker", null, null, null);
        }
        return super.getImageResourceDecoratorInfo();
    }

    public abstract void apply(IArchitecturalViewOperationExecutor var1);

    public void reset() {
    }

    public boolean containsRefactoring() {
        return false;
    }

    @Override
    public String getInformation() {
        return "[" + this.m_presentationMode.getPresentationName() + "]";
    }

    public abstract ArchitecturalViewOperation copy(NamedElement var1);

    @Override
    public String toString() {
        return "[" + this.m_index + "] '" + String.valueOf((Object)this.m_presentationMode) + "' mode" + (String)(this.m_inheritedFrom != null ? ", inherited from '" + String.valueOf(this.m_inheritedFrom) + "'" : "") + "\nInformation:" + this.getInformation();
    }
}

