/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.model.element.IElement;
import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Element
implements IElement,
ISnapshotWriter.IStorable,
ISnapshotReader.IRetrievable,
Cloneable,
IPersistable {
    private static final char ESCAPE_AS_CHAR = '\\';
    private static final char[] CHARACTERS_TO_ESCAPE = new char[]{'@', ':'};

    public static final String escapeSpecialCharacters(String text) {
        assert (text != null) : "Parameter 'text' of method 'escapeSpecialCharacters' must not be null";
        if (text.isEmpty()) {
            return text;
        }
        StringBuilder builder = null;
        int i = 0;
        while (i < text.length()) {
            char nextChar = text.charAt(i);
            char[] cArray = CHARACTERS_TO_ESCAPE;
            int n = CHARACTERS_TO_ESCAPE.length;
            int n2 = 0;
            while (n2 < n) {
                char nextCharToEscape = cArray[n2];
                if (nextChar == nextCharToEscape) {
                    if (builder == null) {
                        builder = new StringBuilder(text.length() * 2);
                        builder.append(text, 0, i);
                    }
                    builder.append('\\');
                }
                ++n2;
            }
            if (builder != null) {
                builder.append(nextChar);
            }
            ++i;
        }
        return builder != null ? builder.toString() : text;
    }

    public static final String unescapeSpecialCharacters(String text) {
        assert (text != null) : "Parameter 'text' of method 'unescapeSpecialCharacters' must not be null";
        if (text.isEmpty()) {
            return text;
        }
        int posInText = text.indexOf(92);
        if (posInText < 0) {
            return text;
        }
        int textLength = text.length();
        StringBuilder builder = new StringBuilder(textLength);
        int lastPosToCopyFrom = 0;
        do {
            boolean removeEscapeChar = false;
            if (posInText + 1 < textLength) {
                char lookAheadChar = text.charAt(posInText + 1);
                char[] cArray = CHARACTERS_TO_ESCAPE;
                int n = CHARACTERS_TO_ESCAPE.length;
                int n2 = 0;
                while (n2 < n) {
                    char nextChar = cArray[n2];
                    if (nextChar == lookAheadChar) {
                        removeEscapeChar = true;
                        break;
                    }
                    ++n2;
                }
                if (removeEscapeChar) {
                    builder.append(text, lastPosToCopyFrom, posInText);
                } else {
                    builder.append(text, lastPosToCopyFrom, ++posInText);
                }
                lastPosToCopyFrom = ++posInText;
                posInText = text.indexOf(92, posInText);
                continue;
            }
            posInText = -1;
        } while (posInText > 0);
        builder.append(text, lastPosToCopyFrom, text.length());
        return builder.toString();
    }

    private static boolean handleSeparator(String token, boolean lastTokenWasSeparator, List<String> splitDescriptor) {
        assert (token != null) : "Parameter 'token' of method 'handleSeparator' must not be null";
        assert (splitDescriptor != null) : "Parameter 'splitDescriptor' of method 'handleSeparator' must not be null";
        if (token.equals(DESCRIPTOR_SEPARATOR) || token.equals(DESCRIPTOR_NAME_PARTS_SEPARATOR)) {
            if (lastTokenWasSeparator) {
                splitDescriptor.add("");
            }
            return true;
        }
        return false;
    }

    public static final List<String> splitDescriptor(String descriptor) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'splitDescriptor' must not be null";
        ArrayList<String> splittedDescriptor = new ArrayList<String>();
        StringBuilder descriptorPart = new StringBuilder();
        boolean previousCharWasEscape = false;
        boolean lastTokenWasSeparator = true;
        int i = 0;
        while (i < descriptor.length()) {
            char character = descriptor.charAt(i);
            if (!(character != ':' && character != '@' || previousCharWasEscape)) {
                splittedDescriptor.add(descriptorPart.toString());
                lastTokenWasSeparator = Element.handleSeparator(descriptorPart.toString(), lastTokenWasSeparator, splittedDescriptor);
                descriptorPart.setLength(0);
                if (character == '@') {
                    splittedDescriptor.add(String.valueOf(character));
                }
            } else if (character == '\\') {
                previousCharWasEscape = true;
            } else {
                previousCharWasEscape = false;
                descriptorPart.append(character);
            }
            if (i == descriptor.length() - 1 && descriptorPart.length() != 0) {
                splittedDescriptor.add(descriptorPart.toString());
            }
            ++i;
        }
        return splittedDescriptor;
    }

    protected Element() {
    }

    public abstract boolean isValid();

    public Element getElement() {
        return this;
    }

    public boolean isGhost() {
        return false;
    }

    public Element clone() {
        try {
            return (Element)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final boolean isProxy() {
        return this.getElement() != this;
    }

    public abstract String getShortName();

    @Property
    public String getName() {
        return this.getShortName();
    }

    public String getPresentationName(boolean shortName) {
        return shortName ? this.getShortName() : this.getName();
    }

    public final String getOriginalShortName() {
        return this.getOriginal().getShortName();
    }

    public String getOriginalName() {
        return this.getOriginal().getName();
    }

    public final String getOriginalPresentationName(boolean shortName) {
        return shortName ? this.getOriginalShortName() : this.getOriginalName();
    }

    public String getRawPresentationName(boolean shortName) {
        return shortName ? this.getShortName() : this.getName();
    }

    @Property
    public String getDescription() {
        return "";
    }

    @Property
    public String getInformation() {
        return "";
    }

    public boolean hasUnresolvedErrorIssues() {
        return false;
    }

    public boolean hasUnresolvedWarningIssues() {
        return false;
    }

    @Override
    @Property
    public boolean isExternal() {
        return false;
    }

    @Override
    @Property
    public boolean isExcluded() {
        return false;
    }

    @Property
    public boolean ignoreIssues() {
        return false;
    }

    public Element getOriginal() {
        return this;
    }

    public Element getRepresentative() {
        return this;
    }

    public RefactoringState getRefactoringState() {
        return RefactoringState.NONE;
    }

    public boolean hasBeenDirectlyRefactored() {
        return false;
    }

    @Property
    public final String getRefactoringInfo() {
        RefactoringState state = this.getRefactoringState();
        assert (state != null) : "Parameter 'state' of method 'refactoring' must not be null";
        if (state != RefactoringState.NONE) {
            return (this.hasBeenDirectlyRefactored() ? "" : "Indirectly ") + state.getPresentationName();
        }
        return "";
    }

    public final String getStandardPresentationKind() {
        return this.getClass().getSimpleName();
    }

    public String getPresentationKind() {
        return StringUtility.convertMixedCaseToHumanizedString((String)this.getClass().getSimpleName());
    }

    public String getImageResourceName() {
        return this.getClass().getSimpleName();
    }

    public ImageDecoratorInfo getImageResourceDecoratorInfo() {
        if (!this.isValid()) {
            return null;
        }
        boolean isExcluded = this.isExcluded();
        boolean ignoreIssues = this.ignoreIssues();
        String warningOrErrorMarker = null;
        if (this.hasUnresolvedErrorIssues()) {
            warningOrErrorMarker = "ErrorMarker";
        } else if (this.hasUnresolvedWarningIssues()) {
            warningOrErrorMarker = "WarningMarker";
        }
        boolean isExternal = this.isExternal();
        RefactoringState refactoringState = this.getRefactoringState();
        if (refactoringState != RefactoringState.NONE || isExcluded || ignoreIssues || warningOrErrorMarker != null || isExternal) {
            String one = null;
            String two = null;
            String three = null;
            String four = null;
            if (warningOrErrorMarker != null) {
                one = warningOrErrorMarker;
            }
            if (isExternal) {
                two = "ExternalMarker";
            }
            if (isExcluded) {
                assert (!ignoreIssues) : "Not expected 'ignoreIssues' for: " + String.valueOf(this);
                three = "ExcludedMarker";
            } else if (ignoreIssues) {
                three = "IgnoreIssuesMarker";
            }
            switch (refactoringState) {
                case DELETED: {
                    if (this.hasBeenDirectlyRefactored()) {
                        four = "DeletedMarker";
                        break;
                    }
                    four = "IndirectlyDeletedMarker";
                    break;
                }
                case REFACTORED: {
                    if (this.hasBeenDirectlyRefactored()) {
                        four = "RefactoredMarker";
                        break;
                    }
                    four = "IndirectlyRefactoredMarker";
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled deletion state: " + String.valueOf((Object)refactoringState);
                    break;
                }
            }
            return new ImageDecoratorInfo(one, two, three, four);
        }
        return null;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
    }

    @IntProperty
    public int getLineNumber() {
        return -1;
    }

    public abstract IPropertiesManager getPropertiesManager();

    public <T> T getProperty(String property, Class<T> cls) {
        IPropertiesManager propertiesManager = this.getPropertiesManager();
        if (propertiesManager == null) {
            return null;
        }
        return propertiesManager.getProperty(this, property, cls);
    }

    public final boolean hasProperty(String property) {
        IPropertiesManager propertiesManager = this.getPropertiesManager();
        if (propertiesManager == null) {
            return false;
        }
        return propertiesManager.hasProperty(this, property);
    }

    public final Map<String, Object> getProperties() {
        IPropertiesManager propertiesManager = this.getPropertiesManager();
        if (propertiesManager == null) {
            return Collections.emptyMap();
        }
        return propertiesManager.getProperties(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Class: ").append(this.getClass().getName());
        builder.append("\nName: '");
        try {
            builder.append(this.getName());
        }
        catch (Throwable exception) {
            builder.append("<unable to determine>");
        }
        builder.append("'\nShort name: '");
        try {
            builder.append(this.getShortName());
        }
        catch (Throwable exception) {
            builder.append("<unable to determine>");
        }
        builder.append("'");
        return builder.toString();
    }

    public String getDebugInfo() {
        String information;
        StringBuilder builder = new StringBuilder("Class: ");
        builder.append(this.getClass().getName()).append(" [").append(Integer.toHexString(this.hashCode())).append("]");
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Name: ");
        builder.append(this.getName());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Short name: ");
        builder.append(this.getShortName());
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Presentation name: ");
        builder.append(this.getPresentationName(false));
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Presentation name (short): ");
        builder.append(this.getPresentationName(true));
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Raw presentation name: ");
        builder.append(this.getRawPresentationName(false));
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append("Raw presentation name (short): ");
        builder.append(this.getRawPresentationName(true));
        String description = this.getDescription();
        if (description != null && !description.isEmpty()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Description: ");
            builder.append(description);
        }
        if ((information = this.getInformation()) != null && !information.isEmpty()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Information: ");
            builder.append(information);
        }
        if (this.isGhost()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Is Ghost");
        }
        if (this.isProxy()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Proxy for class: ");
            builder.append(this.getElement().getClass().getName());
        }
        for (Map.Entry<String, Object> nextPropertyEntry : this.getProperties().entrySet()) {
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("Property: ");
            builder.append(nextPropertyEntry.getKey());
            builder.append(" = ");
            builder.append(nextPropertyEntry.getValue());
        }
        return builder.toString();
    }

    public void writeAttributes(IObjectWriter writer) throws IOException {
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
    }

    public static interface IPropertiesManager {
        public <T> T getProperty(Element var1, String var2, Class<T> var3);

        public boolean hasProperty(Element var1, String var2);

        public Map<String, Object> getProperties(Element var1);
    }
}

