/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AnalyzerConfiguration
extends NamedElementContainer {
    private final Map<String, Object> m_nameToValue = new LinkedHashMap<String, Object>();
    private final IAnalyzerId m_analyzerId;

    public AnalyzerConfiguration(NamedElement parent, IAnalyzerId analyzerId) {
        super(parent);
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'Configuration' must not be null";
        this.m_analyzerId = analyzerId;
    }

    protected AnalyzerConfiguration(AnalyzerConfiguration configuration) {
        super(null);
        assert (configuration != null) : "Parameter 'configuration' of method 'Configuration' must not be null";
        this.m_nameToValue.putAll(configuration.getValueMap());
        this.m_analyzerId = configuration.m_analyzerId;
    }

    @Override
    public final String getImageResourceName() {
        return "Configuration";
    }

    public final IAnalyzerId getAnalyzerId() {
        assert (this.m_analyzerId != null);
        return this.m_analyzerId;
    }

    public final boolean affects(IAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'affaects' must not be null";
        return this.m_analyzerId == analyzerId;
    }

    public void reset() {
        this.m_nameToValue.clear();
    }

    public final void apply(Map<String, Object> valueMap) {
        assert (valueMap != null) : "Parameter 'valueMap' of method 'apply' must not be null";
        this.m_nameToValue.clear();
        this.m_nameToValue.putAll(valueMap);
    }

    @Override
    public final String getShortName() {
        return "Configuration";
    }

    protected final void addValue(String name, Object value) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'addProperty' must not be empty";
        assert (value != null) : "Parameter 'value' of method 'addProperty' must not be null";
        this.m_nameToValue.put(name, value);
    }

    public final Object getValue(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getValue' must not be empty";
        return this.m_nameToValue.get(name);
    }

    public final boolean removeValue(String key) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'removeValue' must not be empty";
        return this.m_nameToValue.remove(key) != null;
    }

    public final void setValue(String name, Object newValue) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setValue' must not be empty";
        assert (newValue != null) : "Parameter 'newValue' of method 'setValue' must not be null";
        if (newValue instanceof Integer || newValue instanceof Float || newValue instanceof Boolean || newValue instanceof String || newValue instanceof IStandardEnumeration) {
            this.m_nameToValue.put(name, newValue);
        } else assert (false) : "Unsupported configuration type: " + newValue.getClass().getCanonicalName() + ". Supported configuration types:  Integer, Float, Boolean, String, IStandardEnumeration";
    }

    public final boolean isDefined(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isDefined' must not be empty";
        return this.m_nameToValue.containsKey(name);
    }

    public final Map<String, Object> getValueMap() {
        return Collections.unmodifiableMap(this.m_nameToValue);
    }

    public final Map<String, Object> getValueMapForPersistence() {
        return new LinkedHashMap<String, Object>(this.m_nameToValue);
    }

    public void validateValuesFromPersistence(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'validateValuesFromPersistence' must not be null";
    }

    public abstract AnalyzerConfiguration copy();

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_analyzerId.hashCode();
        result = 31 * result + this.m_nameToValue.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzerConfiguration other = (AnalyzerConfiguration)obj;
        return this.m_analyzerId == other.m_analyzerId && this.m_nameToValue.equals(other.m_nameToValue);
    }

    @Override
    public final String getDebugInfo() {
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        for (Map.Entry<String, Object> nextEntry : this.m_nameToValue.entrySet()) {
            builder.append("\n");
            builder.append(nextEntry.getKey());
            builder.append("=");
            builder.append(nextEntry.getValue());
        }
        return builder.toString();
    }

    public static enum AnalyzerConfigurationCause implements OperationResult.IMessageCause
    {
        INVALID_VALUE_IN_ANALYZER_CONFIGURATION;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    public static interface IConfigurationEntryDescriptor
    extends IStandardEnumeration {
        public Object getDefaultValue();
    }

    public static interface IIntegerConfigurationEntryDescriptor
    extends IConfigurationEntryDescriptor {
        @Override
        public Integer getDefaultValue();

        public int getMinValue();

        public int getMaxValue();
    }

    public static interface IOptionConfigurationEntryDescriptor
    extends IConfigurationEntryDescriptor {
        @Override
        public String getDefaultValue();

        public int getNumberOfOptions();

        public String[] getOptions();
    }
}

