/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;

abstract class TreeMapLayout<E, D> {
    TreeMapLayout() {
    }

    protected final int calculateSquareLengthOfSide(TreeMapNode<E, D> node, float sizeFactor) {
        assert (node != null) : "Parameter 'node' of method 'calculateSquareLengthOfSide' must not be null";
        assert (sizeFactor > 0.0f) : "'sizeFactor' must be greater than 0";
        float size = node.getSize() * sizeFactor;
        double sqrt = Math.sqrt(size);
        int side = (int)Math.ceil(sqrt);
        int calculatedSize = side * side;
        assert ((float)calculatedSize >= size) : "Calculated size is smaller than input size: " + calculatedSize + "/" + size;
        assert (side >= 1) : "'squareLengthOfSide' must at least be 1";
        return side == 1 ? 2 : side;
    }

    abstract void layout(TreeMap<E, D> var1, float var2);
}

