/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;

final class LocationWithLogicalLineNumber
implements Comparable<LocationWithLogicalLineNumber> {
    private final IFileContent m_fileContent;
    private final int m_physicalLineNumber;
    private final int m_logicalLineNumber;

    LocationWithLogicalLineNumber(IFileContent fileContent, int physicalLineNumber, int logicalLineNumber) {
        assert (fileContent != null) : "Parameter 'fileContent' of method 'LocationWithLogicalLineNumber' must not be null";
        this.m_fileContent = fileContent;
        this.m_physicalLineNumber = physicalLineNumber;
        this.m_logicalLineNumber = logicalLineNumber;
    }

    public IFileContent getFileContent() {
        return this.m_fileContent;
    }

    int getPhysicalLineNumber() {
        return this.m_physicalLineNumber;
    }

    public int getLogicalLineNumber() {
        return this.m_logicalLineNumber;
    }

    @Override
    public int compareTo(LocationWithLogicalLineNumber loc) {
        String n2;
        String n1 = this.getFileContent().getFile().getAbsolutePath();
        int result = n1.compareTo(n2 = loc.getFileContent().getFile().getAbsolutePath());
        if (result != 0) {
            return result;
        }
        return this.getLogicalLineNumber() - loc.getLogicalLineNumber();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocationWithLogicalLineNumber)) {
            return false;
        }
        return this.compareTo((LocationWithLogicalLineNumber)obj) == 0;
    }

    public int hashCode() {
        return this.getLogicalLineNumber() + this.getFileContent().getFile().getAbsolutePath().hashCode();
    }

    IFile getPath() {
        return this.m_fileContent.getFile();
    }

    public String toString() {
        return this.m_fileContent.getFile().getAbsolutePath() + "  from Line:" + this.m_physicalLineNumber;
    }

    public static interface IFileContent {
        public IFile getFile();

        public int numberOfLogicalPositions();

        public byte[] getHashForLogicalLineNumber(int var1);

        public LocationWithLogicalLineNumber createLocation(int var1);

        public StrictPair<String, IntBasedHash> getHash(int var1, int var2);
    }
}

