/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

final class PositiveIntValueRange {
    private int m_lowerValue;
    private int m_upperValue;

    PositiveIntValueRange() {
    }

    void process(int lowerValue, int upperValue) {
        assert (lowerValue >= 0) : "'lowerValue' must not be negative";
        assert (upperValue >= 0) : "'upperValue' must not be negative";
        this.m_lowerValue = Math.min(this.m_lowerValue, lowerValue);
        this.m_upperValue = Math.max(this.m_upperValue, upperValue);
    }

    int getLowerValue() {
        return this.m_lowerValue;
    }

    int getUpperValue() {
        return this.m_upperValue;
    }

    int getNumberOfSteps() {
        return this.m_upperValue - this.m_lowerValue + 1;
    }

    public String toString() {
        return "[" + this.m_lowerValue + ".." + this.m_upperValue + "]";
    }
}

