/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.ExtendableEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.representation.FocusModeCollector;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RepresentationNavigationCollector
extends FocusModeCollector {
    private final Set<NamedElement> m_newElementsForView;
    private final Set<ProgrammingElement> m_programmingElementsForAdditionals;
    private final Set<ProgrammingElement> m_programmingElementsForMainNodes;
    private final FocusMode m_focusMode;
    private final boolean m_allowTransitiveDependencies;

    public RepresentationNavigationCollector(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<NamedElement> newElementsForView, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Map<NamedElement, NamedElement> namedElementToProxy, Set<CoreParserDependencyType> dependencyTypes, FocusMode focusMode, IDomainRoot.Domain domain, PresentationMode presentationMode, EnumSet<NodeAndEdgeRepresentation.RepresentationProperty> properties, boolean collectProgrammingElements, boolean dontCollectTypesRecursively, EndpointType endpointType) {
        super(softwareSystem, mainNodes, additionalNodes, Collections.emptySet(), namedElementToProxy, dependencyTypes, domain, focusMode, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, endpointType);
        assert (newElementsForView != null) : "Parameter 'newElementsForView' of method 'RepresentationNavigationCollector' must not be null";
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'RepresentationNavigationCollector' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'RepresentationNavigationCollector' must not be null";
        assert (focusMode != null) : "Parameter 'focusMode' of method 'RepresentationNavigationCollector' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'RepresentationNavigationCollector' must not be null";
        this.m_newElementsForView = newElementsForView;
        this.m_programmingElementsForAdditionals = programmingElementsForAdditionalNodes;
        this.m_programmingElementsForMainNodes = programmingElementsForMainNodes;
        this.m_focusMode = focusMode;
        this.m_allowTransitiveDependencies = properties.contains((Object)NodeAndEdgeRepresentation.RepresentationProperty.ALLOWS_TRANSITIVE);
    }

    @Override
    public boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        if (dependency instanceof ParserDependency) {
            return this.addParserDependency(from, to, (ParserDependency)dependency);
        }
        return this.isAllowedDependencyType(dependency);
    }

    private final boolean addParserDependency(NamedElement from, NamedElement to, ParserDependency parserDependency) {
        boolean isDependencyOfAdditionals;
        assert (from != null) : "Parameter 'from' of method 'addParserDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addParserDependency' must not be null";
        assert (parserDependency != null) : "Parameter 'dependency' of method 'parserDependency' must not be null";
        boolean add = false;
        ProgrammingElement fromDependencyEndpoint = parserDependency.getFrom();
        ProgrammingElement toDependencyEndpoint = parserDependency.getTo();
        boolean bl = isDependencyOfAdditionals = this.m_programmingElementsForAdditionals.contains(fromDependencyEndpoint) && this.m_programmingElementsForAdditionals.contains(toDependencyEndpoint);
        if (super.addDependency(from, to, parserDependency) && ExtendableEndpointCollector.isParserDependencyInRepresentation(this.getMainNodes(), this.m_programmingElementsForMainNodes, this.m_programmingElementsForAdditionals, from, to, parserDependency) || this.m_allowTransitiveDependencies) {
            if (!this.isAllowedDependencyType(parserDependency)) {
                return false;
            }
            add = true;
        }
        if (!add) {
            boolean inPreviousEdges;
            if (this.getMainNodes().contains(from) && this.getMainNodes().contains(to)) {
                return true;
            }
            boolean bl2 = inPreviousEdges = !this.m_newElementsForView.contains(from) && !this.m_newElementsForView.contains(to);
            if (!inPreviousEdges) {
                switch (this.m_focusMode) {
                    case NO_ADDITIONAL: {
                        return this.getMainNodes().contains(from) && this.getMainNodes().contains(to);
                    }
                    case IN: {
                        return this.getMainNodes().contains(to) || isDependencyOfAdditionals && this.m_allowTransitiveDependencies;
                    }
                    case OUT: {
                        return this.getMainNodes().contains(from) || isDependencyOfAdditionals && this.m_allowTransitiveDependencies;
                    }
                    case IN_AND_OUT: {
                        return this.getMainNodes().contains(to) || this.getMainNodes().contains(from) || isDependencyOfAdditionals && this.m_allowTransitiveDependencies;
                    }
                }
                assert (false) : "Unexpected focus mode '" + String.valueOf((Object)this.m_focusMode) + "'";
            }
        }
        return add;
    }

    public static Set<NamedElement> collectAllAdditionals(Set<NamedElement> currentAdditionals, Set<NamedElement> newAdditionals) {
        assert (currentAdditionals != null) : "Parameter 'currentAdditionals' of method 'collectAllAdditionals' must not be null";
        assert (newAdditionals != null) : "Parameter 'newAdditionals' of method 'collectAllAdditionals' must not be null";
        HashSet<NamedElement> allAdditionals = new HashSet<NamedElement>(currentAdditionals);
        allAdditionals.addAll(newAdditionals);
        return allAdditionals;
    }
}

