/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.SourceLineProcessor;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import java.util.Set;

public final class JavaFamilySourceLineVisitor
extends ISourceLineProcessor.SourceLineVisitor {
    private static final JavaFamilySourceLineVisitor s_instance = new JavaFamilySourceLineVisitor();
    private static final ISourceLineProcessor s_sourceLineProcessor = new SourceLineProcessor();
    private static final String DOT = ".";
    private static ISourceFileRegionVisitor s_visitor;
    private static Set<String> s_keywords;
    private static boolean s_previousStateIsDot;

    private JavaFamilySourceLineVisitor() {
    }

    public static void process(ISourceFileRegionVisitor visitor, String content, Set<String> keywords) {
        assert (s_visitor == null) : "'m_visitor' of method 'process' must be null";
        assert (s_keywords == null) : "'s_annotations' of method 'process' must be null";
        assert (visitor != null) : "Parameter 'visitor' of method 'process' must not be null";
        assert (keywords != null) : "Parameter 'keywords' of method 'process' must not be null";
        s_visitor = visitor;
        s_keywords = keywords;
        s_previousStateIsDot = false;
        s_sourceLineProcessor.accept(content, (ISourceLineProcessor.SourceLineVisitor)s_instance);
        s_visitor = null;
        s_keywords = null;
        s_previousStateIsDot = false;
    }

    @Override
    public boolean isWordCharacter(int ch) {
        return super.isWordCharacter(ch) || ch == 45;
    }

    @Override
    public void visitCharLiteral(int offset, String c) {
        assert (c != null) : "Parameter 'c' of method 'visitCharLiteral' must not be null";
        s_visitor.visitLiteral(offset, c.length());
        s_previousStateIsDot = false;
    }

    @Override
    public void visitStringLiteral(int offset, String s) {
        assert (s != null) : "Parameter 's' of method 'visitStringLiteral' must not be null";
        s_visitor.visitLiteral(offset, s.length());
        s_previousStateIsDot = false;
    }

    @Override
    public void visitSingleLineComment(int offset, String comment) {
        assert (comment != null) : "Parameter 'comment' of method 'visitSingleLineComment' must not be null";
        s_visitor.visitComment(offset, comment.length());
        s_previousStateIsDot = false;
    }

    @Override
    public void visitMultiLineComment(int offset, String comment) {
        assert (comment != null) : "Parameter 'comment' of method 'visitMultiLineComment' must not be null";
        s_visitor.visitComment(offset, comment.length());
        int atIndex = comment.indexOf("@");
        if (atIndex != -1) {
            boolean stillAtsRemaining = true;
            while (stillAtsRemaining) {
                int nextSpaceIndex = comment.indexOf(32, atIndex);
                if (nextSpaceIndex > 0) {
                    s_visitor.visitAnnotation(offset + atIndex, nextSpaceIndex - atIndex, true);
                    atIndex = comment.indexOf("@", nextSpaceIndex);
                }
                if (nextSpaceIndex != -1 && atIndex != -1) continue;
                stillAtsRemaining = false;
            }
        }
        s_previousStateIsDot = false;
    }

    @Override
    public void visitWord(int offset, String word) {
        assert (word != null) : "Parameter 'word' of method 'word' must not be null";
        assert (s_keywords != null) : "'s_keywords' of method 'visitWord' must not be null";
        if (!s_previousStateIsDot && (s_keywords.contains(word) || word.equals("non-sealed"))) {
            s_visitor.visitKeyword(offset, word.length());
        }
        s_previousStateIsDot = false;
    }

    @Override
    public void visitOther(int offset, String word) {
        assert (word != null) : "Parameter 'word' of method 'visitOther' must not be null";
        s_previousStateIsDot = DOT.equals(word);
    }

    @Override
    public void visitAt(int offset, String atWord) {
        assert (atWord != null) : "Parameter 'word' of method 'visitAtWord' must not be null";
        s_visitor.visitAnnotation(offset, atWord.length(), false);
        s_previousStateIsDot = false;
    }

    @Override
    public void visitEndOfCodeCommentLine() {
        s_previousStateIsDot = false;
    }

    @Override
    public void visitEndOfCommentLine() {
        s_previousStateIsDot = false;
    }

    @Override
    public void visitNumberSign(int offset, String numberWord) {
        s_previousStateIsDot = false;
    }
}

