/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.TopLevelLogicalProgrammingElementNode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Collection;

public final class NodesWithPotentialDependenciesCollector
extends ArchitecturalViewVisitor
implements ExplorationViewRepresentation.IVisitor,
ProgrammingElementAggregatingNode.IVisitor,
TopLevelLogicalProgrammingElementNode.IVisitor,
ProgrammingElementNode.IVisitor {
    private static final String WORKING = "Working";
    private static final int WORKING_THRESHOLD = 1000;
    private final IWorkerContext m_workerContext;
    private final Collection<ArchitecturalViewNode> m_collector;
    private int m_visited;

    NodesWithPotentialDependenciesCollector(IWorkerContext workerContext, Collection<ArchitecturalViewNode> collector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'NodesWithPotentialDependenciesCollector' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'NodesWithPotentialDependenciesCollector' must not be null";
        this.m_workerContext = workerContext;
        this.m_collector = collector;
    }

    @Override
    protected boolean done() {
        if (this.m_visited % 1000 == 0) {
            this.m_workerContext.working(WORKING, false);
        }
        return this.m_workerContext.hasBeenCanceled();
    }

    @Override
    public void visitExplorationViewRepresentation(ExplorationViewRepresentation element) {
        assert (element != null) : "Parameter 'element' of method 'visitExplorationViewRepresentation' must not be null";
        if (this.done()) {
            return;
        }
        ++this.m_visited;
        for (ArchitecturalViewNode next : element.getVisibleNodeChildren()) {
            if (this.done()) {
                return;
            }
            next.accept(this);
        }
    }

    @Override
    public void visitProgrammingElementAggregatingNode(ProgrammingElementAggregatingNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        if (this.done()) {
            return;
        }
        ++this.m_visited;
        if (!element.isExpanded()) {
            this.m_collector.add(element);
        } else {
            for (ArchitecturalViewNode next : element.getVisibleNodeChildren()) {
                if (this.done()) {
                    return;
                }
                next.accept(this);
            }
        }
    }

    @Override
    public void visitTopLevelLogicalProgrammingElementNode(TopLevelLogicalProgrammingElementNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitTopLevelLogicalProgrammingElementNode' must not be null";
        if (this.done()) {
            return;
        }
        ++this.m_visited;
        this.m_collector.add(element);
        if (element.isExpanded()) {
            for (ArchitecturalViewNode next : element.getVisibleNodeChildren()) {
                if (this.done()) {
                    return;
                }
                next.accept(this);
            }
        }
    }

    @Override
    public void visitProgrammingElementNode(ProgrammingElementNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitProgrammingElementNode' must not be null";
        if (this.done()) {
            return;
        }
        ++this.m_visited;
        this.m_collector.add(element);
        if (element.isExpanded()) {
            for (ArchitecturalViewNode next : element.getVisibleNodeChildren()) {
                if (this.done()) {
                    return;
                }
                next.accept(this);
            }
        }
    }
}

