/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonLeafNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import java.util.List;

class FinishElementStructureVisitor
extends ArchitecturalViewVisitor
implements RecursiveNode.IVisitor,
ArchitecturalViewNode.IVisitor,
NonRecursiveNonLeafNode.IVisitor {
    private final NamedElement.INamedElementVisitor m_namedElementVisitor = new NamedElement.INamedElementVisitor(){

        @Override
        public void visitChildrenOf(NamedElement element) {
            if (!$assertionsDisabled && element == null) {
                throw new AssertionError((Object)"Parameter 'element' of method 'visitChildrenOf' must not be null");
            }
            for (NamedElement next : element.getChildren()) {
                next.accept(this);
            }
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            if (!$assertionsDisabled && element == null) {
                throw new AssertionError((Object)"Parameter 'element' of method 'visitNamedElement' must not be null");
            }
            element.finishModification();
            this.visitChildrenOf(element);
        }
    };
    private final ArchitecturalViewNodeInfo m_nodeInfo = new ArchitecturalViewNodeInfo();
    private final ExplorationViewRepresentation m_representation;

    FinishElementStructureVisitor(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'FinishElementStructureVisitor' must not be null";
        this.m_representation = representation;
    }

    ArchitecturalViewNodeInfo getArchitecturalViewNodeInfo() {
        return this.m_nodeInfo;
    }

    @Override
    public final void visitArtifactNodeFilter(ArtifactNodeFilter element) {
        assert (element != null) : "Parameter 'element' of method 'visitArtifactNodeFilter' must not be null";
        element.accept(this.m_namedElementVisitor);
        super.visitArtifactNodeFilter(element);
    }

    @Override
    public final void visitArchitecturalViewElement(ArchitecturalViewElement element) {
        element.finishModification();
        super.visitArchitecturalViewElement(element);
    }

    @Override
    public final void visitArchitecturalViewNode(ArchitecturalViewNode element) {
        boolean isDeletedOrSuppressed;
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        boolean bl = isDeletedOrSuppressed = element.isDeleted() || element.isSuppressed();
        if (element.isSelected()) {
            if (!isDeletedOrSuppressed) {
                this.m_nodeInfo.addSelected(element);
            }
            element.setSelected(false);
        }
        if (element.isExpanded()) {
            if (!isDeletedOrSuppressed) {
                this.m_nodeInfo.addExpanded(element);
            }
            element.setExpanded(false);
        }
        element.updateDepth();
        element.setLevel(0);
        element.setCycleIndex(-1);
        element.setLevelInCycle(-1);
        element.setRelativeIndex(-1);
        boolean isLeafNode = !isDeletedOrSuppressed;
        for (NamedElement next : element.getChildren()) {
            ArchitecturalViewElement nextElement;
            if (isLeafNode && next instanceof ArchitecturalViewElement && !(nextElement = (ArchitecturalViewElement)next).isDeleted()) {
                isLeafNode = false;
            }
            next.accept(this);
        }
        if (isLeafNode) {
            this.m_nodeInfo.addLeafNode(element);
        }
        NodeHandler.updateExpandableState(element, this.m_representation);
        element.finishModification();
    }

    @Override
    public final void visitRecursiveNode(RecursiveNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitRecursiveNode' must not be null";
        PresentationMode presentationMode = element.getPresentationMode();
        if (PresentationMode.NONE == presentationMode) {
            element.setPart(false);
            element.setSuppressed(true);
        } else {
            boolean suppress;
            boolean mixable;
            boolean part;
            int visibleRecursiveNodeChildren = 0;
            int visibleNonRecursiveNodeChildren = 0;
            List<NamedElement> children = element.getChildrenList();
            if (!children.isEmpty()) {
                for (NamedElement nextChild : children) {
                    ArchitecturalViewNode nextChildNode;
                    boolean nextChildNodeIsDeleted;
                    if (!(nextChild instanceof ArchitecturalViewNode) || (nextChildNodeIsDeleted = (nextChildNode = (ArchitecturalViewNode)nextChild).isDeleted())) continue;
                    if (nextChildNode.isRecursive()) {
                        ++visibleRecursiveNodeChildren;
                        continue;
                    }
                    ++visibleNonRecursiveNodeChildren;
                }
            }
            if (visibleNonRecursiveNodeChildren > 0) {
                part = false;
                mixable = false;
            } else {
                part = true;
                boolean bl = mixable = visibleRecursiveNodeChildren == 1;
            }
            if (visibleNonRecursiveNodeChildren == 0 && visibleRecursiveNodeChildren == 0 && element.isCreated()) {
                switch (presentationMode) {
                    case HIERARCHICAL: {
                        suppress = false;
                        break;
                    }
                    case FLAT: 
                    case MIXED: {
                        suppress = element.hasChildren(false, RecursiveNode.class);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled presentation mode: " + String.valueOf((Object)presentationMode);
                        suppress = false;
                        break;
                    }
                }
            } else {
                switch (presentationMode) {
                    case HIERARCHICAL: {
                        suppress = false;
                        break;
                    }
                    case MIXED: {
                        suppress = mixable;
                        break;
                    }
                    case FLAT: {
                        suppress = part || element.isDeletedFlat();
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled presentation mode: " + String.valueOf((Object)presentationMode);
                        suppress = false;
                    }
                }
            }
            element.setPart(part);
            element.setSuppressed(suppress && !element.isDeletedRecycled());
        }
        this.visitArchitecturalViewNode(element);
    }

    @Override
    public void visitNonRecursiveNonLeafNode(NonRecursiveNonLeafNode element) {
        assert (element != null) : "Parameter 'element' of method 'visitNonRecursiveNonLeafNode' must not be null";
        this.visitArchitecturalViewNode(element);
    }
}

