/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewContextDependency;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewProviderId;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExplorationViewContext;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RefactoringHandler;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.context.ContextParserDependency;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.dependenciesview.CausesAndResolutionInfo;
import com.hello2morrow.sonargraph.core.model.dependenciesview.ViolationInfo;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ArchitecturalViewContext
extends ExplorationViewContext {
    private final String m_identifyingPath;
    private final ArchitecturalViewProviderId m_providerId;

    private static void processIssue(Issue issue, List<Issue> collector) {
        assert (issue != null) : "Parameter 'issue' of method 'processIssue' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'processIssue' must not be null";
        if (!issue.isIgnored() && issue.getId().getCategory() != IssueCategory.ARCHITECTURE_CONSISTENCY && issue.getId().getCategory() != IssueCategory.ARCHITECTURE_DEFINITION && issue.getId().getCategory() != IssueCategory.ARCHITECTURE_VIOLATION && issue.getId().getCategory() != IssueCategory.ARCHITECTURE_DEPRECATION) {
            collector.add(issue);
        }
    }

    private static void processParserDependencies(ArchitecturalViewProviderId providerId, List<ParserDependency> dependencies, ExplorationViewRepresentation representation, List<Issue> collector) {
        assert (representation != null) : "Parameter 'representation' of method 'processParserDependencies' must not be null";
        assert (dependencies != null) : "Parameter 'dependency' of method 'processParserDependencies' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'processParserDependencies' must not be null";
        for (ParserDependency next : dependencies) {
            if (providerId != null) {
                RefactoringHandler.collectIssues(providerId, next, representation, collector);
            }
            next.getIssues().forEach(i -> ArchitecturalViewContext.processIssue(i, collector));
        }
    }

    public ArchitecturalViewContext(IContext defaultContext, ExplorationViewRepresentation representation, String identifyingPath) {
        super(defaultContext, representation);
        this.m_identifyingPath = identifyingPath;
        this.m_providerId = new ArchitecturalViewProviderId(identifyingPath);
    }

    public String getStandardName() {
        return this.m_identifyingPath;
    }

    public String getPresentationName() {
        return this.m_identifyingPath;
    }

    @Override
    public String getDescription() {
        return "Provides access to issues provided by the correspinding architectural view";
    }

    @Override
    public ContextParserDependency create(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'create' must not be null";
        return new ArchitecturalViewContextDependency(dependency, this.getRepresentation());
    }

    @Override
    public boolean isViolation(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'isViolation' must not be null";
        ViolationInfo info = this.getRepresentation().isViolation(dependency);
        return info != null && info.getResolution() != CausesAndResolutionInfo.Resolution.IGNORE;
    }

    @Override
    public String getViolationInfo(ParserDependency dependency) {
        assert (dependency != null) : "Parameter 'dependency' of method 'getViolationInfo' must not be null";
        ViolationInfo info = this.getRepresentation().isViolation(dependency);
        if (info != null && info.getResolution() != CausesAndResolutionInfo.Resolution.IGNORE) {
            return this.getViolationCausesInfo(info.getCauses());
        }
        return null;
    }

    @Override
    public List<Issue> collectIssues(ElementWithIssues element, boolean recursively) {
        assert (element != null) : "Parameter 'element' of method 'collectIssues' must not be null";
        ArrayList<Issue> issues = new ArrayList<Issue>();
        if (element instanceof NamedElement) {
            ((NamedElement)element).accept(new ArchitecturalViewIssueVisitor(issues, recursively));
        } else if (element instanceof ParserDependency) {
            ArchitecturalViewContext.processParserDependencies(this.m_providerId, Collections.singletonList((ParserDependency)element), this.getRepresentation(), issues);
        } else {
            assert (element != null && element instanceof Dependency) : "Unexpected class in method 'collectIssues': " + String.valueOf(element);
            element.getIssues().forEach(i -> ArchitecturalViewContext.processIssue(i, issues));
        }
        issues.trimToSize();
        return issues;
    }

    public String toString() {
        return "Architectural view '" + this.m_identifyingPath + "'";
    }

    private class ArchitecturalViewIssueVisitor
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor {
        private final List<Issue> m_collector;
        private final boolean m_recursively;
        private boolean m_currentElementIsDeleted;

        ArchitecturalViewIssueVisitor(List<Issue> collector, boolean recursively) {
            assert (collector != null) : "Parameter 'collector' of method 'ArchitecturalViewIssueVisitor' must not be null";
            this.m_collector = collector;
            this.m_recursively = recursively;
        }

        @Override
        public void visitNamedElement(NamedElement namedElement) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'visitNamedElement' must not be null";
            namedElement.getIssues().forEach(i -> ArchitecturalViewContext.processIssue(i, this.m_collector));
            if (!this.m_currentElementIsDeleted) {
                this.m_currentElementIsDeleted = RefactoringHandler.collectIssues(ArchitecturalViewContext.this.m_providerId, namedElement, ArchitecturalViewContext.this.getRepresentation(), this.m_collector);
                if (this.m_recursively) {
                    super.visitNamedElement(namedElement);
                }
                this.m_currentElementIsDeleted = false;
            } else if (this.m_recursively) {
                super.visitNamedElement(namedElement);
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            this.visitNamedElement(element);
            ArchitecturalViewContext.processParserDependencies(this.m_currentElementIsDeleted ? null : ArchitecturalViewContext.this.m_providerId, element.getOutgoingDependencies(new IParserDependencyType[0]), ArchitecturalViewContext.this.getRepresentation(), this.m_collector);
        }
    }
}

