/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractDiffProcessor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.report.IReport;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimplePropertyDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginConfigurationDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginConfigurationsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginsDiff;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.IPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphFloatPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class PluginDiffProcessor
extends AbstractDiffProcessor {
    private final IReport m_currentSystemReport;

    public PluginDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem, IReport currentSystemReport) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem);
        this.m_currentSystemReport = currentSystemReport;
    }

    @Override
    public void process(NamedElement parent) {
        this.addPluginsDiff(parent, this.m_currentSystemReport);
        this.addPluginsConfigurationDiff(parent, this.m_currentSystemReport);
    }

    private void addPluginsDiff(NamedElement basicInfoDiff, IReport currentSystemReport) {
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addPluginsDiff' must not be null";
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'addPluginsDiff' must not be null";
        PluginConfigurations pluginConfigurations = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSystemDirectory().getUniqueExistingChild(PluginConfigurations.class);
        PluginsDiff pluginsDiff = new PluginsDiff(basicInfoDiff, pluginConfigurations);
        ArrayList<PluginDiff> children = new ArrayList<PluginDiff>();
        Map<String, IPlugin> baselinePlugins = this.getBaselineSystemInfoProcessor().getPlugins().stream().collect(Collectors.toMap(p -> p.getName(), p -> p));
        this.processPlugins(currentSystemReport.getModelPlugins(), baselinePlugins, children, pluginsDiff);
        List<SonargraphPlugin> analyzerPlugins = currentSystemReport.getAnalyzerPlugins().stream().map(p -> (SonargraphPlugin)p.getFirst()).collect(Collectors.toList());
        this.processPlugins(analyzerPlugins, baselinePlugins, children, pluginsDiff);
        children.forEach(child -> {
            Object v = baselinePlugins.remove(child.getName());
        });
        for (IPlugin plugin : baselinePlugins.values()) {
            PluginDiff Diff2 = new PluginDiff((NamedElement)pluginsDiff, plugin, null, IDiffElement.Change.REMOVED);
            children.add(Diff2);
        }
        children.sort(Comparator.comparing(NamedElement::getName));
        for (PluginDiff nextDiff : children) {
            pluginsDiff.addChild(nextDiff);
        }
        basicInfoDiff.addChild(pluginsDiff);
    }

    private void processPlugins(Collection<SonargraphPlugin> plugins, Map<String, IPlugin> baselinePlugins, List<PluginDiff> children, PluginsDiff pluginsDiff) {
        for (SonargraphPlugin next : plugins) {
            IPlugin baselinePlugin = baselinePlugins.get(next.getId());
            if (baselinePlugin != null) {
                IDiffElement.Change change;
                if (next.isEnabled() && baselinePlugin.isEnabled() || !next.isEnabled() && !baselinePlugin.isEnabled()) {
                    change = IDiffElement.Change.UNMODIFIED;
                } else if (!baselinePlugin.isEnabled() && next.isEnabled()) {
                    change = IDiffElement.Change.ADDED;
                } else {
                    assert (baselinePlugin.isEnabled() && !next.isEnabled()) : "Unexpected state '" + baselinePlugin.isEnabled() + "', '" + next.isEnabled() + "'";
                    change = IDiffElement.Change.REMOVED;
                }
                PluginDiff Diff2 = new PluginDiff((NamedElement)pluginsDiff, baselinePlugin, next, change);
                children.add(Diff2);
                continue;
            }
            if (!next.isEnabled()) continue;
            PluginDiff Diff3 = new PluginDiff((NamedElement)pluginsDiff, baselinePlugin, next, IDiffElement.Change.ADDED);
            children.add(Diff3);
        }
    }

    private void addPluginsConfigurationDiff(NamedElement basicInfoDiff, IReport currentSystemReport) {
        PluginConfigurationDiff configurationDiff;
        assert (basicInfoDiff != null) : "Parameter 'basicInfoDiff' of method 'addPluginsConfigurationDiff' must not be null";
        assert (currentSystemReport != null) : "Parameter 'currentSystemReport' of method 'addPluginsConfigurationDiff' must not be null";
        HashMap<String, Pair> currentPluginConfigurations = new HashMap<String, Pair>();
        for (Map.Entry<SonargraphPlugin, Pair<PluginConfigurationFile, List<Pair<SonargraphPluginAttribute, String>>>> nextCurrent : currentSystemReport.getPluginConfigurations().entrySet()) {
            currentPluginConfigurations.put(((PluginConfigurationFile)nextCurrent.getValue().getFirst()).getPath(), new Pair((Object)nextCurrent.getKey(), nextCurrent.getValue()));
        }
        PluginConfigurations pluginConfigurations = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getSystemDirectory().getUniqueExistingChild(PluginConfigurations.class);
        PluginConfigurationsDiff configurationsDiff = new PluginConfigurationsDiff(basicInfoDiff, pluginConfigurations);
        for (Map.Entry baselinePluginConfigEntry : this.getBaselineSystemInfoProcessor().getPluginConfigurations().entrySet()) {
            Pair currentEntry = (Pair)currentPluginConfigurations.remove(baselinePluginConfigEntry.getKey());
            if (currentEntry != null) {
                PluginConfigurationFile currentConfiguration = (PluginConfigurationFile)((Pair)currentEntry.getSecond()).getFirst();
                List attributesAndValues = (List)((Pair)currentEntry.getSecond()).getSecond();
                PluginConfigurationDiff configurationDiff2 = new PluginConfigurationDiff(configurationsDiff, currentConfiguration, currentConfiguration.getName(), currentConfiguration.getPresentationName(false));
                this.addPluginConfigurationEntriesDiff(configurationDiff2, (IPluginConfiguration)baselinePluginConfigEntry.getValue(), attributesAndValues);
                configurationsDiff.addChild(configurationDiff2);
                continue;
            }
            IPluginConfiguration baselinePluginConfiguration = (IPluginConfiguration)baselinePluginConfigEntry.getValue();
            configurationDiff = new PluginConfigurationDiff(configurationsDiff, null, baselinePluginConfiguration.getName(), baselinePluginConfiguration.getPresentationName(), IDiffElement.Change.REMOVED);
            this.addPluginConfigurationEntriesDiff(configurationDiff, baselinePluginConfiguration, Collections.emptyList());
            configurationsDiff.addChild(configurationDiff);
        }
        for (Pair nextAdded : currentPluginConfigurations.values()) {
            PluginConfigurationFile addedPluginConfiguration = (PluginConfigurationFile)((Pair)nextAdded.getSecond()).getFirst();
            List attributeDefinitionsAndValues = (List)((Pair)nextAdded.getSecond()).getSecond();
            configurationDiff = new PluginConfigurationDiff(configurationsDiff, addedPluginConfiguration, addedPluginConfiguration.getName(), addedPluginConfiguration.getPresentationName(false), IDiffElement.Change.ADDED);
            this.addPluginConfigurationEntriesDiff(configurationDiff, null, attributeDefinitionsAndValues);
            configurationsDiff.addChild(configurationDiff);
        }
        basicInfoDiff.addChild(configurationsDiff);
    }

    private void addPluginConfigurationEntriesDiff(PluginConfigurationDiff configurationDiff, IPluginConfiguration baselineConfiguration, List<Pair<SonargraphPluginAttribute, String>> attributesAndValues) {
        assert (configurationDiff != null) : "Parameter 'configurationDiff' of method 'addPluginConfigurationEntriesDiff' must not be null";
        assert (attributesAndValues != null) : "Parameter 'attributesAndValues' of method 'addPluginConfigurationEntriesDiff' must not be null";
        ArrayList<Pair<SonargraphPluginAttribute, String>> currentAttributesAndValues = new ArrayList<Pair<SonargraphPluginAttribute, String>>(attributesAndValues);
        HashMap baseLineConfigurationValues = baselineConfiguration != null ? new HashMap(baselineConfiguration.getConfigurationValues()) : Collections.emptyMap();
        for (Pair pair : currentAttributesAndValues) {
            SimplePropertyDiff attributeDiff;
            SonargraphPluginAttribute definition = (SonargraphPluginAttribute)pair.getFirst();
            String attributeName = definition.getName();
            String currentValue = (String)pair.getSecond();
            if (baselineConfiguration != null && baseLineConfigurationValues.remove(attributeName) != null) {
                if (definition instanceof SonargraphStringPluginAttribute) {
                    String baselineStringValue = baselineConfiguration.getStringConfigurationValue(attributeName);
                    if (baselineStringValue != null) {
                        IDiffElement.Change change = currentValue.equals(baselineStringValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, baselineStringValue, currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                } else if (definition instanceof SonargraphIntPluginAttribute) {
                    Integer baselineIntValue = baselineConfiguration.getIntConfigurationValue(attributeName);
                    if (baselineIntValue != null) {
                        Integer currentIntValue = Integer.parseInt(currentValue);
                        change = currentIntValue.equals(baselineIntValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, String.valueOf(baselineIntValue), currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                } else if (definition instanceof SonargraphFloatPluginAttribute) {
                    Float baselineFloatValue = baselineConfiguration.getFloatConfigurationValue(attributeName);
                    if (baselineFloatValue != null) {
                        Float currentFloatValue = Float.valueOf(Float.parseFloat(currentValue));
                        change = currentFloatValue.equals(baselineFloatValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, String.valueOf(baselineFloatValue), currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                } else {
                    assert (definition != null && definition instanceof SonargraphBooleanPluginAttribute) : "Unexpected class in method 'addPluginConfigurationEntriesDiff': " + String.valueOf(definition);
                    Boolean baselineBooleanValue = baselineConfiguration.getBooleanConfigurationValue(attributeName);
                    if (baselineBooleanValue != null) {
                        Boolean currentBooleanValue = Boolean.parseBoolean(currentValue);
                        change = currentBooleanValue.equals(baselineBooleanValue) ? IDiffElement.Change.UNMODIFIED : IDiffElement.Change.MODIFIED;
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, String.valueOf(baselineBooleanValue), currentValue, change);
                    } else {
                        attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
                    }
                }
                configurationDiff.addChild(attributeDiff);
                continue;
            }
            attributeDiff = new SimplePropertyDiff(configurationDiff, attributeName, null, currentValue, IDiffElement.Change.ADDED);
            configurationDiff.addChild(attributeDiff);
        }
        for (Map.Entry entry : baseLineConfigurationValues.entrySet()) {
            SimplePropertyDiff attributeDiff = new SimplePropertyDiff(configurationDiff, (String)entry.getKey(), entry.getValue().toString(), null, IDiffElement.Change.REMOVED);
            configurationDiff.addChild(attributeDiff);
        }
    }
}

