/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.LineBasedIssueMatcher;
import com.hello2morrow.sonargraph.core.controller.system.diff.SimpleIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.element.IIssueWithLineContext;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.ILineBasedIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementIssue;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class LinedBasedIssueDiffProcessor
extends SimpleIssueDiffProcessor<INamedElementIssue, NamedElementIssue> {
    public LinedBasedIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, INamedElementIssue.class, NamedElementIssue.class);
    }

    @Override
    protected Predicate<INamedElementIssue> getAdditionalBaselineFilter() {
        return issue -> issue instanceof ILineBasedIssue || issue.getIssueType().getCategory().getName().equals(IssueCategory.SCRIPT_BASED.getStandardName()) && issue.getLine() > 0;
    }

    @Override
    protected Predicate<NamedElementIssue> getAdditionalCurrentFilter() {
        return issue -> issue instanceof IIssueWithLineContext || issue.getId().getCategory() == IssueCategory.SCRIPT_BASED && issue.getLineNumber() > 0;
    }

    @Override
    protected String getAffectedCurrentElementFqName(NamedElementIssue currentIssue) {
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'getAffectedCurrentElementFqName' must not be null";
        return this.getOrCreateFqNameFromCachedElement(currentIssue.getAffectedElement());
    }

    protected LineBasedIssueMatcher getIssueMatcher() {
        return new LineBasedIssueMatcher(this);
    }
}

