/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.sonargraph.core.controller.system.base.AbstractSimilarityMatcher;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNameProvider;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilter;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilterData;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import gnu.trove.set.hash.THashSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class CycleGroupMatcher
extends AbstractSimilarityMatcher<CycleGroup, CycleGroupIssue, String> {
    public CycleGroupMatcher(double similarityThreshold) {
        super(similarityThreshold);
    }

    @Override
    public double getSimilarity(Set<String> referenceFqNames, Set<String> cycleFqNames) {
        HashSet<String> intersection = new HashSet<String>(referenceFqNames);
        intersection.retainAll(cycleFqNames);
        if (intersection.isEmpty()) {
            return -1.0;
        }
        return (double)intersection.size() / ((double)Math.max(referenceFqNames.size(), cycleFqNames.size()) * 1.0);
    }

    @Override
    protected boolean supportsPatternBasedMacthing() {
        return true;
    }

    @Override
    protected boolean matchPatternBased(Resolution resolution, CycleGroupIssue issue) {
        PatternBasedCycleIgnoreFilter filterNode = resolution.getUniqueChild(PatternBasedCycleIgnoreFilter.class);
        if (filterNode == null) {
            return false;
        }
        PatternBasedCycleIgnoreFilterData filter = filterNode.getFilterData();
        AnalyzerCycleGroup cycleGroup = issue.getAffectedElement();
        Set<NamedElement> cyclicElements = cycleGroup.getCyclicNamedElements();
        if (filter.getMaximumSize() > 0 && cyclicElements.size() > filter.getMaximumSize()) {
            return false;
        }
        List<PatternBasedCycleIgnoreFilterData.Pattern> includePatterns = filter.getIncludePatterns();
        List<PatternBasedCycleIgnoreFilterData.Pattern> excludePatterns = filter.getExcludePatterns();
        THashSet matchingPatterns = new THashSet();
        for (NamedElement cycleMember : cyclicElements) {
            CustomPattern matcher;
            assert (cycleMember instanceof IArchitectureFilterNameProvider) : "Unexpected class: " + cycleMember.getClass().getName();
            String filterName = ((IArchitectureFilterNameProvider)((Object)cycleMember)).getArchitectureFilterName();
            if (filterName.endsWith("/**")) {
                filterName = filterName.substring(0, filterName.length() - 3);
            }
            boolean matched = false;
            for (PatternBasedCycleIgnoreFilterData.Pattern pattern : includePatterns) {
                matcher = pattern.getCompiledPattern();
                if (!matcher.matches((CharSequence)filterName)) continue;
                matched = true;
                matchingPatterns.add((Object)pattern);
                break;
            }
            if (!matched) {
                return false;
            }
            for (PatternBasedCycleIgnoreFilterData.Pattern pattern : excludePatterns) {
                matcher = pattern.getCompiledPattern();
                if (!matcher.matches((CharSequence)filterName)) continue;
                return false;
            }
        }
        for (PatternBasedCycleIgnoreFilterData.Pattern pattern : includePatterns) {
            if (!pattern.isMandatory() || matchingPatterns.contains((Object)pattern)) continue;
            return false;
        }
        issue.setResolution(resolution);
        return true;
    }

    @Override
    protected CycleGroup getAffectedElement(CycleGroupIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getAffectedElement' must not be null";
        AnalyzerCycleGroup affected = issue.getAffectedElement();
        assert (affected instanceof CycleGroup) : "Unexpected affected element: " + String.valueOf(affected);
        return affected;
    }

    @Override
    protected Set<String> getElementsForSimilarityMatch(CycleGroup element) {
        assert (element != null) : "Parameter 'element' of method 'getElementsForSimilarityMatch' must not be null";
        return new HashSet<String>(element.getFullyQualifiedNamesOfInvolvedElements());
    }

    @Override
    protected Set<String> getReferenceElementsForSimilarityMatch(Matching matching) {
        assert (matching != null) : "Parameter 'matching' of method 'getReferenceElementsForSimilarityMatch' must not be null";
        return new HashSet<String>(matching.getElementFqNames());
    }

    @Override
    protected CycleGroupIssue getIssueFromResolution(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getIssueFromResolution' must not be null";
        List<IIssue> issues = resolution.getAssociatedIssues();
        if (issues.size() > 0) {
            assert (issues.size() == 1) : "Only a single cycle group issue can be matched by a resolution. But resolution " + String.valueOf(resolution) + " matches " + issues.size();
            IIssue previousIssue = issues.get(0);
            assert (previousIssue instanceof CycleGroupIssue) : "Unexpected issue type " + previousIssue.getClass().getCanonicalName();
            return (CycleGroupIssue)previousIssue;
        }
        return null;
    }
}

