/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class FileNameRetriever
extends AssignableAttributeRetriever<NamedElement> {
    @Override
    public String getName() {
        return "FileName";
    }

    @Override
    public String getShortName() {
        return "FileName";
    }

    @Override
    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches against the relative file path of a source file.\n";
    }

    @Override
    public boolean availableFor(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'availableFor' must not be null";
        switch (architectureModel) {
            case LOGICAL: 
            case PHYSICAL: {
                return true;
            }
        }
        assert (false) : "Unhandled architecture model: " + String.valueOf((Object)architectureModel);
        return false;
    }

    @Override
    protected String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        if (assignable.getNamedElement() instanceof SourceFile) {
            SourceFile src = (SourceFile)assignable.getNamedElement();
            return src.getIdentifyingPath();
        }
        return "";
    }

    @Override
    protected String computeAttributeForLogicalProgrammingElement(IWorkerContext workerContext, LogicalProgrammingElement assignable, String[] params) {
        ProgrammingElement pe = assignable.getPrimaryProgrammingElement();
        SourceFile src = pe.getParent(SourceFile.class, new Class[0]);
        return src != null ? src.getIdentifyingPath() : "";
    }
}

