/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class ArchitectureFilterNameRetriever
extends AssignableAttributeRetriever<NamedElement> {
    public static final String NAME = "ArchitectureFilterName";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        String filterName;
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'getDescription' must not be null";
        return "Matches the pattern against the '" + filterName + "' of " + (switch (architectureModel) {
            case IArchitecturalModelProvider.ArchitectureModel.LOGICAL -> {
                filterName = "Architecture Filter Name Logical";
                yield "Top-Level Programming Element".toLowerCase();
            }
            case IArchitecturalModelProvider.ArchitectureModel.PHYSICAL -> {
                filterName = "Architecture Filter Name Physical";
                yield "Component".toLowerCase();
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled model: " + String.valueOf((Object)architectureModel)));
                }
                filterName = "";
                yield "";
            }
        }) + "s\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    private String getAttribute(IAssignableToArtifact assignable) {
        assert (assignable != null) : "Parameter 'assignable' of method 'getAttribute' must not be null";
        NamedElement element = assignable.getNamedElement();
        String datum = this.getDatum(element);
        if (datum == null) {
            datum = assignable.getArchitectureFilterName();
            assert (datum != null && datum.length() > 0) : "'datum' of method 'getAttribute' must not be empty: " + String.valueOf(assignable);
            this.setDatum(element, datum);
        }
        return this.createAttribute(datum);
    }

    @Override
    protected String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForComponent' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForComponents' must not be null";
        return this.getAttribute(assignable);
    }

    @Override
    protected String computeAttributeForLogicalProgrammingElement(IWorkerContext workerContext, LogicalProgrammingElement assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        return this.getAttribute(assignable);
    }
}

