/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.javapg.runtime.lexer.base.ILexer;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureFileFormatterLexer;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureLexer;
import com.hello2morrow.sonargraph.core.controller.system.base.Formatter;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.io.StringReader;

public final class ArchitectureFileFormatter
extends Formatter {
    private static final Pair<Integer, Integer> L_R_BRACES = new Pair((Object)43, (Object)44);

    public ArchitectureFileFormatter() {
        super(L_R_BRACES);
    }

    public ArchitectureFileFormatter(FormatterOptions options) {
        super(options, L_R_BRACES);
    }

    @Override
    protected ILexer getLexer() {
        return new ArchitectureLexer();
    }

    @Override
    public String format(String textToFormat) {
        assert (textToFormat != null) : "Parameter 'textToFormat' of method 'format' must not be null";
        if (textToFormat.length() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        ArchitectureFileFormatterLexer lexer = new ArchitectureFileFormatterLexer();
        lexer.assignInput(new StringReader(textToFormat), "String Lexer");
        try {
            int nextToken;
            boolean singleLineComment = false;
            int indentationLevel = 0;
            int previousToken = 52;
            while ((nextToken = lexer.nextToken()) != 0) {
                String lexeme = lexer.getLexeme();
                switch (nextToken) {
                    case 49: {
                        result.append(lexeme);
                        break;
                    }
                    case 50: {
                        result.append(lexeme);
                        result.append(this.createIndentation(indentationLevel));
                        break;
                    }
                    case 52: {
                        if (previousToken == 52 && !this.getOptions().isIndentEmptyLines()) {
                            this.clearLine(result);
                        }
                        int numberOfNewlines = StringUtility.countLines((String)lexeme) - 1;
                        this.clearWhitespace(result);
                        result.append(this.getOptions().getLineBreak());
                        int i = 2;
                        while (i <= numberOfNewlines) {
                            if (this.getOptions().isIndentEmptyLines()) {
                                result.append(this.createIndentation(indentationLevel));
                            }
                            result.append(this.getOptions().getLineBreak());
                            ++i;
                        }
                        result.append(this.createIndentation(indentationLevel));
                        break;
                    }
                    case 51: {
                        if (previousToken == 52) break;
                        result.append(" ");
                        break;
                    }
                    case 43: {
                        if (this.getOptions().getBracesStart() == FormatterOptions.BracesPlacement.SAME_LINE && previousToken == 52) {
                            result.setLength(result.lastIndexOf(this.getOptions().getLineBreak()));
                            this.addBlankIfNecessary(result);
                        } else if (this.getOptions().getBracesStart() == FormatterOptions.BracesPlacement.NEXT_LINE && previousToken != 52) {
                            this.clearWhitespace(result);
                            result.append(this.getOptions().getLineBreak());
                            previousToken = 52;
                            result.append(this.createIndentation(indentationLevel));
                        }
                        if (previousToken != 52) {
                            this.addBlankIfNecessary(result);
                        }
                        result.append(lexeme);
                        ++indentationLevel;
                        break;
                    }
                    case 44: {
                        --indentationLevel;
                        if (previousToken == 52) {
                            this.clearLine(result);
                            result.append(this.createIndentation(indentationLevel));
                        }
                        if (this.getOptions().getBracesEnd() == FormatterOptions.BracesPlacement.SAME_LINE && previousToken == 52 && !singleLineComment) {
                            result.setLength(result.lastIndexOf(this.getOptions().getLineBreak()));
                            this.addBlankIfNecessary(result);
                        } else if (this.getOptions().getBracesEnd() == FormatterOptions.BracesPlacement.NEXT_LINE && previousToken != 52) {
                            this.clearWhitespace(result);
                            result.append(this.getOptions().getLineBreak());
                            result.append(this.createIndentation(indentationLevel));
                        } else if (previousToken == 43) {
                            this.addBlankIfNecessary(result);
                        }
                        result.append(lexeme);
                        break;
                    }
                    default: {
                        result.append(lexeme);
                    }
                }
                if (nextToken == 50) {
                    previousToken = 52;
                    singleLineComment = true;
                    continue;
                }
                if (nextToken == 51) continue;
                previousToken = nextToken;
                singleLineComment = false;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!textToFormat.endsWith(StringUtility.DEFAULT_LINE_SEPARATOR)) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }
}

