/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Node;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureCycleAnalyzer;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureVisitor;
import com.hello2morrow.sonargraph.core.controller.system.architecture.IArchitectureFileLoader;
import com.hello2morrow.sonargraph.core.model.architecture.AcceptsAllFilter;
import com.hello2morrow.sonargraph.core.model.architecture.AndFilter;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementCloner;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFileIssue;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactClass;
import com.hello2morrow.sonargraph.core.model.architecture.ArtifactTemplate;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectTo;
import com.hello2morrow.sonargraph.core.model.architecture.Connection;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionSchemeConnection;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.ConstantStringFilter;
import com.hello2morrow.sonargraph.core.model.architecture.CyclicArtifactIssue;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetrieverProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.Identifier;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.NotFilter;
import com.hello2morrow.sonargraph.core.model.architecture.ParsedPatternInfo;
import com.hello2morrow.sonargraph.core.model.architecture.PatternFilter;
import com.hello2morrow.sonargraph.core.model.architecture.RequiredConnection;
import com.hello2morrow.sonargraph.core.model.architecture.TransitiveConnection;
import com.hello2morrow.sonargraph.core.model.architecture.UnresolvedRequiredArtifactIssue;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Joiner;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitectureBuilder
extends ArchitectureVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureBuilder.class);
    private static final String VALUE = "val";
    private static final String NAME = "name";
    private static final String DEFAULT = "default";
    private static final String ID_ANY = "any";
    private static final String ID_TARGET = "target";
    private final Map<NamedElement, List<DelayedProcessor>> m_processorMap = new THashMap();
    private final List<RequiredConnection> m_requiredConnections = new ArrayList<RequiredConnection>();
    private final List<TransitiveConnection> m_transitiveConnections = new ArrayList<TransitiveConnection>();
    private final List<ConnectTo> m_connectToStatements = new ArrayList<ConnectTo>();
    private final List<Connection> m_connections = new ArrayList<Connection>();
    private final ArchitectureFile m_file;
    private final IArchitectureFileLoader m_loader;
    private final IAssignableAttributeRetrieverProvider m_retrieverProvider;
    private final AcceptsAllFilter m_acceptsAllFilter;
    private final EnumSet<IArchitecturalModelProvider.ArchitectureModel> m_supportedModels;
    private final String m_usedLanguages;
    private NamedElement m_currentParent;
    private ArchitectureElement m_currentContainer;
    private IArchitectureElementContainer m_currentElementContainer;
    private EnumSet<CoreParserDependencyType> m_currentDependencyTypes;
    private Interface m_currentInterface;
    private Connector m_currentConnector;
    private boolean m_isInclude;
    private boolean m_isExtension;
    private ConnectionScheme m_currentScheme;
    private ArtifactClass m_currentClass;
    private ArtifactClass m_fromClass;
    private ArtifactClass m_toClass;
    private ArtifactTemplate m_currentTemplate;

    ArchitectureBuilder(ArchitectureFile file, IArchitectureFileLoader loader, IAssignableAttributeRetrieverProvider retrieverProvider, EnumSet<IArchitecturalModelProvider.ArchitectureModel> supported, String usedLanguages) {
        assert (file != null) : "Parameter 'file' of method 'ArchitectureBuilder' must not be null";
        assert (loader != null) : "Parameter 'loader' of method 'ArchitectureBuilder' must not be null";
        assert (retrieverProvider != null) : "Parameter 'retrieverProvider' of method 'ArchitectureBuilder' must not be null";
        assert (supported != null) : "Parameter 'supported' of method 'ArchitectureBuilder' must not be null";
        assert (usedLanguages != null) : "Parameter 'usedLanguages' of method 'ArchitectureBuilder' must not be null";
        this.m_file = file;
        this.m_file.setModel(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
        this.m_loader = loader;
        this.m_currentContainer = null;
        this.m_currentElementContainer = this.m_file;
        this.m_currentParent = this.m_file;
        this.m_retrieverProvider = retrieverProvider;
        this.m_acceptsAllFilter = new AcceptsAllFilter(this.m_retrieverProvider.getAttributeRetriever("ArchitectureFilterName"), -1);
        this.m_supportedModels = EnumSet.copyOf(supported);
        this.m_usedLanguages = usedLanguages;
    }

    private void addProcessor(DelayedProcessor proc) {
        List<DelayedProcessor> processors = this.m_processorMap.get(this.m_currentParent);
        if (processors == null) {
            processors = new ArrayList<DelayedProcessor>();
            this.m_processorMap.put(this.m_currentParent, processors);
        }
        processors.add(proc);
    }

    private void executeProcessors() {
        List<DelayedProcessor> processors = this.m_processorMap.remove(this.m_currentParent);
        if (processors != null) {
            processors.forEach(DelayedProcessor::process);
        }
    }

    private void visitChildren(InnerNode arg, NamedElement newParent, Node ... ignore) {
        if (newParent instanceof IArchitectureElementContainer) {
            this.m_currentElementContainer = (IArchitectureElementContainer)((Object)newParent);
        }
        if (newParent instanceof ArchitectureElement) {
            this.m_currentContainer = (ArchitectureElement)newParent;
        }
        this.m_currentParent = newParent;
        arg.visitChildren((Visitor)this, ignore);
        this.m_currentParent = this.m_currentParent.getParent();
        if (this.m_currentParent instanceof Artifact) {
            this.m_currentElementContainer = (Artifact)this.m_currentParent;
            this.m_currentContainer = (Artifact)this.m_currentElementContainer;
        } else if (this.m_currentParent instanceof IArchitectureElementContainer) {
            this.m_currentElementContainer = (IArchitectureElementContainer)((Object)this.m_currentParent);
            this.m_currentContainer = null;
        } else {
            this.m_currentElementContainer = null;
            this.m_currentContainer = null;
        }
    }

    private void connectArtifacts(Artifact from, Artifact to) {
        Connector fromConn = from.getArchitectureElement(DEFAULT, Connector.class);
        Interface toInterface = to.getArchitectureElement(DEFAULT, Interface.class);
        assert (fromConn != null);
        assert (toInterface != null);
        fromConn.connectTo(toInterface, true, false);
    }

    private void processPublicArtifacts(NamedElement parent) {
        List siblings = parent.getChildren(Artifact.class).stream().filter(a -> !a.isRequired()).collect(Collectors.toList());
        int index = 0;
        for (Artifact currentSibling : siblings) {
            if (currentSibling.isPublic()) {
                int siblingIndex = 0;
                while (siblingIndex < index) {
                    Artifact nextSibling = (Artifact)siblings.get(siblingIndex);
                    this.connectArtifacts(nextSibling, currentSibling);
                    ++siblingIndex;
                }
            }
            ++index;
        }
    }

    private void processStrictAndRelaxedArtifacts(NamedElement parent) {
        List siblings = parent.getChildren(Artifact.class).stream().filter(a -> !a.isRequired()).collect(Collectors.toList());
        int index = 0;
        for (Artifact currentSibling : siblings) {
            if (++index >= siblings.size()) continue;
            if (currentSibling.isStrict()) {
                Artifact nextSibling = (Artifact)siblings.get(index);
                if (nextSibling.isPublic()) continue;
                this.connectArtifacts(currentSibling, nextSibling);
                continue;
            }
            if (!currentSibling.isRelaxed()) continue;
            int siblingIndex = index;
            while (siblingIndex < siblings.size()) {
                Artifact nextSibling = (Artifact)siblings.get(siblingIndex);
                if (!nextSibling.isPublic()) {
                    this.connectArtifacts(currentSibling, nextSibling);
                }
                ++siblingIndex;
            }
        }
    }

    @Override
    public void visitBody(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        this.executeProcessors();
        this.processPublicArtifacts(this.m_currentParent);
        this.processStrictAndRelaxedArtifacts(this.m_currentParent);
        if (this.m_currentContainer == null) {
            this.processConnectToStatements();
            this.m_connections.forEach(c -> this.processConnection((Connection)c));
            this.processRequiredConnections();
            ArchitectureCycleAnalyzer cycleAnalyzer = new ArchitectureCycleAnalyzer(this.m_file);
            List<List<Artifact>> cycleGroups = cycleAnalyzer.getCycleGroups();
            for (List<Artifact> group : cycleGroups) {
                StringBuilder sb = new StringBuilder("Artifact is part of cyclic dependency involving: ");
                sb.append(Joiner.join(group, a -> a.getName()));
                for (Artifact artifact : group) {
                    CyclicArtifactIssue issue = new CyclicArtifactIssue(artifact, sb.toString(), artifact.getContextLineNumber());
                    artifact.addIssue(issue);
                }
            }
        }
    }

    private void createDefaultInterfaceAndConnector(Artifact newArtifact, Position pos) {
        Connector defaultConnector;
        Interface defaultInterface = newArtifact.getArchitectureElement(DEFAULT, Interface.class);
        if (defaultInterface == null || defaultInterface.isAutoDefined()) {
            if (defaultInterface == null) {
                defaultInterface = new Interface(newArtifact, DEFAULT, this.m_file, pos.getLine(), true, true);
                newArtifact.addChild(defaultInterface);
            } else {
                defaultInterface.override(this.m_file, pos.getLine());
            }
            defaultInterface.addIncludeFilter(this.m_acceptsAllFilter);
            for (Artifact child : newArtifact.getChildren(Artifact.class)) {
                if (child.isHidden() || child.isRequired()) continue;
                defaultInterface.addExportedInterface(child.getArchitectureElement(DEFAULT, Interface.class));
            }
        }
        if ((defaultConnector = newArtifact.getArchitectureElement(DEFAULT, Connector.class)) == null || defaultConnector.isAutoDefined()) {
            if (defaultConnector == null) {
                defaultConnector = new Connector(newArtifact, DEFAULT, this.m_file, pos.getLine(), true, true);
                newArtifact.addChild(defaultConnector);
            } else {
                defaultConnector.override(this.m_file, pos.getLine());
            }
            defaultConnector.addIncludeFilter(this.m_acceptsAllFilter);
            for (Artifact child : newArtifact.getChildren(Artifact.class)) {
                if (child.isLocal() || child.isRequired()) continue;
                defaultConnector.addIncludedConnector(child.getArchitectureElement(DEFAULT, Connector.class));
            }
        }
    }

    private ArtifactClass findClass(String className, Position classPos) {
        ArtifactClass artifactClass = this.m_currentElementContainer.resolveName(className, ArtifactClass.class);
        if (artifactClass == null && classPos != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Unknown class '%s'", className), classPos.getLine(), classPos.getColumn()));
        }
        return artifactClass;
    }

    private ArtifactClass findClass(Node classNode) {
        assert (classNode != null) : "Parameter 'classNode' of method 'findClass' must not be null";
        String className = classNode.getLexeme();
        return this.findClass(className, classNode.getPosition());
    }

    private void checkClassInterface(ArtifactClass artifactClass, Artifact newArtifact, Position pos) {
        Artifact nestedArtifact;
        assert (artifactClass != null) : "Parameter 'artifactClass' of method 'checkClassInterface' must not be null";
        assert (newArtifact != null) : "Parameter 'newArtifact' of method 'checkClassInterface' must not be null";
        assert (pos != null) : "Parameter 'pos' of method 'checkClassInterface' must not be null";
        for (String interfaceName : artifactClass.getInterfaces()) {
            Interface iface = newArtifact.getArchitectureElement(interfaceName, Interface.class);
            if (iface != null) continue;
            nestedArtifact = newArtifact.getArchitectureElement(interfaceName, Artifact.class);
            if (nestedArtifact == null) {
                List<Interface> nestedInterfaces = this.findNestedInterfaces(newArtifact, interfaceName);
                if (nestedInterfaces.size() == 0) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Artifact '%s' does not provide interface '%s' required by '%s'", newArtifact.getShortName(), interfaceName, artifactClass.getShortName()), pos.getLine(), pos.getColumn()));
                    continue;
                }
                Interface newInterface = new Interface(newArtifact, interfaceName, this.m_file, pos.getLine(), true, false);
                newArtifact.addChild(newInterface);
                nestedInterfaces.forEach(newInterface::addExportedInterface);
                continue;
            }
            if (nestedArtifact.isExposed()) continue;
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Artifact '%s.%s' must be exposed to be used as interface required by '%s'", newArtifact.getShortName(), interfaceName, artifactClass.getShortName()), pos.getLine(), pos.getColumn()));
        }
        for (String connectorName : artifactClass.getConnectors()) {
            Connector conn = newArtifact.getArchitectureElement(connectorName, Connector.class);
            if (conn != null || (nestedArtifact = newArtifact.getArchitectureElement(connectorName, Artifact.class)) != null) continue;
            List<Connector> nestedConnectors = this.findNestedConnectors(newArtifact, connectorName);
            if (nestedConnectors.size() == 0) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Artifact '%s' does not provide connector '%s' required by '%s'", newArtifact.getShortName(), connectorName, artifactClass.getShortName()), pos.getLine(), pos.getColumn()));
                continue;
            }
            Connector newConn = new Connector(newArtifact, connectorName, this.m_file, pos.getLine(), true, true);
            newArtifact.addChild(newConn);
            nestedConnectors.forEach(newConn::addIncludedConnector);
        }
    }

    @Override
    public void visitArtifactDecl(InnerNode arg) {
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        Position pos = ident.getPosition();
        Node classNode = arg.getChild("IDENT", 1);
        ArtifactClass artifactClass = null;
        if (classNode != null) {
            artifactClass = this.findClass(classNode);
        }
        if (this.checkArtifactName(name, pos, false)) {
            Artifact newArtifact = new Artifact(this.m_currentParent, name, this.m_file, pos.getLine(), artifactClass == null ? null : artifactClass.getShortName());
            boolean isExtension = this.m_isExtension;
            this.m_currentParent.addChild(newArtifact);
            this.m_isExtension = false;
            this.visitChildren(arg, newArtifact, new Node[0]);
            this.m_isExtension = isExtension;
            this.createDefaultInterfaceAndConnector(newArtifact, pos);
            if (artifactClass != null) {
                assert (classNode != null);
                this.checkClassInterface(artifactClass, newArtifact, classNode.getPosition());
            }
        }
    }

    private List<Connector> findNestedConnectors(Artifact parent, String name) {
        assert (parent != null) : "Parameter 'parent' of method 'findNestedConnectors' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'findNestedConnectors' must not be empty";
        ArrayList<Connector> result = new ArrayList<Connector>();
        for (Artifact nested : parent.getChildren(Artifact.class)) {
            Connector conn;
            if (nested.isLocal() || nested.isRequired() || (conn = this.resolveConnectorInArtifact(nested, new Identifier(null, name))) == null) continue;
            result.add(conn);
        }
        return result;
    }

    private List<Interface> findNestedInterfaces(Artifact parent, String name) {
        assert (parent != null) : "Parameter 'parent' of method 'findNestedInterfaces' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'findNestedInterfaces' must not be empty";
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (Artifact nested : parent.getChildren(Artifact.class)) {
            Interface iface;
            if (nested.isHidden() || nested.isRequired() || (iface = this.resolveInterfaceInContainer(nested, new Identifier(null, name), null)) == null) continue;
            result.add(iface);
        }
        return result;
    }

    @Override
    public void visitExtendDecl(InnerNode arg) {
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        Position pos = ident.getPosition();
        Artifact toBeExtended = this.m_currentParent.getFirstChild(e -> e.getShortName().equals(name), Artifact.class);
        if (toBeExtended != null) {
            boolean isExtension = this.m_isExtension;
            toBeExtended.prepareForExtend(this.m_file, pos.getLine());
            this.m_isExtension = true;
            this.visitChildren(arg, toBeExtended, new Node[0]);
            this.m_isExtension = isExtension;
            this.createDefaultInterfaceAndConnector(toBeExtended, pos);
        } else {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Cannot override non-existing artifact '" + name + "'", pos.getLine(), pos.getColumn()));
        }
    }

    private void processDisconnect(Artifact context, Connector from, Identifier target) {
        boolean success;
        Interface targetInterface = this.resolveInterface(context, target, target.getPosition());
        if (targetInterface != null && !(success = from.disconnect(targetInterface))) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' is not connected to '%s'", target.getQualifiedName(), from.getName()), target.getPosition().getLine(), target.getPosition().getColumn()));
        }
    }

    @Override
    public void visitDisconnectDecl(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        Node ident = arg.getChild("IDENT");
        String name = ident == null ? DEFAULT : ident.getLexeme();
        Position pos = ident == null ? arg.getPosition() : ident.getPosition();
        Connector conn = this.m_currentParent.getFirstChild(c -> c.getShortName().equals(name), Connector.class);
        if (conn != null) {
            List toList = (List)arg.getChildAt(arg.size() - 1).getAttribute(VALUE);
            toList.forEach(id -> this.processDisconnect((Artifact)this.m_currentContainer, conn, (Identifier)id));
        } else {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' is not a connector", name), pos.getLine(), pos.getColumn()));
        }
    }

    @Override
    public void visitPriority(InnerNode arg) {
        Node numberNode = arg.getChild("NUMBER");
        int priority = Integer.valueOf(numberNode.getLexeme());
        assert (this.m_currentContainer instanceof Artifact);
        Artifact artifact = (Artifact)this.m_currentContainer;
        if (artifact.isDeprecated()) {
            Position pos = numberNode.getPosition();
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Deprecated artifacts cannot have a priority", pos.getLine(), pos.getColumn()));
        } else {
            artifact.setPriority(priority);
        }
    }

    @Override
    public void visitApplyDecl(InnerNode arg) {
        assert (arg != null) : "Parameter 'arg' of method 'visitApplyDecl' must not be null";
        Node stringNode = arg.getChild("STRING");
        String name = stringNode.getLexeme();
        assert (name != null) : "'name' of method 'visitApplyDecl' must not be null";
        LOGGER.debug("ApplyDecl for {}", (Object)name);
        Position pos = stringNode.getPosition();
        name = name.substring(1, name.length() - 1);
        if (name.length() == 0) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Architecture file name in 'apply' cannot be empty", pos.getLine(), pos.getColumn()));
        } else {
            ArchitectureFile file = this.m_loader.loadArchitectureFile(name, msg -> this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, (String)msg, pos.getLine(), pos.getColumn())));
            if (file != null) {
                file.usedInApplyOrRequire(true);
                if (file.hasIssues(Severity.ERROR)) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Errors in applied architecture file '" + name + "'", pos.getLine(), pos.getColumn()));
                } else {
                    ArchitectureFile clonedFile = ArchitectureElementCloner.clone(file, ArchitectureFile.class);
                    for (Artifact artifact : clonedFile.getChildren(Artifact.class)) {
                        if (!this.checkArtifactName(artifact.getShortName(), pos, artifact.isRequired())) continue;
                        artifact.changeParent(this.m_currentParent, true);
                        artifact.setReferencedFromLineNumber(pos.getLine());
                        if (!artifact.hasStrongIncludes()) continue;
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Applied files cannot have strong include statements (see artifact %s).", artifact.getShortName()), pos.getLine(), pos.getColumn()));
                    }
                    for (Interface interface_ : clonedFile.getChildren(Interface.class)) {
                        this.checkInterfaceName(interface_.getShortName(), pos);
                        interface_.changeParent(this.m_currentParent, true);
                        interface_.setReferencedFromLineNumber(pos.getLine());
                    }
                    for (Connector connector : clonedFile.getChildren(Connector.class)) {
                        this.checkConnectorName(connector.getShortName(), pos);
                        connector.changeParent(this.m_currentParent, true);
                        connector.setReferencedFromLineNumber(pos.getLine());
                    }
                    for (ConnectionScheme connectionScheme : clonedFile.getChildren(ConnectionScheme.class)) {
                        this.checkElementName(connectionScheme.getShortName(), pos);
                        connectionScheme.changeParent(this.m_currentParent, true);
                    }
                    for (ArtifactClass artifactClass : clonedFile.getChildren(ArtifactClass.class)) {
                        this.checkElementName(artifactClass.getShortName(), pos);
                        artifactClass.changeParent(this.m_currentParent, true);
                    }
                    this.m_requiredConnections.addAll(clonedFile.getRequiredConnections());
                }
            }
        }
    }

    @Override
    public void visitRequireDecl(InnerNode arg) {
        Node stringNode = arg.getChild("STRING");
        String name = stringNode.getLexeme();
        Position pos = stringNode.getPosition();
        if ((name = name.substring(1, name.length() - 1)).length() == 0) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Architecture file name in 'require' cannot be empty", pos.getLine(), pos.getColumn()));
        } else {
            ArchitectureFile file = this.m_loader.loadArchitectureFile(name, msg -> this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, (String)msg, pos.getLine(), pos.getColumn())));
            if (file != null) {
                file.usedInApplyOrRequire(true);
                if (file.hasIssues(Severity.ERROR)) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Errors in required architecture file '" + name + "'", pos.getLine(), pos.getColumn()));
                } else if (!(this.m_currentParent instanceof ArchitectureFile)) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'require' is not allowed within artifacts", pos.getLine(), pos.getColumn()));
                } else {
                    ArchitectureFile clonedFile = ArchitectureElementCloner.clone(file, ArchitectureFile.class);
                    for (Artifact child : clonedFile.getChildren(Artifact.class)) {
                        if (!child.isRequired()) continue;
                        child.remove();
                    }
                    for (Artifact child : clonedFile.getChildrenRecursively(Artifact.class, new Class[0])) {
                        child.removeChildren(Connector.class);
                    }
                    for (Artifact child : clonedFile.getChildren(Artifact.class)) {
                        child.markAsRequired();
                        if (!this.checkArtifactName(child.getShortName(), pos, true)) continue;
                        child.changeParent(this.m_currentParent, true);
                        child.setReferencedFromLineNumber(pos.getLine());
                    }
                }
            } else {
                LOGGER.warn("Architecture file with name {} not found", (Object)name);
            }
        }
    }

    private IAssignableFilter checkAndCreatePattern(InnerNode arg, boolean isInclude) {
        assert (arg != null) : "Parameter 'arg' of method 'checkAndCreatePattern' must not be null";
        Position pos = arg.getChildAt(0).getPosition();
        if (this.m_currentContainer == null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Patterns cannot be used outside of artifacts", pos.getLine(), pos.getColumn()));
            return null;
        }
        Node patternNode = arg.getChild("PatternExpr");
        if (patternNode == null) {
            if (arg.getChildAt(1).getType() == 16) {
                return new AcceptsAllFilter(this.m_retrieverProvider.getAttributeRetriever("ArchitectureFilterName"), pos.getLine());
            }
            if (this.m_currentInterface == null) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Dependency type restrictions are only allowed within interfaces", pos.getLine(), pos.getColumn()));
            } else {
                this.m_currentDependencyTypes = isInclude ? EnumSet.noneOf(CoreParserDependencyType.class) : EnumSet.allOf(CoreParserDependencyType.class);
                this.m_isInclude = isInclude;
                arg.visitChildren((Visitor)this, new Node[0]);
                this.m_currentInterface.setAllowedDependencyTypes(this.m_currentDependencyTypes);
                this.m_currentDependencyTypes = null;
            }
            return null;
        }
        return this.createFilter(patternNode, arg.getChildAt(0).getType() == 11, arg.getChildAt(0).getType() == 33);
    }

    private IAssignableFilter createFilterFromPattern(ParsedPatternInfo parsedPatternInfo, Position pos) {
        assert (parsedPatternInfo != null);
        String originalPattern = parsedPatternInfo.getOriginalPattern();
        String patternString = parsedPatternInfo.getPattern();
        String[] params = parsedPatternInfo.getParams();
        IAssignableAttributeRetriever retriever = parsedPatternInfo.getRetriever();
        if (patternString.equals("**")) {
            if (parsedPatternInfo.isStrong()) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'**' cannot be used as strong pattern", pos.getLine(), pos.getColumn()));
            }
            return new AcceptsAllFilter(parsedPatternInfo.getRetriever(), params, pos.getLine());
        }
        if (patternString.indexOf(42) < 0 && patternString.indexOf(63) < 0 && patternString.indexOf(40) < 0) {
            return new ConstantStringFilter(retriever, originalPattern, patternString, parsedPatternInfo.isStrong(), parsedPatternInfo.isOptional(), params, pos.getLine());
        }
        try {
            return new PatternFilter(parsedPatternInfo, pos.getLine());
        }
        catch (PatternSyntaxException e) {
            assert (false) : "Not expected here: " + ExceptionUtility.collectAll((Throwable)e);
            return null;
        }
    }

    private IAssignableFilter createFilterFromStringNode(Node stringNode, boolean isStrong, boolean isOptional) {
        assert (stringNode != null);
        String lexeme = stringNode.getLexeme();
        Position pos = stringNode.getPosition();
        ParsedPatternInfo parsedPatternInfo = ParsedPatternInfo.parsePattern(lexeme.substring(1, lexeme.length() - 1), isStrong, isOptional, this.m_retrieverProvider);
        if (parsedPatternInfo.isValid()) {
            return this.createFilterFromPattern(parsedPatternInfo, pos);
        }
        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, parsedPatternInfo.getErrorMessage(), pos.getLine(), pos.getColumn()));
        return null;
    }

    private IAssignableFilter createFilter(Node patternNode, boolean isStrong, boolean isOptional) {
        assert (patternNode != null) : "Parameter 'stringNode' of method 'createFilter' must not be null";
        IAssignableFilter result = null;
        boolean sawNot = false;
        for (Node node : ((InnerNode)patternNode).getChildren()) {
            if (node.getType() == 42) {
                sawNot = true;
                continue;
            }
            if (node.getType() != 3) continue;
            IAssignableFilter filter = this.createFilterFromStringNode(node, isStrong, isOptional);
            if (sawNot && filter != null) {
                filter = new NotFilter(filter);
            }
            sawNot = false;
            if (result == null) {
                result = filter;
                continue;
            }
            if (filter == null) continue;
            result = new AndFilter(result, filter);
        }
        return result;
    }

    @Override
    public void visitDependencyType(InnerNode arg) {
        if (this.m_currentDependencyTypes != null) {
            Node id = arg.getChildAt(0);
            Position pos = id.getPosition();
            String name = id.getLexeme();
            try {
                CoreParserDependencyType type = CoreParserDependencyType.valueOf(name);
                if (this.m_isInclude) {
                    this.m_currentDependencyTypes.add(type);
                } else {
                    this.m_currentDependencyTypes.remove((Object)type);
                }
            }
            catch (IllegalArgumentException e) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' is not an allowed dependency type", name), pos.getLine(), pos.getColumn()));
            }
        }
    }

    @Override
    public void visitIncludeDecl(InnerNode arg) {
        IAssignableFilter filter = this.checkAndCreatePattern(arg, true);
        if (filter != null) {
            if (filter.isStrong() && !(this.m_currentContainer instanceof Artifact)) {
                Position pos = arg.getChildAt(0).getPosition();
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'strong' can only be used within an artifact", pos.getLine(), pos.getColumn()));
            } else if (this.m_currentContainer.acceptsPatterns()) {
                this.m_currentContainer.addIncludeFilter(filter);
            } else {
                Position pos = arg.getChildAt(0).getPosition();
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "template artifacts cannot specify include patterns", pos.getLine(), pos.getColumn()));
            }
        }
    }

    @Override
    public void visitExcludeDecl(InnerNode arg) {
        IAssignableFilter filter = this.checkAndCreatePattern(arg, false);
        if (filter != null) {
            if (this.m_currentContainer.acceptsPatterns()) {
                this.m_currentContainer.addExcludeFilter(filter);
            } else {
                Position pos = arg.getChildAt(0).getPosition();
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "template artifacts cannot specify exclude patterns", pos.getLine(), pos.getColumn()));
            }
        }
    }

    private boolean checkArtifactName(String name, Position pos, boolean isRequired) {
        assert (name != null) : "Parameter 'name' of method 'checkArtifactName' must not be null";
        if (name.equals(DEFAULT)) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name 'default' is not allowed for artifacts", pos.getLine(), pos.getColumn()));
            return false;
        }
        List<IArchitectureElement> elementsWithSameName = this.m_currentParent.getChildren(e -> e.getShortName().equals(name), IArchitectureElement.class);
        List<Artifact> artifactsWithSameName = this.m_currentParent.getChildren(e -> e.getShortName().equals(name), Artifact.class);
        boolean result = true;
        boolean reportError = false;
        if (elementsWithSameName.size() > artifactsWithSameName.size()) {
            result = false;
            reportError = true;
        }
        if (isRequired) {
            if (artifactsWithSameName.size() > 0) {
                result = false;
            }
        } else {
            Optional<Artifact> requiredSibling = artifactsWithSameName.stream().filter(a -> a.isRequired()).findFirst();
            if (requiredSibling.isPresent()) {
                requiredSibling.get().remove();
            }
            if (artifactsWithSameName.stream().anyMatch(a -> !a.isRequired())) {
                result = true;
                reportError = true;
            }
        }
        if (reportError) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name '" + name + "' is already used", pos.getLine(), pos.getColumn(), true));
        }
        return result;
    }

    private boolean checkElementName(String name, Position pos) {
        if (this.m_currentElementContainer.resolveName(name, NamedElement.class) != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name '" + name + "' is already used", pos.getLine(), pos.getColumn()));
            return false;
        }
        if (name.equals(DEFAULT)) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name 'default' is not allowed here", pos.getLine(), pos.getColumn()));
            return false;
        }
        return true;
    }

    private boolean checkConnectorName(String name, Position pos) {
        if (this.m_currentParent.getFirstChild(e -> e.getShortName().equals(name), Artifact.class) != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name '" + name + "' is already used by an artifact", pos.getLine(), pos.getColumn()));
            return false;
        }
        if (this.m_currentParent.getFirstChild(e -> e.getShortName().equals(name), Connector.class) != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name '" + name + "' is already used by a connector", pos.getLine(), pos.getColumn()));
            return false;
        }
        return true;
    }

    private boolean checkInterfaceName(String name, Position pos) {
        if (this.m_currentParent.getFirstChild(e -> e.getShortName().equals(name), Artifact.class) != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name '" + name + "' is already used by an artifact", pos.getLine(), pos.getColumn()));
            return false;
        }
        if (this.m_currentParent.getFirstChild(e -> e.getShortName().equals(name), Interface.class) != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Name '" + name + "' is already used by an interface", pos.getLine(), pos.getColumn()));
            return false;
        }
        return true;
    }

    @Override
    public void visitInterfaceDecl(InnerNode arg) {
        boolean isOptional;
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        Position pos = ident.getPosition();
        boolean isOverride = arg.getChildAt(0).getType() == 27;
        boolean bl = isOptional = arg.getChildAt(0).getType() == 33;
        if (isOverride) {
            if (this.m_isExtension) {
                this.m_currentInterface = this.m_currentParent.getFirstChild(c -> c.getShortName().equals(name), Interface.class);
                if (this.m_currentInterface != null) {
                    this.m_currentInterface.override(this.m_file, pos.getLine());
                    this.visitChildren(arg, this.m_currentInterface, new Node[0]);
                    this.m_currentInterface = null;
                } else {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("interface '%s' does not exist and therefore cannot be overridden", name), pos.getLine(), pos.getColumn()));
                }
            } else {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'override' can only be used with extended artifacts", pos.getLine(), pos.getColumn()));
            }
        } else if (this.checkInterfaceName(name, pos)) {
            Interface iface = new Interface(this.m_currentParent, name, this.m_file, pos.getLine(), false, isOptional);
            this.m_currentParent.addChild(iface);
            this.addProcessor(new InterfaceProcessor(iface, arg));
        }
    }

    @Override
    public void visitInterfaceExt(InnerNode arg) {
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        Position pos = ident.getPosition();
        this.m_currentInterface = this.m_currentParent.getFirstChild(c -> c.getShortName().equals(name), Interface.class);
        if (this.m_currentInterface == null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("interface '%s' does not exist and therefore cannot be extended", name), pos.getLine(), pos.getColumn()));
        } else {
            this.visitChildren(arg, this.m_currentInterface, new Node[0]);
            this.m_currentInterface = null;
        }
    }

    @Override
    public void visitConnectorDecl(InnerNode arg) {
        boolean isOptional;
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        Position pos = ident.getPosition();
        boolean isOverride = arg.getChildAt(0).getType() == 27;
        boolean bl = isOptional = arg.getChildAt(0).getType() == 33;
        if (isOverride) {
            if (this.m_isExtension) {
                Connector conn = this.m_currentParent.getFirstChild(c -> c.getShortName().equals(name), Connector.class);
                if (conn != null) {
                    conn.override(this.m_file, pos.getLine());
                    this.m_currentConnector = conn;
                    this.visitChildren(arg, conn, new Node[0]);
                    this.m_currentConnector = null;
                } else {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("connector '%s' does not exist and therefore cannot be overridden", name), pos.getLine(), pos.getColumn()));
                }
            } else {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'override' can only be used with extended artifacts", pos.getLine(), pos.getColumn()));
            }
        } else if (this.checkConnectorName(name, pos)) {
            Connector newConnector = new Connector(this.m_currentParent, name, this.m_file, pos.getLine(), false, isOptional);
            this.m_currentParent.addChild(newConnector);
            this.addProcessor(new ConnectorProcessor(newConnector, arg));
        }
    }

    @Override
    public void visitConnectorExt(InnerNode arg) {
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        Position pos = ident.getPosition();
        Connector connector = this.m_currentParent.getFirstChild(c -> c.getShortName().equals(name), Connector.class);
        if (connector == null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("connector '%s' does not exist and therefore cannot be extended", name), pos.getLine(), pos.getColumn()));
        } else {
            this.visitChildren(arg, connector, new Node[0]);
        }
    }

    @Override
    public void visitSpecIdentList(InnerNode arg) {
        this.visitIdentList(arg);
    }

    @Override
    public void visitIdentList(InnerNode arg) {
        ArrayList<Identifier> idList = new ArrayList<Identifier>();
        arg.visitChildren((Visitor)this, new Node[0]);
        int i = 0;
        while (i < arg.size()) {
            idList.add((Identifier)arg.getChildAt(i).getAttribute(VALUE));
            ++i;
        }
        arg.setAttribute(VALUE, idList);
    }

    @Override
    public void visitSpecIdent(InnerNode arg) {
        this.visitIdentifier(arg);
    }

    @Override
    public void visitIdentifier(InnerNode arg) {
        Node idNode = arg.getChildAt(0);
        Position pos = idNode.getPosition();
        Identifier id = new Identifier(pos);
        for (Node node : arg.getChildren()) {
            String lexeme = node.getLexeme();
            if (lexeme == null) {
                switch (node.getType()) {
                    case 30: {
                        lexeme = ID_TARGET;
                        break;
                    }
                    case 17: {
                        lexeme = ID_ANY;
                        break;
                    }
                    default: {
                        assert (false) : "unexpected token type: " + node.getType();
                        break;
                    }
                }
            }
            id.addIdent(lexeme);
        }
        arg.setAttribute(VALUE, (Object)id);
    }

    @Override
    public void visitTargetIdent(InnerNode arg) {
        this.visitIdentifier(arg);
    }

    @Override
    public void visitTargetIdentList(InnerNode arg) {
        this.visitIdentList(arg);
    }

    @Override
    public void visitTargetUse(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        assert (arg.size() >= 4) : "Architecture visitor problem";
        Identifier from = (Identifier)arg.getChild("Identifier").getAttribute(VALUE);
        List to = (List)arg.getChild("TargetIdentList").getAttribute(VALUE);
        if (this.m_fromClass != null && from.numberOfParts() == 1) {
            if (!this.m_fromClass.getConnectors().contains(from.getIdent())) {
                Position pos = from.getPosition();
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Class '%s' does not provide connector '%s'", this.m_fromClass.getShortName(), from.getIdent()), pos.getLine(), pos.getColumn()));
            }
            if (this.m_toClass != null) {
                for (Identifier id : to) {
                    if (id.numberOfParts() != 2 || this.m_toClass.getInterfaces().contains(id.getQualifier())) continue;
                    Position pos = id.getPosition();
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Class '%s' does not provide interface '%s'", this.m_toClass.getShortName(), id.getQualifier()), pos.getLine(), pos.getColumn()));
                }
            }
        }
        this.m_currentScheme.addConnection(from, to, arg.getChildAt(1).getType() == 17);
    }

    private void stereoTypeIssue(Position pos) {
        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'unrestricted', 'strict' and 'relaxed' are mutually exclusive", pos.getLine(), pos.getColumn()));
    }

    @Override
    public void visitStereoType(InnerNode arg) {
        Node node = arg.getChildAt(0);
        Artifact artifact = (Artifact)this.m_currentContainer;
        Position pos = node.getPosition();
        if (artifact == null) {
            return;
        }
        if (node.getType() == 19) {
            artifact.makeHidden();
        } else if (node.getType() == 18) {
            artifact.makePublic();
        } else if (node.getType() == 21) {
            artifact.makeLocal();
        } else if (node.getType() == 10) {
            artifact.makeExposed();
        } else if (node.getType() == 34) {
            artifact.makeDeprecated();
        } else if (node.getType() == 33) {
            artifact.makeOptional();
        } else if (node.getType() == 35) {
            if (artifact.isStrict() || artifact.isRelaxed()) {
                this.stereoTypeIssue(pos);
            } else {
                artifact.makeUnrestricted();
            }
        } else if (node.getType() == 36) {
            if (artifact.isStrict() || artifact.isUnrestricted()) {
                this.stereoTypeIssue(pos);
            } else {
                artifact.makeRelaxed();
            }
        } else if (node.getType() == 37) {
            if (artifact.isUnrestricted() || artifact.isRelaxed()) {
                this.stereoTypeIssue(pos);
            } else {
                artifact.makeStrict();
            }
        }
    }

    @Override
    public void visitExport(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        List identifiers = (List)arg.getChildAt(1).getAttribute(VALUE);
        Interface current = (Interface)this.m_currentParent;
        for (Identifier ident : identifiers) {
            if (ident.getIdent() == ID_ANY) {
                if (ident.getQualifier() == null) {
                    for (Artifact artifact : this.m_currentElementContainer.getContainer().getChildren(Artifact.class)) {
                        if (artifact.isHidden() || artifact.isRequired()) continue;
                        current.addExportedInterface(artifact.getArchitectureElement(DEFAULT, Interface.class));
                    }
                    continue;
                }
                int exportCount = 0;
                for (Artifact artifact : this.m_currentElementContainer.getContainer().getChildren(Artifact.class)) {
                    Interface iface;
                    if (artifact.isRequired() || (iface = this.resolveInterfaceInContainer(artifact, ident.shiftLeft(), null)) == null) continue;
                    current.addExportedInterface(iface);
                    ++exportCount;
                }
                if (exportCount != 0) continue;
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("No interfaces are matched by '%s'", ident.getQualifiedName()), ident.getPosition().getLine(), ident.getPosition().getColumn()));
                continue;
            }
            Interface iface = this.resolveLocalInterface(this.m_currentElementContainer, ident);
            if (iface == null) {
                if (this.m_currentElementContainer instanceof Artifact) {
                    this.m_transitiveConnections.add(new TransitiveConnection(current, (Artifact)this.m_currentElementContainer, ident));
                    continue;
                }
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Cannot resolve '%s'", ident.getQualifiedName()), ident.getPosition().getLine(), ident.getPosition().getColumn()));
                continue;
            }
            if (iface != this.m_currentInterface) {
                current.addExportedInterface(iface);
                continue;
            }
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Interface '%s' cannot export itself", ident.getQualifiedName()), ident.getPosition().getLine(), ident.getPosition().getColumn()));
        }
    }

    private Connector findConnector(IArchitectureElementContainer context, Identifier ident) {
        Connector conn = context.findConnectorOrInterface(ident, Connector.class);
        if (conn == null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Cannot resolve '" + ident.toString() + "'", ident.getPosition().getLine(), ident.getPosition().getColumn()));
        }
        return conn;
    }

    @Override
    public void visitInclude(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        List identifiers = (List)arg.getChildAt(1).getAttribute(VALUE);
        Connector current = (Connector)this.m_currentParent;
        for (Identifier ident : identifiers) {
            if (ident.getIdent() == ID_ANY) {
                if (ident.getQualifier() == null) {
                    for (Artifact artifact : this.m_currentElementContainer.getContainer().getChildren(Artifact.class)) {
                        if (artifact.isLocal() || artifact.isRequired()) continue;
                        current.addIncludedConnector(artifact.getArchitectureElement(DEFAULT, Connector.class));
                    }
                    continue;
                }
                int includeCount = 0;
                for (Artifact artifact : this.m_currentElementContainer.getContainer().getChildren(Artifact.class)) {
                    Connector conn;
                    if (artifact.isRequired() || (conn = this.resolveConnectorInArtifact(artifact, ident.shiftLeft())) == null) continue;
                    current.addIncludedConnector(conn);
                    ++includeCount;
                }
                if (includeCount != 0) continue;
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("No connectors are matched by '%s'", ident.getQualifiedName()), ident.getPosition().getLine(), ident.getPosition().getColumn()));
                continue;
            }
            Connector included = this.findConnector(this.m_currentElementContainer, ident);
            if (included == null) continue;
            if (included != this.m_currentConnector) {
                current.addIncludedConnector(included);
                continue;
            }
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Connectors '%s' cannot include itself", ident.getQualifiedName()), ident.getPosition().getLine(), ident.getPosition().getColumn()));
        }
    }

    @Override
    public void visitClassDecl(InnerNode arg) {
        Position pos;
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        if (this.checkElementName(name, pos = ident.getPosition())) {
            this.m_currentClass = new ArtifactClass(this.m_currentParent, name, this.m_file, pos.getLine());
            this.m_currentParent.addChild(this.m_currentClass);
            arg.visitChildren((Visitor)this, new Node[0]);
            this.m_currentClass = null;
        }
    }

    @Override
    public void visitClassMember(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        Node kw = arg.getChildAt(0);
        InnerNode list = (InnerNode)arg.getChildAt(1);
        if (kw.getType() == 12) {
            for (Node node : list.getChildren()) {
                Position pos;
                String name = node.getLexeme();
                if (this.m_currentClass.getInterfaces().contains(name)) {
                    pos = node.getPosition();
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Duplicate name '%s'", name), pos.getLine(), pos.getColumn()));
                    continue;
                }
                if (name.equals(DEFAULT)) {
                    pos = node.getPosition();
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Cannot use 'default' here", pos.getLine(), pos.getColumn()));
                    continue;
                }
                this.m_currentClass.addInterface(name);
            }
        } else {
            for (Node node : list.getChildren()) {
                Position pos;
                String name = node.getLexeme();
                if (this.m_currentClass.getConnectors().contains(name)) {
                    pos = node.getPosition();
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Duplicate name '%s'", name), pos.getLine(), pos.getColumn()));
                    continue;
                }
                if (name.equals(DEFAULT)) {
                    pos = node.getPosition();
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Cannot use 'default' here", pos.getLine(), pos.getColumn()));
                    continue;
                }
                this.m_currentClass.addConnector(name);
            }
        }
    }

    @Override
    public void visitScheme(InnerNode arg) {
        Position pos;
        Node ident = arg.getChild("IDENT");
        String name = ident.getLexeme();
        if (this.checkElementName(name, pos = ident.getPosition())) {
            Node fromClassNode = arg.getChild("IDENT", 1);
            this.m_fromClass = null;
            this.m_toClass = null;
            if (fromClassNode != null) {
                Node toClassNode = arg.getChild("IDENT", 2);
                assert (toClassNode != null) : "'toClassNode' of method 'visitScheme' must not be null";
                this.m_fromClass = this.findClass(fromClassNode);
                this.m_toClass = this.findClass(toClassNode);
            }
            this.m_currentScheme = new ConnectionScheme(this.m_currentParent, name, this.m_file, pos.getLine(), this.m_fromClass == null ? null : this.m_fromClass.getShortName(), this.m_toClass == null ? null : this.m_toClass.getShortName());
            this.m_currentParent.addChild(this.m_currentScheme);
            arg.visitChildren((Visitor)this, new Node[0]);
            this.m_currentScheme = null;
            this.m_fromClass = null;
            this.m_toClass = null;
        }
    }

    @Override
    public void visitConnection(InnerNode arg) {
        boolean isDeprecated;
        if (!(this.m_currentContainer instanceof Artifact)) {
            Position pos = arg.getChildAt(0).getPosition();
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'connect' can only be used within an artifact", pos.getLine(), pos.getColumn()));
            return;
        }
        Node firstIdent = arg.getChild("IDENT");
        boolean bl = isDeprecated = arg.getChild("DEPRECATED") != null;
        if (firstIdent != null) {
            if (arg.getChild("CLASS") != null) {
                ArtifactClass cls = this.findClass(firstIdent);
                if (cls == null) {
                    return;
                }
                Node secondIdent = arg.getChild("IDENT", 1);
                Position pos = secondIdent.getPosition();
                String name = secondIdent.getLexeme();
                ConnectionScheme scheme = this.m_currentContainer.resolveName(name, ConnectionScheme.class);
                if (scheme == null) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Unknown connection scheme '%s'", name), pos.getLine(), pos.getColumn()));
                    return;
                }
                String toClass = scheme.getToClassName();
                if (toClass == null || !toClass.equals(cls.getShortName())) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Connection scheme must have '%s' as target class", cls.getShortName()), pos.getLine(), pos.getColumn()));
                    return;
                }
                String fromClass = scheme.getFromClassName();
                assert (fromClass != null);
                Artifact fromArtifact = (Artifact)this.m_currentContainer;
                if (!fromClass.equals(fromArtifact.getClassName())) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Source artifact '%s' must be of class '%s'", fromArtifact.getShortName(), fromClass), pos.getLine(), pos.getColumn()));
                    return;
                }
                this.m_connections.add(new Connection(fromArtifact, cls, scheme, pos, isDeprecated));
            } else {
                Position pos = firstIdent.getPosition();
                String name = firstIdent.getLexeme();
                ConnectionScheme scheme = this.m_currentContainer.resolveName(name, ConnectionScheme.class);
                if (scheme == null) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Unknown connection scheme '%s'", name), pos.getLine(), pos.getColumn()));
                    return;
                }
                if (arg.getChild("ALL") != null) {
                    assert (this.m_currentTemplate != null);
                    this.m_currentTemplate.setDefaultConnectionScheme(scheme);
                    String fromClass = scheme.getFromClassName();
                    String toClass = scheme.getToClassName();
                    Artifact templ = this.m_currentTemplate.getTemplateArtifact();
                    String clsName = templ.getClassName();
                    if (fromClass == null && clsName == null) {
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Connection scheme '%s' and template artifact must be class based", name), pos.getLine(), pos.getColumn()));
                    } else if (clsName == null) {
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("connect all using '%s' requires the use of class '%s' for the template artifact", name, fromClass), pos.getLine(), pos.getColumn()));
                    } else if (fromClass != null) {
                        if (!fromClass.equals(clsName)) {
                            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Connection scheme '%s' required artifacts of class '%s'", name, fromClass), pos.getLine(), pos.getColumn()));
                        } else if (!fromClass.equals(toClass)) {
                            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Target class '%s' of connection scheme '%s' does not match '%s'", toClass, name, fromClass), pos.getLine(), pos.getColumn()));
                        }
                    } else {
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Connection scheme '%s' must connect class '%s' with class '%s'", name, clsName, clsName), pos.getLine(), pos.getColumn()));
                    }
                    return;
                }
                arg.visitChildren((Visitor)this, new Node[0]);
                if (scheme.getFromClassName() != null) {
                    Artifact fromArtifact = (Artifact)this.m_currentContainer;
                    if (!scheme.getFromClassName().equals(fromArtifact.getClassName())) {
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Source artifact '%s' must be of class '%s'", fromArtifact.getShortName(), scheme.getFromClassName()), pos.getLine(), pos.getColumn()));
                    }
                }
                List targets = (List)arg.getChild("IdentList").getAttribute(VALUE);
                this.m_connections.add(new Connection((Artifact)this.m_currentContainer, targets, scheme, pos, isDeprecated));
            }
        } else {
            List toList;
            Identifier from;
            boolean transitively;
            arg.visitChildren((Visitor)this, new Node[0]);
            boolean bl2 = transitively = arg.getChild("TRANSITIVELY") != null;
            if (arg.getChild("Identifier") == null) {
                from = new Identifier(arg.getChildAt(0).getPosition(), DEFAULT);
                toList = (List)arg.getChild("IdentList").getAttribute(VALUE);
            } else {
                from = (Identifier)arg.getChildAt(1).getAttribute(VALUE);
                toList = (List)arg.getChild("IdentList").getAttribute(VALUE);
            }
            ConnectTo usesDecl = new ConnectTo((Artifact)this.m_currentContainer, from, toList, transitively, isDeprecated);
            this.m_connectToStatements.add(usesDecl);
        }
    }

    private void processConnection(Connection conn) {
        List<Object> targetArtifacts;
        assert (conn != null) : "Parameter 'conn' of method 'processConnection' must not be null";
        ConnectionScheme scheme = conn.getScheme();
        THashSet failedFroms = new THashSet();
        THashSet failedTos = new THashSet();
        ArtifactClass targetClass = conn.getToClass();
        boolean checkCycles = true;
        if (targetClass != null) {
            targetArtifacts = this.m_file.getChildrenRecursively(Artifact.class, new Class[0]).stream().filter(a -> a != conn.getContext() && targetClass.getShortName().equals(a.getClassName())).collect(Collectors.toList());
            checkCycles = false;
        } else {
            targetArtifacts = new ArrayList();
            for (Identifier identifier : conn.getTo()) {
                if (failedTos.contains(identifier)) continue;
                Artifact targetArtifact = this.resolveArtifactRecursively(conn.getContext(), identifier, conn.getPosition());
                if (targetArtifact == null) {
                    failedTos.add(identifier);
                    continue;
                }
                if (scheme.getToClassName() != null && !scheme.getToClassName().equals(targetArtifact.getClassName())) {
                    Position pos = identifier.getPosition();
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Connection target '%s' must be of class '%s'", targetArtifact.getName(), scheme.getToClassName()), pos.getLine(), pos.getColumn()));
                    continue;
                }
                targetArtifacts.add(targetArtifact);
            }
        }
        for (Artifact artifact : targetArtifacts) {
            THashSet failedTargets = new THashSet();
            for (ConnectionSchemeConnection connection : scheme.getConnections()) {
                if (failedFroms.contains(connection.getFrom())) continue;
                ArrayList<Connector> fromConnectors = new ArrayList<Connector>();
                if (connection.isAny()) {
                    for (Artifact anyArtifact : conn.getContext().getChildren(Artifact.class)) {
                        Connector fromConnector = this.resolveConnector(anyArtifact, connection.getFrom(), null, connection.getFrom());
                        if (fromConnector == null) continue;
                        fromConnectors.add(fromConnector);
                    }
                    if (fromConnectors.isEmpty()) {
                        Position pos = conn.getPosition();
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'any.%s' does not match any connector", connection.getFrom().toString()), pos.getLine(), pos.getColumn()));
                    }
                } else {
                    Connector fromConnector = this.resolveConnector(conn.getContext(), connection.getFrom(), conn.getPosition(), connection.getFrom());
                    if (fromConnector != null) {
                        fromConnectors.add(fromConnector);
                    } else {
                        failedFroms.add(connection.getFrom());
                    }
                }
                for (Connector fromConnector : fromConnectors) {
                    for (Identifier connectionTarget : connection.getTo()) {
                        if (failedTargets.contains(connectionTarget)) continue;
                        Identifier targetIdent = connectionTarget.shiftLeft();
                        ArrayList<Interface> targetInterfaces = new ArrayList<Interface>();
                        if (targetIdent.getIdent().equals(ID_ANY)) {
                            Identifier nested = targetIdent.shiftLeft();
                            for (Artifact anyArtifact : artifact.getChildren(Artifact.class)) {
                                Interface targetInterface;
                                if (!anyArtifact.isExposed() || (targetInterface = this.resolveInterfaceInContainer(anyArtifact, nested, null)) == null) continue;
                                targetInterfaces.add(targetInterface);
                            }
                            if (targetInterfaces.isEmpty()) {
                                Position pos = conn.getPosition();
                                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' does not match any exposed artifacts", targetIdent), pos.getLine(), pos.getColumn()));
                            }
                        } else {
                            Interface targetInterface = this.resolveInterfaceInContainer(artifact, targetIdent, conn.getPosition());
                            if (targetInterface != null) {
                                targetInterfaces.add(targetInterface);
                            } else {
                                failedTargets.add(connectionTarget);
                            }
                        }
                        for (Interface targetInterface : targetInterfaces) {
                            if (targetInterface.isRequired()) {
                                Position pos = conn.getPosition();
                                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("required interface '%s' cannot be used from connection-scheme", targetInterface.getName()), pos.getLine(), pos.getColumn()));
                            }
                            fromConnector.connectTo(targetInterface, checkCycles, conn.isDeprecated());
                        }
                    }
                }
            }
        }
    }

    private Connector resolveConnector(ArchitectureElement context, Identifier name, Position pos, Identifier originalIdent) {
        ArchitectureElement root = context.getFirstChild(c -> c.getShortName().equals(name.getIdent()), ArchitectureElement.class);
        if (root instanceof Artifact) {
            if (name.getQualifier() == null) {
                return root.getFirstChild(c -> c.getShortName().equals(DEFAULT), Connector.class);
            }
            return this.resolveConnector(root, name.shiftLeft(), pos, originalIdent);
        }
        if (root instanceof Connector) {
            if (name.getQualifier() != null) {
                if (pos == null) {
                    pos = name.getPosition();
                }
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s.%s' already is a connector", context.getShortName(), name.getIdent()), pos.getLine(), pos.getColumn()));
            }
            return (Connector)root;
        }
        if (pos != null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Name '%s.%s' cannot be resolved", context.getShortName(), name.getIdent()), pos.getLine(), pos.getColumn()));
        }
        return null;
    }

    private Interface resolveLocalInterface(IArchitectureElementContainer targetArtifact, Identifier target) {
        Artifact artifact;
        String name = target.getIdent();
        Interface targetInterface = null;
        if (name == null) {
            name = DEFAULT;
        }
        if ((targetInterface = targetArtifact.getArchitectureElement(name, Interface.class)) == null && (artifact = targetArtifact.getArchitectureElement(name, Artifact.class)) != null) {
            targetInterface = this.resolveInterfaceInContainer(artifact, target.shiftLeft(), null);
        }
        return targetInterface;
    }

    private Interface resolveInterfaceInContainer(IArchitectureElementContainer targetArtifact, Identifier target, Position pos) {
        String name = target.getIdent();
        Interface targetInterface = null;
        if (name == null) {
            name = DEFAULT;
        }
        if ((targetInterface = targetArtifact.getArchitectureElement(name, Interface.class)) == null) {
            Artifact exposedArtifact = targetArtifact.getArchitectureElement(name, Artifact.class);
            if (exposedArtifact == null || !exposedArtifact.isExposed()) {
                if (pos != null) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' is undefined or not an interface or exposed artifact of '%s'", name, targetArtifact.getName()), pos.getLine(), pos.getColumn()));
                }
            } else {
                targetInterface = this.resolveInterfaceInContainer(exposedArtifact, target.shiftLeft(), pos);
            }
        }
        return targetInterface;
    }

    private Connector resolveConnectorInArtifact(Artifact targetArtifact, Identifier target) {
        Artifact nestedArtifact;
        String name = target.getIdent();
        Connector targetConnector = null;
        if (name == null) {
            name = DEFAULT;
        }
        if ((targetConnector = targetArtifact.getArchitectureElement(name, Connector.class)) == null && (nestedArtifact = targetArtifact.getArchitectureElement(name, Artifact.class)) != null) {
            targetConnector = this.resolveConnectorInArtifact(nestedArtifact, target.shiftLeft());
        }
        return targetConnector;
    }

    private Artifact resolveArtifactRecursively(ArchitectureElement currentContainer, Identifier target, Position pos) {
        Artifact targetArtifact = this.resolveArtifact(currentContainer, target, pos);
        Identifier id = target.shiftLeft();
        Artifact nestedExposedArtifact = null;
        while (targetArtifact != null && id.getIdent() != null) {
            String nestedName = id.getIdent();
            nestedExposedArtifact = targetArtifact.getFirstChild(c -> c.getShortName().equals(nestedName), Artifact.class);
            if (nestedExposedArtifact == null) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' of '%s' is undefined", nestedName, target.toString()), pos.getLine(), pos.getColumn()));
                return null;
            }
            if (!nestedExposedArtifact.isExposed()) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' of '%s' must be an exposed artifact", nestedName, target.toString()), pos.getLine(), pos.getColumn()));
                return null;
            }
            targetArtifact = nestedExposedArtifact;
            id = id.shiftLeft();
        }
        return targetArtifact;
    }

    private Artifact resolveArtifact(ArchitectureElement currentContainer, Identifier target, Position pos) {
        Artifact targetArtifact = ((IArchitectureElementContainer)((Object)currentContainer.getParent())).resolveName(target.getIdent(), Artifact.class);
        if (targetArtifact == null) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("'%s' is not defined or not visible from the current context", target.getIdent()), pos.getLine(), pos.getColumn()));
            return null;
        }
        if (targetArtifact == currentContainer || currentContainer.hasAsParent(targetArtifact, false)) {
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Cannot reference '%s' from within itself", target.getIdent()), pos.getLine(), pos.getColumn()));
            return null;
        }
        return targetArtifact;
    }

    private Interface resolveInterface(ArchitectureElement currentContainer, Identifier target, Position pos) {
        assert (pos != null) : "Parameter 'pos' of method 'resolveInterface' must not be null";
        Artifact targetArtifact = this.resolveArtifact(currentContainer, target, pos);
        Interface targetInterface = null;
        if (targetArtifact != null) {
            targetInterface = this.resolveInterfaceInContainer(targetArtifact, target.shiftLeft(), pos);
        }
        return targetInterface;
    }

    private void processRequiredConnections() {
        for (RequiredConnection rc : this.m_requiredConnections) {
            this.processConnectTo(rc.getContext(), rc.getPosition(), rc.getConnector(), rc.getTarget(), rc.isTransitively(), rc.isDeprecated());
        }
        THashSet unrequiredCollector = this.m_file.isChecked() ? new THashSet() : null;
        for (Artifact artifact : this.m_file.getChildrenRecursively(Artifact.class, new Class[0])) {
            artifact.processRequiredReferences((Set<Artifact>)unrequiredCollector);
        }
        if (unrequiredCollector != null) {
            unrequiredCollector.forEach(a -> a.addIssue(new UnresolvedRequiredArtifactIssue((Artifact)a, "Unresolved required artifact '" + a.getName() + "'", a.getContextLineNumber())));
        }
    }

    private void processConnectTo(Artifact context, Position pos, Connector from, Identifier target, boolean transitively, boolean isDeprecated) {
        Interface targetInterface = this.resolveInterface(context, target, target.getPosition());
        if (targetInterface != null) {
            if (targetInterface.isRequired()) {
                RequiredConnection conn = new RequiredConnection(context, pos, from, target, transitively, isDeprecated);
                this.m_file.addRequiredConnection(conn);
                targetInterface.markAsReferenced();
            } else {
                from.connectTo(targetInterface, true, isDeprecated);
                if (transitively) {
                    Interface defaultInterface = context.getArchitectureElement(DEFAULT, Interface.class);
                    assert (defaultInterface != null);
                    if (!defaultInterface.isAutoDefined()) {
                        this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "'transitively' is without effect if the default interface is defined explicitly", pos.getLine(), pos.getColumn(), false));
                    } else {
                        defaultInterface.addExportedInterface(targetInterface);
                    }
                }
            }
        }
    }

    private void processConnectToStatement(Artifact context, Identifier from, List<Identifier> targets, boolean transitively, boolean isDeprecated) {
        Connector fromConnector = this.findConnector(context, from);
        if (fromConnector != null) {
            for (Identifier target : targets) {
                this.processConnectTo(context, from.getPosition(), fromConnector, target, transitively, isDeprecated);
            }
        }
    }

    private void processConnectToStatements() {
        for (ConnectTo decl : this.m_connectToStatements) {
            this.processConnectToStatement(decl.getContext(), decl.getFrom(), decl.getTo(), decl.isTransitively(), decl.isDeprecated());
        }
        this.processTransitiveConnections();
    }

    private void processTransitiveConnections() {
        for (TransitiveConnection conn : this.m_transitiveConnections) {
            Identifier ident = conn.getTarget();
            Interface iface = this.resolveInterface(conn.getArtifact(), ident, ident.getPosition());
            if (iface == null) continue;
            if (!conn.getArtifact().connectsTo(iface)) {
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Cannot export '%s' since it is not an outgoing connection of '%s'", ident.getQualifiedName(), conn.getArtifact().getName()), ident.getPosition().getLine(), ident.getPosition().getColumn()));
                continue;
            }
            conn.getSourceInterface().addExportedInterface(iface);
        }
    }

    @Override
    public void visitTemplateDecl(InnerNode arg) {
        Node idNode = arg.getChild("IDENT");
        String name = idNode.getLexeme();
        Position pos = idNode.getPosition();
        Node classNameNode = arg.getChild("IDENT", 1);
        if (this.checkArtifactName(name, pos, false)) {
            ArtifactClass cls = null;
            if (classNameNode != null) {
                cls = this.findClass(classNameNode);
            }
            ArtifactTemplate templ = new ArtifactTemplate(this.m_currentParent, name, this.m_file, pos.getLine(), cls != null ? cls.getShortName() : null);
            ArtifactTemplate parentTemplate = this.m_currentTemplate;
            this.m_currentParent.addChild(templ);
            this.m_currentTemplate = templ;
            this.visitChildren(arg, templ, new Node[0]);
            this.createDefaultInterfaceAndConnector(templ, pos);
            if (cls != null) {
                assert (classNameNode != null);
                for (String ifaceName : cls.getInterfaces()) {
                    Interface iface = new Interface(this.m_currentTemplate, ifaceName, this.m_file, classNameNode.getPosition().getLine(), true, true);
                    this.m_currentTemplate.addChild(iface);
                }
                for (String cName : cls.getConnectors()) {
                    Connector conn = new Connector(this.m_currentTemplate, cName, this.m_file, classNameNode.getPosition().getLine(), true, true);
                    this.m_currentTemplate.addChild(conn);
                }
            }
            this.m_currentTemplate = parentTemplate;
        }
    }

    @Override
    public void visitTemplateInclude(InnerNode arg) {
        IAssignableFilter filter = this.checkAndCreatePattern(arg, true);
        if (filter != null) {
            this.m_currentTemplate.addPattern(filter);
        }
    }

    @Override
    public void visitTemplateExclude(InnerNode arg) {
        IAssignableFilter filter = this.checkAndCreatePattern(arg, false);
        if (filter != null) {
            this.m_currentTemplate.addExcludePattern(filter);
        }
    }

    @Override
    public void visitTemplatePattern(InnerNode arg) {
        IAssignableFilter filter = this.createFilterFromStringNode(arg.getChildAt(1), false, false);
        int nameComponentCount = StringUtility.countChar((char)'(', (String)filter.getOriginalPattern());
        if (nameComponentCount == 0) {
            Position pos = arg.getChildAt(1).getPosition();
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Pattern for artifact templates must have parentheses for name capturing", pos.getLine(), pos.getColumn()));
        } else {
            this.m_currentTemplate.setPattern(filter);
        }
    }

    @Override
    public void visitTemplateConnect(InnerNode arg) {
        this.visitConnection(arg);
    }

    @Override
    public void visitTemplArtifact(InnerNode arg) {
        ArtifactClass cls;
        if (!this.m_currentTemplate.checkForPattern()) {
            Position pos = arg.getChildAt(0).getPosition();
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "When using attribute retrievers templates require a pattern section", pos.getLine(), pos.getColumn()));
        }
        Node classNameNode = arg.getChild("IDENT");
        Node nameExprNode = arg.getChild("NameExpr");
        nameExprNode.accept((Visitor)this);
        String className = this.m_currentTemplate.getClassName();
        if (classNameNode != null) {
            className = classNameNode.getLexeme();
        }
        Position pos = nameExprNode.getPosition();
        Artifact templateArtifact = new Artifact(this.m_currentTemplate, nameExprNode.getString(NAME), this.m_file, pos.getLine(), className);
        templateArtifact.setTemplateClass(this.m_currentTemplate.getShortName());
        this.visitChildren(arg, templateArtifact, nameExprNode);
        this.m_currentTemplate.setArtifactNameProgram(nameExprNode.getString(VALUE));
        this.m_currentTemplate.setTemplateArtifact(templateArtifact);
        this.createDefaultInterfaceAndConnector(templateArtifact, pos);
        if (className != null && (cls = this.findClass(className, classNameNode != null ? classNameNode.getPosition() : null)) != null) {
            if (!cls.getShortName().equals(this.m_currentTemplate.getClassName())) {
                Position cpos = nameExprNode.getPosition();
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Template artifact must have the same class as the template", cpos.getLine(), cpos.getColumn()));
            }
            this.checkClassInterface(cls, templateArtifact, pos);
        }
    }

    @Override
    public void visitNameExpr(InnerNode arg) {
        arg.visitChildren((Visitor)this, new Node[0]);
        Node first = arg.getChildAt(0);
        String leftValue = first.getString(VALUE);
        if (arg.size() == 1) {
            arg.setAttribute(VALUE, (Object)leftValue);
            arg.setAttribute(NAME, (Object)first.getString(NAME));
        } else {
            assert (arg.size() == 3);
            Node right = arg.getChildAt(2);
            String rightValue = right.getString(VALUE);
            arg.setAttribute(VALUE, (Object)(leftValue + rightValue + "+"));
            arg.setAttribute(NAME, (Object)(first.getString(NAME) + "+" + right.getString(NAME)));
        }
    }

    @Override
    public void visitNameItem(InnerNode arg) {
        block12: {
            Position pos;
            String lexeme;
            Node first;
            block13: {
                block11: {
                    first = arg.getChildAt(0);
                    lexeme = first.getLexeme();
                    pos = first.getPosition();
                    arg.visitChildren((Visitor)this, new Node[0]);
                    if (first.getType() != 3) break block11;
                    arg.setAttribute(VALUE, (Object)lexeme);
                    arg.setAttribute(NAME, (Object)lexeme);
                    break block12;
                }
                if (first.getType() != 5) break block13;
                int varIndex = lexeme.charAt(1) - 49;
                if (varIndex >= this.m_currentTemplate.getNameComponentCount()) {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Undefined variable: " + lexeme, pos.getLine(), pos.getColumn()));
                    arg.setAttribute(VALUE, (Object)"undefined");
                } else {
                    arg.setAttribute(VALUE, (Object)lexeme.substring(1));
                }
                arg.setAttribute(NAME, (Object)lexeme);
                break block12;
            }
            assert (first.getType() == 2);
            Node argument = arg.getChildAt(2);
            assert (argument != null);
            String argValue = argument.getString(VALUE);
            String name = argument.getString(NAME);
            switch (lexeme) {
                case "capitalize": {
                    arg.setAttribute(VALUE, (Object)(argValue + "c"));
                    break;
                }
                default: {
                    this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Unknown function: " + lexeme, pos.getLine(), pos.getColumn()));
                    arg.setAttribute(VALUE, (Object)argValue);
                }
            }
            arg.setAttribute(NAME, (Object)(lexeme + "(" + name + ")"));
        }
    }

    @Override
    public void visitModelSpec(InnerNode node) {
        assert (node != null) : "Parameter 'node' of method 'visitModelSpec' must not be null";
        Node nameNode = node.getChildAt(1);
        String modelName = nameNode.getLexeme().substring(1, nameNode.getLexeme().length() - 1);
        String modelNameLowercase = modelName.toLowerCase();
        try {
            IArchitecturalModelProvider.ArchitectureModel architectureModel = IArchitecturalModelProvider.ArchitectureModel.fromStandardName(modelNameLowercase);
            if (this.m_supportedModels.contains((Object)architectureModel)) {
                this.m_file.setModel(architectureModel);
            } else {
                Position pos = nameNode.getPosition();
                this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, "Cannot set model to '" + modelName + "'. Model not supported for: " + this.m_usedLanguages + ".", pos.getLine(), pos.getColumn(), false));
            }
        }
        catch (IllegalArgumentException e) {
            Position pos = nameNode.getPosition();
            this.m_file.addIssue(new ArchitectureFileIssue(this.m_file, String.format("Model must be either '%s' or '%s'", IArchitecturalModelProvider.ArchitectureModel.LOGICAL.getStandardName(), IArchitecturalModelProvider.ArchitectureModel.PHYSICAL.getStandardName()), pos.getLine(), pos.getColumn()));
        }
    }

    private class ConnectorProcessor
    extends DelayedProcessor {
        private final Connector m_connector;

        ConnectorProcessor(Connector conn, InnerNode node) {
            super(node);
            this.m_connector = conn;
        }

        @Override
        void process() {
            ArchitectureBuilder.this.m_currentConnector = this.m_connector;
            ArchitectureBuilder.this.visitChildren(this.m_node, this.m_connector, new Node[0]);
            ArchitectureBuilder.this.m_currentConnector = null;
        }
    }

    private abstract class DelayedProcessor {
        final InnerNode m_node;

        DelayedProcessor(InnerNode node) {
            this.m_node = node;
        }

        abstract void process();
    }

    private class InterfaceProcessor
    extends DelayedProcessor {
        private final Interface m_interface;

        InterfaceProcessor(Interface iface, InnerNode node) {
            super(node);
            this.m_interface = iface;
        }

        @Override
        void process() {
            ArchitectureBuilder.this.m_currentInterface = this.m_interface;
            ArchitectureBuilder.this.visitChildren(this.m_node, this.m_interface, new Node[0]);
            ArchitectureBuilder.this.m_currentInterface = null;
        }
    }
}

