/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.size;

import com.hello2morrow.sonargraph.core.controller.system.analysis.ISourceFileAddedOrChangedListener;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import java.util.List;

public final class SourceCodeMetricAnalyzer
extends ISourceLineProcessor.SourceLineVisitor
implements ISourceFileAddedOrChangedListener {
    private final ISourceLineProcessor m_sourceLineProcessor;
    private int m_linesOfCode;
    private int m_commentLines;
    private int m_codeCommentLines;

    public SourceCodeMetricAnalyzer(ISourceLineProcessor processor) {
        this.m_sourceLineProcessor = processor;
    }

    @Override
    public void processAddedOrChangedFile(SourceFile sourceFile, List<String> lines) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'processAddedOrChangedFile' must not be null";
        assert (lines != null) : "Parameter 'linesWithLineBreaks' of method 'processAddedOrChangedFile' must not be null";
        this.m_sourceLineProcessor.accept(lines, (ISourceLineProcessor.SourceLineVisitor)this);
        sourceFile.setTotalLines(lines.size());
        sourceFile.setLinesOfCode(this.m_linesOfCode);
        sourceFile.setCommentLines(this.m_commentLines);
        sourceFile.setCodeCommentLines(this.m_codeCommentLines);
        this.m_linesOfCode = 0;
        this.m_commentLines = 0;
        this.m_codeCommentLines = 0;
    }

    @Override
    public void visitEndOfLine() {
        ++this.m_linesOfCode;
    }

    @Override
    public void visitEndOfCodeCommentLine() {
        ++this.m_codeCommentLines;
    }

    @Override
    public void visitEndOfCommentLine() {
        ++this.m_commentLines;
    }
}

