/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class LogicalProgrammingElementDependencyEndpointCollector
extends DependencyEndpointCollector {
    private final Map<ProgrammingElement, LogicalProgrammingElement> m_programmingElementToLogicalTopLevelProgrammingElement = new THashMap();

    public void addLogicalProgrammingElements(Collection<? extends LogicalProgrammingElement> logicalProgrammingElements) {
        assert (logicalProgrammingElements != null) : "Parameter 'logicalProgrammingElements' of method 'addLogicalProgrammingElements' must not be null";
        for (LogicalProgrammingElement logicalProgrammingElement : logicalProgrammingElements) {
            for (ProgrammingElement programmingElement : logicalProgrammingElement.getProgrammingElements()) {
                this.m_programmingElementToLogicalTopLevelProgrammingElement.put(programmingElement, logicalProgrammingElement);
            }
            for (LogicalProgrammingElement logicalProgrammingElement2 : logicalProgrammingElement.getChildrenRecursively(LogicalProgrammingElement.class, new Class[0])) {
                for (ProgrammingElement programmingElement : logicalProgrammingElement2.getProgrammingElements()) {
                    this.m_programmingElementToLogicalTopLevelProgrammingElement.put(programmingElement, logicalProgrammingElement);
                }
            }
        }
    }

    public void reset() {
        this.m_programmingElementToLogicalTopLevelProgrammingElement.clear();
    }

    public Set<ProgrammingElement> getProgrammingElements(NamedElement forNamedElement) {
        assert (forNamedElement != null) : "Parameter 'forNamedElement' of method 'getProgrammingElements' must not be null";
        assert (forNamedElement != null && forNamedElement instanceof LogicalProgrammingElement) : "Unexpected class in method 'getProgrammingElements': " + String.valueOf(forNamedElement);
        THashSet result = new THashSet();
        LogicalProgrammingElement lpe = (LogicalProgrammingElement)forNamedElement;
        result.addAll(lpe.getProgrammingElements());
        for (LogicalProgrammingElement nextChild : lpe.getChildrenRecursively(LogicalProgrammingElement.class, new Class[0])) {
            result.addAll(nextChild.getProgrammingElements());
        }
        return result;
    }

    @Override
    public NamedElement getFirstCandidateForNodeAdapterLookUp(NamedElement element) {
        NamedElement parent;
        assert (element instanceof ProgrammingElement) : "Unexpected class: " + element.getClass().getName();
        while ((parent = element.getParent()) instanceof ProgrammingElement) {
            element = parent;
        }
        return this.m_programmingElementToLogicalTopLevelProgrammingElement.get(element);
    }

    @Override
    public final NamedElement getNextCandidateForNodeAdapterLookUp(NamedElement element) {
        return null;
    }
}

