/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.ComponentCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ComponentCyclesInSystemAnalyzer
extends CyclesAnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.COMPONENT_CYCLES_SYSTEM;
    private final IMetricDescriptor m_numberOfIncomingDependencies;
    private final IMetricDescriptor m_numberOfOutgoingDependencies;
    private final IMetricDescriptor m_instability;
    private final IMetricDescriptor m_componentRank;

    public ComponentCyclesInSystemAnalyzer(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_numberOfIncomingDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_INCOMING_DEPENDENCIES_SYSTEM, CoreMetricLevel.COMPONENT, null);
        this.m_numberOfOutgoingDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_OUTGOING_DEPENDENCIES_SYSTEM, CoreMetricLevel.COMPONENT, null);
        this.m_instability = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_INSTABILITY_SYSYTEM, CoreMetricLevel.COMPONENT, null);
        this.m_componentRank = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_COMPONENT_RANK_SYSTEM, CoreMetricLevel.COMPONENT, null);
    }

    @Override
    protected IIssueId getIssueId() {
        return ComponentCycleGroup.ISSUE_ID;
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        ComponentCyclesInSystemJob job = new ComponentCyclesInSystemJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class ComponentCyclesInSystemJob
    extends CyclesAnalyzerAdapter.CyclesAnalyzerJob {
        private ComponentCyclesInSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(ComponentCyclesInSystemAnalyzer.this, group, result, controller);
            this.setInstabilityMetric(ComponentCyclesInSystemAnalyzer.this.m_instability);
            this.setNumberOfIncomingDependenciesMetric(ComponentCyclesInSystemAnalyzer.this.m_numberOfIncomingDependencies);
            this.setNumberOfOutgoingDependenciesMetric(ComponentCyclesInSystemAnalyzer.this.m_numberOfOutgoingDependencies);
            this.setRankMetric(ComponentCyclesInSystemAnalyzer.this.m_componentRank);
        }

        protected Collection<NamedElement> getNamedElements() {
            IWorkerContext workerContext = this.getWorkerContext();
            ArrayList<NamedElement> internalCompilationUnits = new ArrayList<NamedElement>();
            for (Module nextModule : this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                for (IComponent nextComponent : nextModule.getChildrenRecursively(IComponent.class, ProgrammingElement.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return Collections.emptyList();
                    }
                    if (nextComponent.isExcluded()) continue;
                    internalCompilationUnits.add(nextComponent.getNamedElement());
                }
            }
            return internalCompilationUnits;
        }

        @Override
        protected AnalyzerCycleGroup createCycleGroup(boolean isCritical) {
            return new ComponentCycleGroup(null, this.getSoftwareSystem(), isCritical);
        }

        @Override
        protected boolean discardIfContainedInOneModule() {
            return true;
        }

        @Override
        protected List<IType> getTypes(NamedElement namedElement) {
            assert (namedElement != null && namedElement instanceof IComponent) : "Unexpected class in method 'getTypes': " + String.valueOf(namedElement);
            return namedElement.getChildrenRecursively(IType.class, new Class[0]);
        }
    }
}

