/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.complexity;

import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.function.Function;

public class WeightedAverageCalculator
implements IMetricAwareLanguageProvider.IWeightedAverageCalculator {
    @Override
    public final StrictPair<Number, Number> calculateWeightedAverage(IWorkerContext workerContext, NamedElement element, IMetricDescriptor md, Function<IRoutine, Integer> metricFunction, IMetricAwareLanguageProvider.IWeightedAverageCalculationConsumer consumer) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateWeightedAverage' must not be null";
        assert (element != null) : "Parameter 'element' of method 'calculateWeightedAverage' must not be null";
        assert (md != null) : "Parameter 'md' of method 'calculateWeightedAverage' must not be null";
        assert (metricFunction != null) : "Parameter 'metricFunction' of method 'calculateWeightedAverage' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'calculateWeightedAverage' must not be null";
        double totalValue = 0.0;
        double totalSize = 0.0;
        for (IRoutine routine : element.getChildrenRecursively(IRoutine.class, IRoutine.class)) {
            int nos;
            if (workerContext.hasBeenCanceled()) {
                return new StrictPair((Object)-1, (Object)-1);
            }
            if (routine.getNamedElement().getRefactoringState() == RefactoringState.DELETED || (nos = routine.getNumberOfStatements()) < 0) continue;
            int size = Math.max(nos, 1);
            int value = metricFunction.apply(routine);
            if (value < 0) continue;
            totalSize += (double)size;
            totalValue += (double)(size * metricFunction.apply(routine));
        }
        if (totalSize == 0.0) {
            return new StrictPair((Object)-1, (Object)-1);
        }
        double value = totalValue / totalSize;
        consumer.consume(element, value, md);
        consumer.addToSizeMap(element, totalSize);
        consumer.addToValueMap(element, value);
        return new StrictPair((Object)totalSize, (Object)totalValue);
    }

    @Override
    public void calculateWeightedAverageOnTypes(IWorkerContext workerContext, Module module, IMetricDescriptor md, Function<IRoutine, Integer> metricFunction, IMetricAwareLanguageProvider.IWeightedAverageCalculationConsumer consumer) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateWeightedAverageOnTypes' must not be null";
        assert (module != null) : "Parameter 'module' of method 'calculateWeightedAverageOnTypes' must not be null";
        assert (md != null) : "Parameter 'md' of method 'calculateWeightedAverageOnTypes' must not be null";
        assert (metricFunction != null) : "Parameter 'metricFunction' of method 'calculateWeightedAverageOnTypes' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'calculateWeightedAverageOnTypes' must not be null";
        for (IType nextType : module.getChildrenRecursively(IType.class, IType.class)) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            NamedElement type = (NamedElement)((Object)nextType);
            if (type.isExcluded()) continue;
            this.calculateWeightedAverage(workerContext, nextType.getNamedElement(), md, metricFunction, consumer);
        }
    }
}

