/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.base;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.IPluginMetricId;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerResultReader;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerResultWriter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.PluginContextAdapter;
import com.hello2morrow.sonargraph.core.controller.system.plugin.PluginCoreAccess;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.MetricDescriptor;
import com.hello2morrow.sonargraph.core.model.plugin.IPluginConfigurationProvider;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurations;
import com.hello2morrow.sonargraph.core.model.plugin.PluginElementIssue;
import com.hello2morrow.sonargraph.core.model.plugin.PluginExceptionIssue;
import com.hello2morrow.sonargraph.core.model.plugin.PluginIssueId;
import com.hello2morrow.sonargraph.core.model.plugin.PluginProviderId;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.plugin.IAnalyzerPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginAnalyzerAdapter
extends AnalyzerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginAnalyzerAdapter.class);
    private final PluginProviderId m_providerId;
    private final SonargraphPlugin m_plugin;
    private final IPluginAnalyzerContributor m_analyzerContributor;
    private final Collection<MetricDescriptor> m_pluginMetrics;

    public PluginAnalyzerAdapter(PluginProviderId providerId, SonargraphPlugin plugin, IPluginAnalyzerContributor analyzerContributor, IAnalyzerController controller, IConfigurableAnalyzerId analyzerId, Collection<MetricDescriptor> pluginMetrics) {
        super(controller, analyzerId);
        assert (providerId != null) : "Parameter 'providerId' of method 'PluginAnalyzerAdapter' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'PluginAnalyzerAdapter' must not be null";
        assert (analyzerContributor != null) : "Parameter 'analyzerContributor' of method 'PluginAnalyzerAdapter' must not be null";
        assert (pluginMetrics != null) : "Parameter 'pluginMetrics' of method 'PluginAnalyzerAdapter' must not be null";
        this.m_providerId = providerId;
        this.m_plugin = plugin;
        this.m_analyzerContributor = analyzerContributor;
        this.m_pluginMetrics = pluginMetrics;
    }

    @Override
    public boolean isEnabled() {
        return this.m_plugin.isEnabled();
    }

    private MetricDescriptor getMetricDescriptor(IPluginMetricId id, IMetricLevel level) {
        return this.m_pluginMetrics.stream().filter(md -> md.getLevel() == level && md.getMetricId() == id).findFirst().orElse(null);
    }

    @Override
    protected long getLastModifiedTimestamp() {
        long result = super.getLastModifiedTimestamp();
        PluginConfigurations configRoot = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getPluginConfigurationDirectory();
        PluginConfigurationFile config = configRoot.getFirstChild(e -> e.getShortName().equals(this.getAnalyzerId().getStandardName() + ".xml"), PluginConfigurationFile.class);
        if (config != null) {
            result = Long.max(result, config.getFile().lastModified());
        }
        return result;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        PluginAnalyzerAdapterJob job = new PluginAnalyzerAdapterJob(this.getGroup(), result, this.getController());
        job.start();
    }

    @Override
    protected AnalyzerResultWriter createWriter(AnalyzerResult result) {
        return new PluginResultWriter(result);
    }

    @Override
    protected AnalyzerResultReader createReader(AnalyzerResult result) {
        return new PluginResultReader(result);
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        IssueFilter filter = super.getIssueFilter(result);
        filter.add(this.m_providerId);
        return filter;
    }

    private final class PluginAnalyzerAdapterJob
    extends AnalyzerJob {
        PluginAnalyzerAdapterJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
        }

        @Override
        protected void internalRun() {
            block22: {
                PluginConfigurationFile pluginConfigurationFile;
                Set supportedLanguages;
                block24: {
                    supportedLanguages = PluginAnalyzerAdapter.this.m_plugin.getSupportedLanguages();
                    if (!PluginAnalyzerAdapter.this.m_plugin.isEnabled()) break block22;
                    if (supportedLanguages == null) break block24;
                    if (!this.getSoftwareSystem().getUsedLanguageStandardNames().stream().anyMatch(supportedLanguages::contains)) break block22;
                }
                if ((pluginConfigurationFile = this.getSoftwareSystem().getExtension(IPluginConfigurationProvider.class).getPluginConfigurationFile(PluginAnalyzerAdapter.this.m_plugin.getId())) != null) {
                    pluginConfigurationFile.removeIssues(CoreIssueId.PLUGIN_EXCEPTION);
                } else {
                    LOGGER.error("Unable to find configuration for '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "'");
                }
                try {
                    try {
                        ResultSet result = new ResultSet();
                        THashMap access = new THashMap();
                        access.put(IPluginCoreAccess.class, new PluginCoreAccess(PluginAnalyzerAdapter.this.getController().getInstallation(), PluginAnalyzerAdapter.this.getController().getSoftwareSystem(), true));
                        if (supportedLanguages != null) {
                            for (String nextLanguageName : supportedLanguages) {
                                Language nextLanguage = PluginAnalyzerAdapter.this.getController().getLanguageByName(nextLanguageName);
                                assert (nextLanguage != null) : "'nextLanguage' of method 'internalRun' must not be null";
                                PluginAnalyzerAdapter.this.getController().getLanguageProvider(nextLanguage).addPluginAccess(PluginAnalyzerAdapter.this.getController().getInstallation(), PluginAnalyzerAdapter.this.getController().getSoftwareSystem(), (Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess>)access);
                            }
                        }
                        LOGGER.debug("Execute analyzer plugin '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "'");
                        PluginAnalyzerAdapter.this.m_analyzerContributor.analyze((IAnalyzerPluginContext)new PluginContextAdapter(this.getWorkerContext(), (Map<Class<? extends IPluginCoreAccess>, IPluginCoreAccess>)access), result);
                        for (ResultSet.ElementIssue nextElementIssue : result.getElementIssues()) {
                            NamedElement element = (NamedElement)((ElementAccess)nextElementIssue.getNamedElementAccess()).getElement();
                            IPluginIssueId pluginIssueId = nextElementIssue.getPluginIssueId();
                            assert (pluginIssueId != null && pluginIssueId instanceof PluginIssueId) : "Unexpected class in method 'internalRun': " + String.valueOf(pluginIssueId);
                            PluginElementIssue nextPluginElementIssue = new PluginElementIssue((PluginIssueId)pluginIssueId, element, nextElementIssue.getMessageWithLines(), nextElementIssue.getStartLine());
                            element.addIssue(nextPluginElementIssue);
                        }
                        if (!result.getElementMetrics().isEmpty()) {
                            for (ResultSet.MetricValue metricValue : result.getElementMetrics()) {
                                IMetricLevel level = (IMetricLevel)((ElementAccess)metricValue.getElement()).getMetricLevel();
                                IPluginMetricId id = metricValue.getMetricId();
                                MetricDescriptor md = PluginAnalyzerAdapter.this.getMetricDescriptor(id, level);
                                if (md != null) {
                                    NamedElement element = (NamedElement)((ElementAccess)metricValue.getElement()).getElement();
                                    PluginAnalyzerAdapter.this.storeMetricValue(this.getResult(), element, metricValue.getValue(), md);
                                    continue;
                                }
                                LOGGER.error("Cannot find plugin metric descriptor for " + level.getPresentationName() + ": " + id.getName());
                            }
                        }
                    }
                    catch (IncompatibleClassChangeError icce) {
                        if (pluginConfigurationFile != null) {
                            pluginConfigurationFile.addIssue(new PluginExceptionIssue(pluginConfigurationFile, "The plugin is outdated, please install new version. " + ExceptionUtility.collectAll((Throwable)icce)));
                        } else {
                            LOGGER.error("Unable to add plugin exception issue. Plugin configuration file not found for '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "'", (Throwable)icce);
                        }
                        LOGGER.debug("Execute analyzer plugin '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "' - done");
                    }
                    catch (Throwable throwable) {
                        block23: {
                            if (pluginConfigurationFile != null) {
                                pluginConfigurationFile.addIssue(new PluginExceptionIssue(pluginConfigurationFile, ExceptionUtility.collectAll((Throwable)throwable)));
                                break block23;
                            }
                            LOGGER.error("Unable to add plugin exception issue. Plugin configuration file not found for '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "'", throwable);
                        }
                        LOGGER.debug("Execute analyzer plugin '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "' - done");
                    }
                }
                finally {
                    LOGGER.debug("Execute analyzer plugin '" + PluginAnalyzerAdapter.this.m_plugin.getId() + "' - done");
                }
            }
        }
    }

    private class PluginResultReader
    extends AnalyzerResultReader {
        private PluginResultReader(AnalyzerResult result) {
            super(result, PluginAnalyzerAdapter.this.getController());
        }

        @Override
        public <T> void readOther(String attributeName, Class<T> expectedClass, Consumer<T> consumer) throws RestoreException {
            if (IPluginIssueId.class.isAssignableFrom(expectedClass)) {
                String id = this.readString(attributeName);
                if (id == null) {
                    throw new RestoreException("Unexpected null value for plugin issue id");
                }
                IPluginIssueId resolvedId = (IPluginIssueId)PluginAnalyzerAdapter.this.getController().getInstallation().getFirstIssueId(issueId -> {
                    if (issueId instanceof IPluginIssueId) {
                        IPluginIssueId pid = (IPluginIssueId)issueId;
                        return pid.getId().equals(id) && pid.getPluginId().equals(PluginAnalyzerAdapter.this.m_plugin.getId());
                    }
                    return false;
                });
                if (resolvedId == null) {
                    throw new RestoreException(String.format("Cannot resolve issue id '%s' for plugin '%s'", id, PluginAnalyzerAdapter.this.m_plugin.getId()));
                }
                consumer.accept(resolvedId);
            } else {
                super.readOther(attributeName, expectedClass, consumer);
            }
        }
    }

    private class PluginResultWriter
    extends AnalyzerResultWriter {
        private PluginResultWriter(AnalyzerResult result) {
            super(result, PluginAnalyzerAdapter.this.getController());
        }

        @Override
        public void writeOther(String attributeName, Object obj) throws IOException {
            if (obj instanceof IPluginIssueId) {
                this.writeString(attributeName, ((IPluginIssueId)obj).getId());
            } else {
                super.writeOther(attributeName, obj);
            }
        }
    }
}

