/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.foundation.activity.CancellableWorkerContext;

abstract class WriteExecutor
implements Thread.UncaughtExceptionHandler {
    private CancellableWorkerContext m_workerContext;
    private volatile boolean m_running;

    protected WriteExecutor() {
    }

    protected void handleException(String context, Throwable throwable) {
        assert (context != null && context.length() > 0) : "Parameter 'context' of method 'handleException' must not be empty";
        assert (throwable != null) : "Parameter 'throwable' of method 'handleException' must not be null";
    }

    @Override
    public final void uncaughtException(Thread thread, Throwable throwable) {
        this.handleException("Exception caught in write execution: " + thread.getName(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shutdown() {
        boolean stopped = false;
        WriteExecutor writeExecutor = this;
        synchronized (writeExecutor) {
            while (true) {
                if (!this.m_running) {
                    return stopped;
                }
                assert (this.m_workerContext != null) : "'m_workerContext' of method 'shutdown' must not be null";
                stopped = true;
                this.m_workerContext.cancel();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.handleException("Unexpected thread interruption in WriteExecutor.shutdown()", ex);
                }
            }
        }
    }

    protected abstract void executionFinished();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute(CancellableWorkerContext workerContext, final String taskName, Runnable runnable) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'execute' must not be null";
        assert (taskName != null && taskName.length() > 0) : "Parameter 'taskName' of method 'execute' must not be empty";
        assert (runnable != null) : "Parameter 'runnable' of method 'execute' must not be null";
        this.shutdown();
        this.m_workerContext = workerContext;
        Thread thread = new Thread(runnable){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block14: {
                    try {
                        try {
                            super.run();
                        }
                        catch (Throwable throwable) {
                            WriteExecutor.this.handleException("Exception caught in write execution: " + taskName, throwable);
                            WriteExecutor writeExecutor = WriteExecutor.this;
                            synchronized (writeExecutor) {
                                WriteExecutor.this.m_running = false;
                                WriteExecutor.this.m_workerContext = null;
                                WriteExecutor.this.notifyAll();
                            }
                            WriteExecutor.this.executionFinished();
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        WriteExecutor writeExecutor = WriteExecutor.this;
                        synchronized (writeExecutor) {
                            WriteExecutor.this.m_running = false;
                            WriteExecutor.this.m_workerContext = null;
                            WriteExecutor.this.notifyAll();
                        }
                        WriteExecutor.this.executionFinished();
                        throw throwable;
                    }
                    WriteExecutor writeExecutor = WriteExecutor.this;
                    synchronized (writeExecutor) {
                        WriteExecutor.this.m_running = false;
                        WriteExecutor.this.m_workerContext = null;
                        WriteExecutor.this.notifyAll();
                    }
                    WriteExecutor.this.executionFinished();
                }
            }
        };
        WriteExecutor writeExecutor = this;
        synchronized (writeExecutor) {
            this.m_running = true;
            thread.setPriority(1);
            thread.setName(taskName);
            thread.setUncaughtExceptionHandler(this);
            thread.start();
        }
    }

    public final synchronized boolean cancel() {
        return this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void awaitCompletion() {
        WriteExecutor writeExecutor = this;
        synchronized (writeExecutor) {
            while (true) {
                if (!this.m_running) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.handleException("Unexpected thread interruption in WriteExecutor.awaitCompletion()", ex);
                }
            }
        }
    }
}

