/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IThresholdController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IThresholdExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.FloatThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValueContainer;
import com.hello2morrow.sonargraph.core.model.analysis.IntegerThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.MetricThreshold;
import com.hello2morrow.sonargraph.core.model.analysis.ThresholdAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThresholdExtension
extends Extension
implements IThresholdExtension,
IThresholdController,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThresholdExtension.class);
    private final Map<IMetricDescriptor, Set<ThresholdViolationIssue>> m_metricDescriptorToThresholdViolationIssues = new THashMap();
    private final Set<IAnalyzerId> m_calculateThresholdsForAnalyzers = new THashSet();
    private final SoftwareSystem m_softwareSystem;
    private final IMetricsProvider m_metricsProvider;
    private final IThresholdExtensionListener m_thresholdExtensionListener;
    private final IssueVisitor m_issueVisitor = new IssueVisitor();
    private ThresholdAnalyzerConfiguration m_configuration;

    public ThresholdExtension(SoftwareSystem system, IMetricsProvider metricsProvider, IThresholdExtensionListener thresholdExtensionListener, IFinishModelProcessor finishModelProcessor) {
        assert (system != null) : "Parameter 'system' of method 'ThresholdExtension' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'ThresholdExtension' must not be null";
        assert (thresholdExtensionListener != null) : "Parameter 'thresholdExtensionListener' of method 'ThresholdExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'ThresholdExtension' must not be null";
        this.m_softwareSystem = system;
        this.m_metricsProvider = metricsProvider;
        this.m_thresholdExtensionListener = thresholdExtensionListener;
        finishModelProcessor.addListener(this);
    }

    private boolean processThreshold(String key, String value, Set<IMetricThreshold> toBeAdded, OperationResult result) {
        assert (key != null) : "Parameter 'key' of method 'processThreshold' must not be null";
        assert (value != null) : "Parameter 'value' of method 'processThreshold' must not be null";
        assert (toBeAdded != null) : "Parameter 'toBeAdded' of method 'processThreshold' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processThreshold' must not be null";
        String[] keyParts = key.split(":");
        if (keyParts.length != 2) {
            result.addWarning((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Ignoring entry '%s'.", new Object[]{key});
            return false;
        }
        IMetricDescriptor md = this.m_metricsProvider.findMetricByIdAndLevel(keyParts[0], keyParts[1]);
        if (md == null) {
            result.addWarning((OperationResult.IMessageCause)MetricMessageCause.METRIC_NOT_FOUND, "Ignoring entry '%s.'", new Object[]{key});
            return false;
        }
        MetricThreshold threshold = md.isFloat() ? new FloatThreshold(null, md, value) : new IntegerThreshold(null, md, value);
        toBeAdded.add(threshold);
        return true;
    }

    @Override
    public void analyzerConfigurationChanged(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'loaded' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'analyzerConfigurationLoaded' must not be null";
        assert (result != null) : "Parameter 'result' of method 'analyzerConfigurationLoaded' must not be null";
        if (configuration instanceof ThresholdAnalyzerConfiguration) {
            Set<IMetricThreshold> modified = Collections.emptySet();
            THashSet removed = new THashSet();
            THashSet added = new THashSet();
            removed.addAll(this.getThresholds(false));
            ArrayList<String> invalidEntryKeys = new ArrayList<String>();
            for (Map.Entry<String, Object> nextEntry : configuration.getValueMap().entrySet()) {
                String nextValue;
                String nextKey = nextEntry.getKey();
                if (this.processThreshold(nextKey, nextValue = (String)nextEntry.getValue(), (Set<IMetricThreshold>)added, result)) continue;
                invalidEntryKeys.add(nextKey);
            }
            if (!invalidEntryKeys.isEmpty()) {
                for (String nextKey : invalidEntryKeys) {
                    configuration.removeValue(nextKey);
                }
            }
            if (!(!result.isSuccess() || removed.isEmpty() && added.isEmpty())) {
                this.updateThresholds((Collection<IMetricThreshold>)added, modified, (Collection<IMetricThreshold>)removed);
            }
        }
    }

    @Override
    public void analyzersReset(Set<IAnalyzerId> analyzerIds) {
        assert (analyzerIds != null) : "Parameter 'analyzerIds' of method 'analyzersReset' must not be null";
        if (analyzerIds.contains(CoreAnalyzerId.METRIC_THRESHOLDS)) {
            this.m_calculateThresholdsForAnalyzers.clear();
        } else {
            this.m_calculateThresholdsForAnalyzers.removeAll(analyzerIds);
        }
    }

    private void removeThresholdFor(IMetricDescriptor metric, List<IMetricThreshold> deletedThresholds) {
        assert (metric != null) : "Parameter 'metric' of method 'removeThresholdFor' must not be null";
        MetricThreshold metricThreshold = this.findThresholdFor(metric);
        assert (metricThreshold != null) : "'metricThreshold' of method 'removeThresholdFor' must not be null";
        metricThreshold.remove();
        this.m_configuration.removeValue(metricThreshold.getKey());
        deletedThresholds.add(metricThreshold);
    }

    private void defineThreshold(IMetricDescriptor metric, Number lower, Number upper, Severity severity) {
        assert (metric != null) : "Parameter 'metric' of method 'defineThreshold' must not be null";
        assert (lower != null) : "Parameter 'lower' of method 'defineThreshold' must not be null";
        assert (upper != null) : "Parameter 'upper' of method 'defineThreshold' must not be null";
        assert (this.findThresholdFor(metric) == null) : "'metricThreshold' of method 'defineThreshold' must be null";
        MetricThreshold metricThreshold = metric.isFloat() ? new FloatThreshold(this.m_configuration, metric, new BigDecimal(lower.doubleValue()), new BigDecimal(upper.doubleValue()), severity) : new IntegerThreshold(this.m_configuration, metric, lower.intValue(), upper.intValue(), severity);
        this.m_configuration.addChild(metricThreshold);
        this.m_configuration.setValue(metricThreshold.getKey(), metricThreshold.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThresholds(Collection<IMetricThreshold> added, Collection<IMetricThreshold> modified, Collection<IMetricThreshold> removed) {
        assert (added != null) : "Parameter 'added' of method 'updateThresholds' must not be null";
        assert (modified != null) : "Parameter 'modified' of method 'updateThresholds' must not be null";
        assert (removed != null) : "Parameter 'removed' of method 'updateThresholds' must not be null";
        if (this.m_softwareSystem.isClearable()) {
            AnalyzerExtension analyzerExtension = this.m_softwareSystem.getExtension(AnalyzerExtension.class);
            for (IAnalyzerId next : analyzerExtension.getCurrentlyAvailableAnalyzerIds()) {
                AnalyzerResult nextResult = analyzerExtension.getResultFor(next);
                if (nextResult == null || nextResult.getState() != AnalyzerState.FINISHED) continue;
                this.m_calculateThresholdsForAnalyzers.add(next);
            }
        }
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            VirtualModel currentModel = this.m_softwareSystem.getCurrentModel();
            for (IMetricDescriptor nextMetricDescriptor : new ArrayList<IMetricDescriptor>(this.m_metricDescriptorToThresholdViolationIssues.keySet())) {
                if (nextMetricDescriptor.getProvidingAnalyzerId() == CoreAnalyzerId.SCRIPT_RUNNER) continue;
                this.removeThresholdViolationsFor(currentModel, nextMetricDescriptor);
            }
            ArrayList<IMetricThreshold> deletedThresholds = new ArrayList<IMetricThreshold>();
            for (IMetricThreshold th : removed) {
                this.removeThresholdViolationsFor(currentModel, th.getMetricDescriptor());
                this.removeThresholdFor(th.getMetricDescriptor(), deletedThresholds);
            }
            for (IMetricThreshold th : modified) {
                this.removeThresholdViolationsFor(currentModel, th.getMetricDescriptor());
                this.removeThresholdFor(th.getMetricDescriptor(), deletedThresholds);
            }
            for (IMetricThreshold th : added) {
                this.defineThreshold(th.getMetricDescriptor(), th.getLowerThreshold(), th.getUpperThreshold(), th.getSeverity());
                removed.removeIf(r -> r.getKey().equals(th.getKey()));
            }
            for (IMetricThreshold th : modified) {
                this.defineThreshold(th.getMetricDescriptor(), th.getLowerThreshold(), th.getUpperThreshold(), th.getSeverity());
                removed.removeIf(r -> r.getKey().equals(th.getKey()));
            }
        }
        if (!removed.isEmpty()) {
            this.m_thresholdExtensionListener.thresholdsDeleted(new ArrayList<IMetricThreshold>(removed));
        }
    }

    @Override
    public OperationResult updateThresholds(IWorkerContext workerContext, Set<IMetricThreshold> added, Set<IMetricThreshold> modified, Set<IMetricThreshold> removed) {
        assert (added != null) : "Parameter 'added' of method 'updateThresholds' must not be null";
        assert (modified != null) : "Parameter 'modified' of method 'updateThresholds' must not be null";
        assert (removed != null) : "Parameter 'removed' of method 'updateThresholds' must not be null";
        assert (!(added.isEmpty() && modified.isEmpty() && removed.isEmpty())) : "No thresholds specified for method 'updateThresholds'";
        AnalyzerExtension analyzerExtension = this.m_softwareSystem.getExtension(AnalyzerExtension.class);
        THashSet analyzerToReset = new THashSet();
        analyzerToReset.add(AnalyzerGroup.THRESHOLDS);
        Set<AnalyzerGroup> toRestart = analyzerExtension.cancelAndResetAnalyzerGroups((Set<AnalyzerGroup>)analyzerToReset, ResetMode.ALL);
        OperationResult result = new OperationResult("Update Thresholds");
        this.updateThresholds(added, modified, removed);
        analyzerExtension.configurationChanged(workerContext, this.m_configuration, EnumSet.noneOf(Modification.class), result);
        analyzerExtension.runAnalyzerGroups(toRestart);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMetricThreshold> getThresholds(boolean includingScriptThresholds) {
        AnalyzerExtension analyzerExtension;
        AnalyzerResult result;
        ArrayList<IMetricThreshold> metricThresholds = new ArrayList<IMetricThreshold>();
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            metricThresholds.addAll(this.m_configuration.getChildren(IMetricThreshold.class));
        }
        if (includingScriptThresholds && (result = (analyzerExtension = this.m_softwareSystem.getExtension(AnalyzerExtension.class)).getAnalyzerResult(CoreAnalyzerId.SCRIPT_RUNNER, true)) != null) {
            assert (result.getState() == AnalyzerState.FINISHED) : "Analyzer not finished: " + String.valueOf(CoreAnalyzerId.SCRIPT_RUNNER);
            metricThresholds.addAll(result.getChildren(IMetricThreshold.class));
        }
        return metricThresholds;
    }

    @Override
    public IMetricThreshold getThreshold(IMetricDescriptor metric) {
        assert (metric != null) : "Parameter 'metric' of method 'getThreshold' must not be null";
        if (metric.getMetricId() instanceof IMetricThreshold) {
            IMetricThreshold scriptId = (IMetricThreshold)((Object)metric.getMetricId());
            if (scriptId.getLowerThreshold() == null || scriptId.getUpperThreshold() == null) {
                assert (scriptId.getLowerThreshold() == null && scriptId.getUpperThreshold() == null) : " If one threshold is null, the other must be null, too: " + String.valueOf(scriptId) + ", lower: " + String.valueOf(scriptId.getLowerThreshold()) + ", upper: " + String.valueOf(scriptId.getUpperThreshold());
                return null;
            }
            return scriptId;
        }
        for (IMetricThreshold threshold : this.getThresholds(false)) {
            if (threshold.getMetricDescriptor() != metric) continue;
            return threshold;
        }
        return null;
    }

    private MetricThreshold findThresholdFor(IMetricDescriptor metric) {
        assert (this.m_configuration != null) : "'m_configuration' of method 'findThresholdFor' must not be null";
        List<MetricThreshold> thresholds = this.m_configuration.getChildren(MetricThreshold.class);
        for (MetricThreshold threshold : thresholds) {
            if (threshold.getMetricDescriptor() != metric) continue;
            return threshold;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThresholdViolationIssue createThresholdViolation(IMetricThreshold threshold, NamedElement violator, Number value, IProviderId provider) {
        assert (threshold != null) : "Parameter 'threshold' of method 'createThresholdViolation' must not be null";
        assert (violator != null) : "Parameter 'violator' of method 'createThresholdViolation' must not be null";
        assert (value != null) : "Parameter 'value' of method 'createThresholdViolation' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'createThresholdViolation' must not be null";
        int lineNumber = violator.getLineNumber();
        IMetricDescriptor metricDescriptor = threshold.getMetricDescriptor();
        if (lineNumber == -1 && metricDescriptor.getLevel() == CoreMetricLevel.SOURCE_FILE) {
            lineNumber = 1;
        }
        ThresholdViolationIssue issue = new ThresholdViolationIssue(violator, provider, threshold, value, lineNumber);
        violator.addIssue(issue);
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            THashSet thresholdViolationIssues = this.m_metricDescriptorToThresholdViolationIssues.get(metricDescriptor);
            if (thresholdViolationIssues == null) {
                thresholdViolationIssues = new THashSet();
                this.m_metricDescriptorToThresholdViolationIssues.put(metricDescriptor, (Set<ThresholdViolationIssue>)thresholdViolationIssues);
            }
            thresholdViolationIssues.add((ThresholdViolationIssue)issue);
        }
        return issue;
    }

    private void removeThresholdViolationsFor(VirtualModel vm, IMetricDescriptor descriptor) {
        assert (vm != null) : "Parameter 'vm' of method 'removeThresholdViolationsFor' must not be null";
        assert (descriptor != null) : "Parameter 'descriptor' of method 'removeThresholdViolationsFor' must not be null";
        Set<ThresholdViolationIssue> thresholdViolationIssues = this.m_metricDescriptorToThresholdViolationIssues.remove(descriptor);
        if (thresholdViolationIssues != null) {
            for (ThresholdViolationIssue issue : thresholdViolationIssues) {
                if (!issue.isValid()) continue;
                vm.removeElementIssue(issue.getAffectedElement(), issue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<IMetricDescriptor, IMetricThreshold> getThresholdsFor(Collection<IMetricDescriptor> descriptors) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'getThresholdsFor' must not be null";
        THashMap result = new THashMap();
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            List<IMetricThreshold> thresholds = this.m_configuration.getChildren(IMetricThreshold.class);
            for (IMetricDescriptor descriptor : descriptors) {
                for (IMetricThreshold th : thresholds) {
                    if (!th.getMetricDescriptor().equals(descriptor)) continue;
                    result.put(descriptor, th);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeThresholdViolationsFor(Collection<IMetricDescriptor> descriptors) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'removeThresholdViolationsFor' must not be null";
        VirtualModel currentModel = this.m_softwareSystem.getCurrentModel();
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            for (IMetricDescriptor descriptor : descriptors) {
                this.removeThresholdViolationsFor(currentModel, descriptor);
            }
        }
    }

    @Override
    public void aboutToBeRemoved(Collection<IMetricDescriptor> descriptors) {
        assert (descriptors != null) : "Parameter 'descriptors' of method 'aboutToBeRemoved' must not be null";
        Map<IMetricDescriptor, IMetricThreshold> thresholds = this.getThresholdsFor(descriptors);
        if (!thresholds.isEmpty()) {
            this.updateThresholds(Collections.emptySet(), Collections.emptySet(), thresholds.values());
            this.m_softwareSystem.getExtension(AnalyzerExtension.class).configurationChanged(this.m_configuration);
        }
    }

    @Override
    public void checkValueOfAnalyzerBasedMetricValue(IMetricThreshold th, IMetricValue metricValue) {
        assert (th != null) : "Parameter 'th' of method 'checkValue' must not be null";
        assert (metricValue != null) : "Parameter 'metricValue' of method 'checkValue' must not be null";
        IAnalyzerId providingAnalyzerId = th.getMetricDescriptor().getProvidingAnalyzerId();
        assert (providingAnalyzerId != null) : "Not an analyzer-based metric value: " + th.getKey();
        Number value = metricValue.getValue();
        if (value != null && th.isViolatedBy(value) && !metricValue.getAssociatedElement().ignoreIssues()) {
            LOGGER.debug("Create threshold violation for analyzer-based metric value: " + th.getKey() + " (" + String.valueOf(providingAnalyzerId) + ")");
            IMetricDescriptor descr = metricValue.getMetricDescriptor();
            if (descr != null) {
                this.createThresholdViolation(th, metricValue.getAssociatedElement(), value, descr.getMetricId().getProvider());
            }
        }
    }

    private void checkValueOfNoneAnalyzerBasedMetricValue(IMetricThreshold th, IMetricValue metricValue) {
        assert (th != null) : "Parameter 'th' of method 'checkValue' must not be null";
        assert (metricValue != null) : "Parameter 'metricValue' of method 'checkValue' must not be null";
        assert (th.getMetricDescriptor().getProvidingAnalyzerId() == null) : "Not an non-analyzer-based metric value: " + th.getKey();
        Number value = metricValue.getValue();
        if (value != null && th.isViolatedBy(value) && !metricValue.getAssociatedElement().ignoreIssues()) {
            LOGGER.debug("Create threshold violation for non-analyzer-based metric value: " + th.getKey());
            this.createThresholdViolation(th, metricValue.getAssociatedElement(), value, metricValue.getMetricDescriptor().getMetricId().getProvider());
        }
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        this.m_configuration = this.m_softwareSystem.getUniqueExistingChild(Files.class).getAnalyzers().getAnalyzer(CoreAnalyzerId.METRIC_THRESHOLDS).getUniqueChild(ThresholdAnalyzerConfiguration.class);
        assert (this.m_configuration != null) : "'m_configuration' of method 'finishInitialization' must not be null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasThresholdViolations(IMetricDescriptor metricDescriptor, NamedElement element) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'hasUnresolvedThresholdViolations' must not be null";
        assert (element != null) : "Parameter 'element' of method 'hasUnresolvedThresholdViolations' must not be null";
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            Set<ThresholdViolationIssue> issues = this.m_metricDescriptorToThresholdViolationIssues.get(metricDescriptor);
            if (issues != null) {
                this.m_issueVisitor.init(metricDescriptor);
                this.m_softwareSystem.getCurrentModel().visitElementIssues(element, this.m_issueVisitor);
                boolean violation = this.m_issueVisitor.isViolation();
                this.m_issueVisitor.reset();
                return violation;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasUnresolvedThresholdViolations(IMetricDescriptor metricDescriptor) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'hasUnresolvedThresholdViolations' must not be null";
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            Set<ThresholdViolationIssue> thresholdViolationIssues = this.m_metricDescriptorToThresholdViolationIssues.get(metricDescriptor);
            if (thresholdViolationIssues != null) {
                for (ThresholdViolationIssue nextIssue : thresholdViolationIssues) {
                    if (nextIssue.getResolution() != null || !nextIssue.getAffectedElement().isValid()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamedElementIssue getThresholdViolationIssue(IMetricDescriptor metricDescriptor, NamedElement element) {
        assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'getThresholdViolation' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getThresholdViolation' must not be null";
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            Set<ThresholdViolationIssue> issues = this.m_metricDescriptorToThresholdViolationIssues.get(metricDescriptor);
            if (issues != null) {
                this.m_issueVisitor.init(metricDescriptor);
                this.m_softwareSystem.getCurrentModel().visitElementIssues(element, this.m_issueVisitor);
                ThresholdViolationIssue thresholdViolationIssue = this.m_issueVisitor.getThresholdViolationIssue();
                this.m_issueVisitor.reset();
                return thresholdViolationIssue;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScriptThresholdViolations() {
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            if (!this.m_metricDescriptorToThresholdViolationIssues.isEmpty()) {
                VirtualModel currentModel = this.m_softwareSystem.getCurrentModel();
                for (IMetricDescriptor nextMetricDescriptor : new ArrayList<IMetricDescriptor>(this.m_metricDescriptorToThresholdViolationIssues.keySet())) {
                    if (nextMetricDescriptor.getProvidingAnalyzerId() != CoreAnalyzerId.SCRIPT_RUNNER) continue;
                    this.removeThresholdViolationsFor(currentModel, nextMetricDescriptor);
                }
            }
        }
    }

    @Override
    public void checkPendingThresholds(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'checkPendingThresholds' must not be null";
        assert (this.m_configuration != null) : "'m_configuration' of method 'checkPendingThresholds' must not be null";
        try {
            LinkedHashMap<IMetricThreshold, IAnalyzerId> metricThresholds = new LinkedHashMap<IMetricThreshold, IAnalyzerId>();
            for (IMetricThreshold iMetricThreshold : this.m_configuration.getChildren(IMetricThreshold.class)) {
                IMetricDescriptor nextMetricDescriptor = iMetricThreshold.getMetricDescriptor();
                IAnalyzerId providingAnalyzerId = nextMetricDescriptor.getProvidingAnalyzerId();
                if (providingAnalyzerId != null && !this.m_calculateThresholdsForAnalyzers.contains(providingAnalyzerId)) continue;
                metricThresholds.put(iMetricThreshold, providingAnalyzerId);
            }
            if (!metricThresholds.isEmpty()) {
                workerContext.setNumberOfSteps(metricThresholds.size());
                for (Map.Entry entry : metricThresholds.entrySet()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.checkPendingThreshold((IMetricThreshold)entry.getKey(), (IAnalyzerId)entry.getValue());
                    workerContext.endStep();
                }
            }
        }
        finally {
            this.m_calculateThresholdsForAnalyzers.clear();
        }
    }

    @Override
    public void clearPendingThresholdViolations() {
        ArrayList<IMetricThreshold> metricThresholds = new ArrayList<IMetricThreshold>();
        for (IMetricThreshold nextMetricThreshold : this.m_configuration.getChildren(IMetricThreshold.class)) {
            IMetricDescriptor nextMetricDescriptor = nextMetricThreshold.getMetricDescriptor();
            IAnalyzerId providingAnalyzerId = nextMetricDescriptor.getProvidingAnalyzerId();
            if (providingAnalyzerId != null && !this.m_calculateThresholdsForAnalyzers.contains(providingAnalyzerId)) continue;
            metricThresholds.add(nextMetricThreshold);
        }
        if (!metricThresholds.isEmpty()) {
            this.removeThresholdViolationsFor(metricThresholds.stream().map(th -> th.getMetricDescriptor()).collect(Collectors.toList()));
        }
    }

    private void checkPendingThreshold(IMetricThreshold metricThreshold, IAnalyzerId providingAnalyzerId) {
        assert (metricThreshold != null) : "Parameter 'metricThreshold' of method 'checkPendingThreshold' must not be null";
        IMetricDescriptor metricDescriptor = metricThreshold.getMetricDescriptor();
        if (providingAnalyzerId == null) {
            assert (metricDescriptor instanceof IMetricValueContainer) : "Unexpected class in method 'checkPendingThreshold': " + String.valueOf(metricDescriptor);
            ((IMetricValueContainer)((Object)metricDescriptor)).processValues(this.m_softwareSystem, value -> this.checkValueOfNoneAnalyzerBasedMetricValue(metricThreshold, value));
        } else {
            IAnalyzerController analyzerExtension = this.m_softwareSystem.getExtension(AnalyzerExtension.class);
            AnalyzerResult result = analyzerExtension.getResultFor(providingAnalyzerId);
            assert (result != null) : "'result' of method 'checkPendingThreshold' must not be null";
            assert (result.getState() == AnalyzerState.FINISHED) : "Analyzer not finished: " + String.valueOf(providingAnalyzerId);
            for (IMetricValueContainer metricContainer : result.getChildren(IMetricValueContainer.class)) {
                if (metricContainer.getValueMetricDescriptor() != metricDescriptor) continue;
                metricContainer.processValues(this.m_softwareSystem, value -> this.checkValueOfAnalyzerBasedMetricValue(metricThreshold, value));
            }
            for (IMetricValue value2 : result.getChildren(IMetricValue.class)) {
                if (value2.getMetricDescriptor() != metricThreshold.getMetricDescriptor()) continue;
                this.checkValueOfAnalyzerBasedMetricValue(metricThreshold, value2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startModelSwitch(VirtualModel from, VirtualModel to) {
        assert (from != null) : "Parameter 'from' of method 'aboutToSwitchModel' must not be null";
        assert (to != null) : "Parameter 'to' of method 'aboutToSwitchModel' must not be null";
        assert (from != to) : "Model is the same";
        if (this.m_softwareSystem.isClearable()) {
            AnalyzerExtension analyzerExtension = this.m_softwareSystem.getExtension(AnalyzerExtension.class);
            for (IAnalyzerId next : analyzerExtension.getCurrentlyAvailableAnalyzerIds()) {
                AnalyzerResult nextResult = analyzerExtension.getResultFor(next);
                if (nextResult == null || nextResult.getState() != AnalyzerState.FINISHED) continue;
                this.m_calculateThresholdsForAnalyzers.add(next);
            }
        }
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            ArrayList<IMetricDescriptor> thresholdMetrics = new ArrayList<IMetricDescriptor>(this.m_metricDescriptorToThresholdViolationIssues.keySet());
            if (!thresholdMetrics.isEmpty()) {
                thresholdMetrics.forEach(m -> this.removeThresholdViolationsFor(from, (IMetricDescriptor)m));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToBeDisptached, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToBeDisptached != null) : "Parameter 'eventsToBeDisptached' of method 'cleared' must not be null";
        ThresholdAnalyzerConfiguration thresholdAnalyzerConfiguration = this.m_configuration;
        synchronized (thresholdAnalyzerConfiguration) {
            this.m_metricDescriptorToThresholdViolationIssues.clear();
        }
    }

    static interface IThresholdExtensionListener {
        public void thresholdsDeleted(List<IMetricThreshold> var1);
    }

    private static final class IssueVisitor
    implements IVirtualModel.IIssueVisitor {
        private IMetricDescriptor m_metricDescriptor;
        private ThresholdViolationIssue m_thresholdViolationIssue;

        private IssueVisitor() {
        }

        void init(IMetricDescriptor metricDescriptor) {
            assert (metricDescriptor != null) : "Parameter 'metricDescriptor' of method 'init' must not be null";
            this.m_metricDescriptor = metricDescriptor;
            this.m_thresholdViolationIssue = null;
        }

        @Override
        public boolean visit(Issue issue) {
            assert (issue != null) : "Parameter 'issue' of method 'visit' must not be null";
            if (issue instanceof ThresholdViolationIssue && ((ThresholdViolationIssue)issue).getThreshold().getMetricDescriptor() == this.m_metricDescriptor) {
                this.m_thresholdViolationIssue = (ThresholdViolationIssue)issue;
                return false;
            }
            return true;
        }

        boolean isViolation() {
            return this.m_thresholdViolationIssue != null;
        }

        ThresholdViolationIssue getThresholdViolationIssue() {
            return this.m_thresholdViolationIssue;
        }

        void reset() {
            this.m_metricDescriptor = null;
            this.m_thresholdViolationIssue = null;
        }
    }

    private static enum MetricMessageCause implements OperationResult.IMessageCause
    {
        METRIC_NOT_FOUND;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

