/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.api.IPluginCoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.AnalyzerExtension;
import com.hello2morrow.sonargraph.core.controller.system.DeltaDetection;
import com.hello2morrow.sonargraph.core.controller.system.IDeltaDetector;
import com.hello2morrow.sonargraph.core.controller.system.IFinishModelRefreshProcessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.PluginExtension;
import com.hello2morrow.sonargraph.core.controller.system.VirtualModelExtension;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controller.system.plugin.PluginAnalyzerId;
import com.hello2morrow.sonargraph.core.controller.system.plugin.PluginCoreAccess;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.filter.WorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemState;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshProcessor.class);
    private final IFinishModelRefreshProcessor m_finishModelProcessor;
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final LanguageProviderAccessor m_languageProviderAccessor;
    private final ISoftwareSystemProvider.BackgroundTaskExecutionMode m_backgroundTaskExecutionMode;

    RefreshProcessor(LanguageProviderAccessor languageProviderAccessor, IFinishModelRefreshProcessor finishModelProcessor, Installation installation, SoftwareSystem softwareSystem, ISoftwareSystemProvider.BackgroundTaskExecutionMode backgroundTaskExecutionMode) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'RefreshProcessor' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'RefreshProcessor' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'RefreshProcessor' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'RefreshProcessor' must not be null";
        assert (backgroundTaskExecutionMode != null) : "Parameter 'backgroundTaskExecutionMode' of method 'RefreshProcessor' must not be null";
        this.m_languageProviderAccessor = languageProviderAccessor;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_backgroundTaskExecutionMode = backgroundTaskExecutionMode;
    }

    private void prepareSystemFileRefresh(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'checkSystemFileModification' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'checkSystemFileModification' must not be null";
        SoftwareSystemFile softwareSystemFile = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        TFile file = softwareSystemFile.getFile();
        if (file.exists()) {
            if (softwareSystemFile.getTimestamp() != file.lastModified()) {
                if (softwareSystemFile.needsSave()) {
                    prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.MODIFIED_CONFLICT);
                } else {
                    prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.MODIFIED);
                }
            }
        } else if (softwareSystemFile.needsSave()) {
            prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.DELETED_CONFLICT);
        } else {
            prepareRefreshResult.setSoftwareSystemFileModification(PrepareRefreshResult.SoftwareSystemFileModification.DELETED);
        }
    }

    private void prepareParserRefresh(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'prepareRefresh' must not be null";
        if (this.m_softwareSystem.getUniqueExistingChild(Workspace.class).hasChildren(false, Module.class)) {
            boolean forceSilentFullReparse = false;
            for (LanguageProvider nextLanguageProvider : this.m_languageProviderAccessor.getLanguageProviders(prepareRefreshResult.getLanguages())) {
                if (!nextLanguageProvider.prepareRefresh(workerContext, this.m_softwareSystem, prepareRefreshResult)) continue;
                forceSilentFullReparse = true;
            }
            EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
            this.m_softwareSystem.getExtension(WorkspaceExtension.class).refreshWorkspaceDependencies(prepareRefreshResult, modifications);
            prepareRefreshResult.setIsSuccess(prepareRefreshResult.isParserRefreshPossible());
            boolean isSilent = false;
            if (!this.m_softwareSystem.needsReparse() && forceSilentFullReparse) {
                this.m_softwareSystem.setNeedsReparse(true);
                isSilent = true;
            }
            if (prepareRefreshResult.isSuccess() && this.m_softwareSystem.needsReparse() && this.m_softwareSystem.isClearable() && this.m_softwareSystem.getState() == SoftwareSystemState.MODEL_LOADED && !isSilent) {
                prepareRefreshResult.addInfo("A full reparse of the system is needed.");
            }
            this.m_finishModelProcessor.finishModification(this.m_softwareSystem, modifications);
        } else {
            prepareRefreshResult.addWarning(SoftwareSystemMessageCause.NO_MODULES_DEFINED, "Refresh not possible.", new Object[0]);
            prepareRefreshResult.setIsSuccess(false);
        }
    }

    PrepareRefreshResult prepareRefresh(IWorkerContext workerContext, Set<ISoftwareSystemProvider.IRefreshOption> options, Set<Language> limitTo) {
        Set<Language> languagesToUse;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareRefresh' must not be null";
        assert (options != null) : "Parameter 'options' of method 'prepareRefresh' must not be null";
        assert (limitTo != null) : "Parameter 'limitTo' of method 'prepareRefresh' must not be null";
        if (limitTo.isEmpty()) {
            languagesToUse = this.m_softwareSystem.getUsedLanguages();
        } else {
            for (Language nextLanguage : limitTo) {
                assert (this.m_softwareSystem.getUsedLanguages().contains(nextLanguage)) : "Language not used: " + String.valueOf(nextLanguage);
            }
            languagesToUse = limitTo;
        }
        PrepareRefreshResult prepareRefreshResult = new PrepareRefreshResult(languagesToUse, options);
        if (this.m_softwareSystem.getMode() == SoftwareSystemMode.SYSTEM) {
            this.prepareSystemFileRefresh(workerContext, prepareRefreshResult);
        }
        if (prepareRefreshResult.getSoftwareSystemFileModification() == PrepareRefreshResult.SoftwareSystemFileModification.NONE) {
            this.prepareAdditionalSystemFilesRefresh(workerContext, false, prepareRefreshResult);
        }
        if (options.contains(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL)) {
            this.prepareParserRefresh(workerContext, prepareRefreshResult);
        }
        return prepareRefreshResult;
    }

    private void clear(IWorkerContext workerContext, boolean onSystemRefresh, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clear' must not be null";
        assert (result != null) : "Parameter 'result' of method 'clear' must not be null";
        assert (this.m_softwareSystem.getMode() == SoftwareSystemMode.SYSTEM) : "'clearSoftwareSystem' is not possible in mode: " + String.valueOf((Object)this.m_softwareSystem.getMode());
        this.m_finishModelProcessor.performSoftwareSystemClear(workerContext, this.m_softwareSystem, onSystemRefresh, result, () -> {
            this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.clear(this.m_softwareSystem, onSystemRefresh));
            assert (!this.m_softwareSystem.getExtension(WorkspaceExtension.class).isClearable()) : "Still clearable";
            this.m_softwareSystem.setIsClearable(false);
            this.m_softwareSystem.setNeedsReparse(true);
            this.m_softwareSystem.setState(SoftwareSystemState.OPENED);
        });
        TrueZipFacade.clear();
        System.gc();
    }

    OperationResult clear(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'clear' must not be null";
        assert (this.m_softwareSystem.getState() == SoftwareSystemState.MODEL_LOADED) : "No model loaded for: " + String.valueOf(this.m_softwareSystem);
        OperationResult result = new OperationResult("Clear software system");
        this.m_softwareSystem.getExtension(ISnapshotController.class).cancelSaveSnapshot();
        this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        this.clear(workerContext, false, result);
        return result;
    }

    private ParserModelRefreshResult performParserModelRefresh(IWorkerContext workerContext, Set<ISoftwareSystemProvider.IRefreshOption> refreshOptions, List<ModuleDelta> moduleDeltas, IFilePathListener filePathListener, boolean notifyFinishSystemFilesRefresh, OperationResult result) {
        assert (this.m_softwareSystem.getMode() == SoftwareSystemMode.SYSTEM) : "'performParserModelRefresh' is not possible in mode: " + String.valueOf((Object)this.m_softwareSystem.getMode());
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performParserModelRefresh' must not be null";
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'performParserModelRefresh' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'performParserModelRefresh' must not be null";
        workerContext.beginSubTask("Refresh");
        VirtualModel resetTo = this.m_finishModelProcessor.aboutToPerformParserModelRefresh(workerContext, this.m_softwareSystem);
        LOGGER.debug("Perform refresh");
        long start = System.currentTimeMillis();
        boolean systemWillBeCleared = false;
        THashSet involvedLanguageProviders = new THashSet();
        for (ModuleDelta delta : moduleDeltas) {
            try {
                LanguageProvider lp = (LanguageProvider)delta.getLanguageProvider();
                if (!involvedLanguageProviders.add(lp)) continue;
                workerContext.working("Prepare refresh", false);
                lp.aboutToRefreshModules(workerContext, this.m_softwareSystem, result, refreshOptions, moduleDeltas, filePathListener);
            }
            catch (Throwable t) {
                systemWillBeCleared = true;
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, t);
                break;
            }
        }
        if (!systemWillBeCleared) {
            boolean delayedParsing;
            boolean bl = delayedParsing = involvedLanguageProviders.size() == 1 && ((LanguageProvider)involvedLanguageProviders.iterator().next()).delayedParsing();
            if (delayedParsing) {
                workerContext.setNumberOfSteps(3, new int[]{4, 96, 2});
                workerContext.beginSubTask("Initialize parsing");
            } else {
                workerContext.setNumberOfSteps(3, new int[]{96, 2, 2});
                workerContext.beginSubTask("Parsing");
            }
            int[] moduleWeights = new int[moduleDeltas.size()];
            int i = 0;
            while (i < moduleWeights.length) {
                moduleWeights[i] = moduleDeltas.get(i).getNumberOfAddedAndModifiedFiles() + 1;
                ++i;
            }
            workerContext.setNumberOfSteps(moduleWeights.length, moduleWeights);
            for (ModuleDelta delta : moduleDeltas) {
                try {
                    LanguageProvider lp = (LanguageProvider)delta.getLanguageProvider();
                    workerContext.beginSubTask(String.format(delayedParsing ? "Initializing module '%s'" : "Parsing module '%s'", delta.getModule().getShortName()));
                    delta.sortAddedFiles();
                    lp.refreshModule(workerContext, delta, filePathListener, result);
                    workerContext.endSubTask();
                    if (!workerContext.hasBeenCanceled() && !result.isFailure()) continue;
                    systemWillBeCleared = true;
                }
                catch (Throwable t) {
                    systemWillBeCleared = true;
                    result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, t);
                }
                break;
            }
        }
        workerContext.endSubTask();
        workerContext.beginSubTask("Finish refresh");
        for (LanguageProvider nextInvolvedLanguageProvider : involvedLanguageProviders) {
            try {
                if (nextInvolvedLanguageProvider.finishRefresh(workerContext, this.m_softwareSystem, result, systemWillBeCleared)) continue;
                systemWillBeCleared = true;
                break;
            }
            catch (Throwable t) {
                systemWillBeCleared = true;
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, t);
            }
        }
        workerContext.endSubTask();
        LOGGER.info("Perform refresh - done in {} ms", (Object)(System.currentTimeMillis() - start));
        workerContext.beginSubTask("Finish model modification");
        ParserModelRefreshResult res = this.finishParserModelRefresh(workerContext, filePathListener, notifyFinishSystemFilesRefresh, result, systemWillBeCleared, resetTo);
        workerContext.endSubTask();
        workerContext.endSubTask();
        return res;
    }

    private ParserModelRefreshResult finishParserModelRefresh(IWorkerContext workerContext, IFilePathListener filePathListener, boolean notifyFinishSystemFilesRefresh, OperationResult result, boolean systemWillBeCleared, VirtualModel resetTo) {
        ParserModelRefreshResult refreshResult;
        this.m_softwareSystem.setLastAppliedSnapshot(null);
        if (systemWillBeCleared) {
            this.clear(workerContext, true, result);
            if (filePathListener != null) {
                filePathListener.filesCleared(this.m_softwareSystem.getUsedLanguages());
            }
            refreshResult = ParserModelRefreshResult.CLEARED;
        } else {
            this.m_finishModelProcessor.parserModelRefreshPerformed(workerContext, this.m_softwareSystem, resetTo, result);
            this.m_softwareSystem.getExtension(WorkspaceExtension.class).refreshWorkspaceDependencies(null);
            this.m_softwareSystem.setIsClearable(this.m_softwareSystem.getExtension(WorkspaceExtension.class).isClearable());
            this.m_softwareSystem.setNeedsReparse(false);
            this.m_softwareSystem.setState(SoftwareSystemState.MODEL_LOADED);
            if (notifyFinishSystemFilesRefresh) {
                this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishSystemFilesRefresh(workerContext, this.m_softwareSystem, null));
            }
            this.m_finishModelProcessor.finishParserModelModification(workerContext, this.m_softwareSystem, filePathListener, result, false);
            refreshResult = ParserModelRefreshResult.REFRESHED;
            TrueZipFacade.clear();
            System.gc();
        }
        return refreshResult;
    }

    private boolean processVirtualModelModification(EnumSet<Modification> modifications, PrepareRefreshResult prepareRefreshResult, OperationResult result) {
        ModifiableModel currentModel;
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'processVirtualModelModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processVirtualModelModification' must not be null";
        boolean virtualModelChanged = false;
        if (prepareRefreshResult.switchModel()) {
            this.m_softwareSystem.getExtension(VirtualModelExtension.class).switchToModel(prepareRefreshResult.switchToModel(), result);
            if (modifications != null) {
                modifications.add(Modification.VIRTUAL_MODEL_CHANGED);
            }
            virtualModelChanged = true;
        } else if (prepareRefreshResult.getActiveVirtualModelModification() != PrepareRefreshResult.AdditionalFileModification.NONE && (currentModel = this.m_softwareSystem.getCurrentModel(ModifiableModel.class)) != null) {
            currentModel.setNeedsApplication();
            if (modifications != null) {
                modifications.add(Modification.VIRTUAL_MODEL_CHANGED);
            }
            virtualModelChanged = true;
        }
        return virtualModelChanged;
    }

    private boolean refresh(IWorkerContext workerContext, EnumSet<Modification> modifications, PrepareRefreshResult prepareRefreshResult, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        assert (prepareRefreshResult.isParserRefreshPossible()) : "'prepareRefreshResult' of method 'refresh': refresh not possible";
        assert (result != null) : "Parameter 'result' of method 'refresh' must not be null";
        Workspace workspace = this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        List<Module> modules = workspace.getChildren(Module.class);
        assert (modules != null && !modules.isEmpty()) : "'modules' of method 'refresh' must not be empty";
        THashSet involvedLps = new THashSet();
        for (Module nextModule : modules) {
            Language language = nextModule.getType().getLanguage();
            if (!prepareRefreshResult.isParserRefreshPossible(language)) continue;
            LanguageProvider lp2 = this.m_languageProviderAccessor.getLanguageProvider(language);
            involvedLps.add(lp2);
        }
        boolean refreshControlledByLanguageProvider = false;
        LanguageProvider languageProvider = null;
        if (involvedLps.stream().anyMatch(lp -> lp.controlsParserModelRefresh())) {
            languageProvider = involvedLps.stream().filter(lp -> lp.controlsParserModelRefresh()).findFirst().get();
            if (involvedLps.size() > 1) {
                result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_PERFORM_REFRESH, "Language " + languageProvider.getLanguage().getPresentationName() + " does not support multi-language systems.", new Object[0]);
            } else {
                refreshControlledByLanguageProvider = true;
            }
        }
        boolean cancelledSnapshot = this.m_softwareSystem.getExtension(ISnapshotController.class).cancelSaveSnapshot();
        if (this.m_softwareSystem.needsReparse() && this.m_softwareSystem.isClearable()) {
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
            this.clear(workerContext, true, result);
        } else {
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.CURRENTLY_RUNNING);
        }
        if (refreshControlledByLanguageProvider) {
            if (this.m_backgroundTaskExecutionMode == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
                workerContext.setNumberOfSteps(4, new int[]{3, 62, 10, 25});
            } else {
                workerContext.setNumberOfSteps(3, new int[]{3, 80, 17});
            }
            workerContext.beginSubTask("Initializing refresh");
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
            this.processVirtualModelModification(modifications, prepareRefreshResult, result);
            languageProvider.aboutToRefreshSystem(workerContext, this.m_softwareSystem, result);
            workerContext.endSubTask();
            if (result.isFailure()) {
                return false;
            }
            long start = System.currentTimeMillis();
            VirtualModel resetTo = this.m_finishModelProcessor.aboutToPerformParserModelRefresh(workerContext, this.m_softwareSystem);
            workerContext.beginSubTask("Perform refresh");
            boolean refreshed = languageProvider.refreshSystem(workerContext, this.m_softwareSystem, result);
            workerContext.endSubTask();
            LOGGER.info("Perform refresh - done in {} ms", (Object)(System.currentTimeMillis() - start));
            if (refreshed) {
                workerContext.beginSubTask("Finish model modification");
                this.finishParserModelRefresh(workerContext, null, true, result, false, resetTo);
                workerContext.endSubTask();
                if (this.m_backgroundTaskExecutionMode == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
                    workerContext.beginSubTask("Save snapshot and execute analyzers");
                    if (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                        this.m_softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
                    }
                    this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext);
                    workerContext.endSubTask();
                } else {
                    if (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                        this.m_softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
                    }
                    this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext);
                }
            }
            return refreshed;
        }
        if (this.m_backgroundTaskExecutionMode == ISoftwareSystemProvider.BackgroundTaskExecutionMode.WAIT_FOR_COMPLETION) {
            workerContext.setNumberOfSteps(3, new int[]{3, 72, 20});
        } else {
            workerContext.setNumberOfSteps(2, new int[]{3, 97});
        }
        return this.performDeltaRefresh(workerContext, workspace, modules, cancelledSnapshot, modifications, prepareRefreshResult, snapshotApplied, result);
    }

    private boolean performDeltaRefresh(IWorkerContext workerContext, Workspace workspace, List<Module> modules, boolean cancelledSnapshot, EnumSet<Modification> modifications, PrepareRefreshResult prepareRefreshResult, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'performDeltaRefresh' must not be null";
        assert (workspace != null) : "Parameter 'workspace' of method 'performDeltaRefresh' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'performDeltaRefresh' must not be empty";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'performDeltaRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'performDeltaRefresh' must not be null";
        workerContext.beginSubTask("Detect delta");
        LinkedHashMap<Module, IDeltaDetector> moduleToDeltaDetector = new LinkedHashMap<Module, IDeltaDetector>();
        WorkspaceFilter filter = workspace.getWorkspaceFilter();
        filter.initialize();
        for (Module nextModule : modules) {
            IDeltaDetector detector;
            Language language = nextModule.getType().getLanguage();
            if (!prepareRefreshResult.isParserRefreshPossible(language) || (detector = this.m_languageProviderAccessor.getLanguageProvider(language).createDeltaDetector(workerContext, filter, nextModule, prepareRefreshResult)) == null) continue;
            moduleToDeltaDetector.put(nextModule, detector);
        }
        if (prepareRefreshResult.isFailure()) {
            this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishSystemFilesRefresh(workerContext, this.m_softwareSystem, modifications));
            this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
            if (cancelledSnapshot && prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                this.m_softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
            }
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext, snapshotApplied);
            return false;
        }
        Map<String, List<String>> workspaceDependenciesBeforeRefresh = this.m_softwareSystem.getExtension(WorkspaceExtension.class).getWorkspaceDependencies();
        List<ModuleDelta> moduleDeltas = DeltaDetection.detectDelta(workerContext, moduleToDeltaDetector, result);
        if (result.isFailure() || moduleDeltas.isEmpty()) {
            if (!result.isFailure()) {
                this.m_softwareSystem.setState(SoftwareSystemState.MODEL_LOADED);
                this.m_softwareSystem.setNeedsReparse(false);
                boolean virtualModelChanged = this.processVirtualModelModification(modifications, prepareRefreshResult, result);
                Set<IAnalyzerId> analyzerIdsWithModifiedConfiguration = prepareRefreshResult.getAnalyzersNeedingExecution();
                if (virtualModelChanged) {
                    this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
                } else if (!analyzerIdsWithModifiedConfiguration.isEmpty()) {
                    this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAnalyzers(analyzerIdsWithModifiedConfiguration);
                }
            } else {
                this.m_softwareSystem.setNeedsReparse(true);
            }
            this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishSystemFilesRefresh(workerContext, this.m_softwareSystem, modifications));
            this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
            if (cancelledSnapshot && prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                this.m_softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
            }
            this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext, snapshotApplied);
            return false;
        }
        Map<String, List<String>> workspaceDependenciesAfterRefresh = this.m_softwareSystem.getExtension(WorkspaceExtension.class).getWorkspaceDependencies();
        if (!workspaceDependenciesBeforeRefresh.keySet().equals(workspaceDependenciesAfterRefresh.keySet())) {
            this.m_softwareSystem.setNeedsSave(true);
        } else {
            for (Map.Entry<String, List<String>> beforeEntry : workspaceDependenciesBeforeRefresh.entrySet()) {
                if (beforeEntry.getValue().equals(workspaceDependenciesAfterRefresh.get(beforeEntry.getKey()))) continue;
                this.m_softwareSystem.setNeedsSave(true);
                break;
            }
        }
        this.processVirtualModelModification(modifications, prepareRefreshResult, result);
        this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        workerContext.endSubTask();
        ParserModelRefreshResult refreshResult = this.performParserModelRefresh(workerContext, prepareRefreshResult.getRefreshOptions(), moduleDeltas, null, true, result);
        switch (refreshResult) {
            case CLEARED: {
                return false;
            }
            case REFRESHED: {
                if (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                    this.m_softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
                }
                this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext);
                return true;
            }
        }
        assert (false) : "Unhandled refresh result: " + String.valueOf((Object)refreshResult);
        return false;
    }

    void prepareAdditionalSystemFilesRefresh(IWorkerContext workerContext, boolean onSystemOpen, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'prepareAdditionalSystemFilesRefresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'prepareAdditionalSystemFilesRefresh' must not be null";
        workerContext.working("Synchronize system files", true);
        ModifiableFileDeltaDetector deltaDetector = new ModifiableFileDeltaDetector(workerContext, prepareRefreshResult, LanguageProvider.getIgnoreDirectories(), prepareRefreshResult.getSystemFilesDelta());
        for (IModifiableFileProvider next : this.m_softwareSystem.getExtensions(IModifiableFileProvider.class)) {
            next.prepareRefresh(deltaDetector, onSystemOpen, prepareRefreshResult);
        }
        for (SonargraphPlugin nextPlugin : this.m_installation.getExtension(PluginExtension.class).getPlugins()) {
            IPluginAnalyzerContributor nextAnalyzerContributor;
            if (!nextPlugin.isEnabled() || (nextAnalyzerContributor = nextPlugin.getAnalyzerContributor()) == null || !nextAnalyzerContributor.analyzerNeedsToRun((IPluginCoreAccess)new PluginCoreAccess(this.m_installation, this.m_softwareSystem, false))) continue;
            prepareRefreshResult.addAnalyzerNeedingExecution(new PluginAnalyzerId(nextPlugin));
            this.m_softwareSystem.getExtension(AnalyzerExtension.class).getAffectedAnalyzersOfPluginAnalyzers().forEach(a -> prepareRefreshResult.addAnalyzerNeedingExecution((IAnalyzerId)a));
        }
    }

    void processAdditionalSystemFilesPrepareRefreshResult(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processAdditionalSystemFilesPrepareRefreshResult' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processAdditionalSystemFilesPrepareRefreshResult' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'processAdditionalSystemFilesPrepareRefreshResult' must not be null";
        ModifiableFileDelta delta = prepareRefreshResult.getSystemFilesDelta();
        if (!delta.isEmpty()) {
            this.m_softwareSystem.getExtensions(IModifiableFileProvider.class).forEach(p -> p.refreshFiles(workerContext, delta, modifications, result));
        }
    }

    private void processSoftwareSystemFileModification(IWorkerContext workerContext, OperationResult result, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'processSoftwareSystemFileModification' must not be null";
        assert (result != null) : "Parameter 'result' of method 'processSoftwareSystemFileModification' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'processSoftwareSystemFileModification' must not be null";
        if (!prepareRefreshResult.ignoreSoftwareSystemFileModification() && prepareRefreshResult.getSoftwareSystemFileModification() != PrepareRefreshResult.SoftwareSystemFileModification.NONE) {
            this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile().setNeedsSave(true);
        }
    }

    private void processParserPrepareRefreshResult(IWorkerContext workerContext, OperationResult result, PrepareRefreshResult prepareRefreshResult) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        assert (result != null) : "Parameter 'result' of method 'process' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'process' must not be null";
        if (prepareRefreshResult.isElementDeletionNecessary()) {
            result.addMessagesFrom(this.m_softwareSystem.getExtension(WorkspaceExtension.class).delete(workerContext, prepareRefreshResult.getAboutToBeDeletedElements(), true));
        }
    }

    OperationResult refresh(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult) {
        assert (this.m_softwareSystem.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) : "'refresh' not possible in mode: " + String.valueOf((Object)this.m_softwareSystem.getMode());
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        OperationResult result = new OperationResult("Refresh");
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        prepareRefreshResult.getQuestions().forEach(q -> q.executePendingAction());
        this.processSoftwareSystemFileModification(workerContext, result, prepareRefreshResult);
        this.processAdditionalSystemFilesPrepareRefreshResult(workerContext, modifications, result, prepareRefreshResult);
        this.processParserPrepareRefreshResult(workerContext, result, prepareRefreshResult);
        if (result.isSuccess()) {
            this.m_finishModelProcessor.aboutToPerformRefresh(workerContext, this.m_softwareSystem);
            if (modifications.remove((Object)Modification.SYSTEM_NEEDS_REPARSE)) {
                this.m_softwareSystem.setNeedsReparse(true);
            }
            if (prepareRefreshResult.isParserRefreshPossible()) {
                assert (prepareRefreshResult.getRefreshOptions().contains(ISoftwareSystemProvider.RefreshOption.REFRESH_PARSER_MODEL)) : "The parser model is not to be refreshed";
                this.refresh(workerContext, modifications, prepareRefreshResult, false, result);
            } else if (prepareRefreshResult.getSoftwareSystemFileModification() != PrepareRefreshResult.SoftwareSystemFileModification.NONE && !prepareRefreshResult.ignoreSoftwareSystemFileModification() || !prepareRefreshResult.getSystemFilesDelta().isEmpty()) {
                this.processVirtualModelModification(modifications, prepareRefreshResult, result);
                this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
                this.m_languageProviderAccessor.getLanguageProviders(this.m_softwareSystem.getUsedLanguages()).forEach(lp -> lp.finishSystemFilesRefresh(workerContext, this.m_softwareSystem, modifications));
                this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
                this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext);
                if (this.m_softwareSystem.needsReparse()) {
                    result.addInfo((OperationResult.IMessageCause)SoftwareSystemMessageCause.SYSTEM_NEEDS_REPARSE);
                }
            }
        }
        return result;
    }

    OperationResult refresh(IWorkerContext workerContext, List<ModuleDelta> moduleDeltas, Set<ISoftwareSystemProvider.IRefreshOption> options, IFilePathListener listener) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshWithDelta' must not be null";
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'refreshWithDelta' must not be empty";
        assert (options != null) : "Parameter 'options' of method 'refreshWithDelta' must not be null";
        OperationResult result = new OperationResult("Refresh with delta");
        this.m_softwareSystem.getExtension(ISnapshotController.class).cancelSaveSnapshot();
        this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).cancelAndResetAllAnalyzers(ResetMode.ALL);
        this.m_finishModelProcessor.aboutToPerformRefresh(workerContext, this.m_softwareSystem);
        if (this.m_softwareSystem.needsReparse() && this.m_softwareSystem.isClearable()) {
            this.clear(workerContext, true, result);
        }
        ParserModelRefreshResult refreshResult = this.performParserModelRefresh(workerContext, options, moduleDeltas, listener, false, result);
        switch (refreshResult) {
            case CLEARED: {
                break;
            }
            case REFRESHED: {
                if (options.contains(ISoftwareSystemProvider.RefreshOption.WRITE_SNAPSHOT)) {
                    this.m_softwareSystem.getExtension(ISnapshotController.class).saveSnapshot();
                }
                this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class).runAutomatedAnalyzers(workerContext);
                break;
            }
            default: {
                assert (false) : "Unhandled refresh result: " + String.valueOf((Object)refreshResult);
                break;
            }
        }
        return result;
    }

    RefreshInfo refresh(IWorkerContext workerContext, PrepareRefreshResult prepareRefreshResult, boolean snapshotApplied, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refresh' must not be null";
        assert (prepareRefreshResult != null) : "Parameter 'prepareRefreshResult' of method 'refresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refresh' must not be null";
        this.m_finishModelProcessor.aboutToPerformRefresh(workerContext, this.m_softwareSystem);
        workerContext.working("Perform refresh", true);
        this.prepareParserRefresh(workerContext, prepareRefreshResult);
        this.processParserPrepareRefreshResult(workerContext, result, prepareRefreshResult);
        if (prepareRefreshResult.isParserRefreshPossible()) {
            boolean refreshed = this.refresh(workerContext, EnumSet.noneOf(Modification.class), prepareRefreshResult, snapshotApplied, result);
            return new RefreshInfo(false, refreshed);
        }
        return new RefreshInfo(true, false);
    }

    private static enum ParserModelRefreshResult {
        CLEARED,
        REFRESHED;

    }

    static final class RefreshInfo {
        private final boolean m_runAnalyzers;
        private final boolean m_refreshed;

        RefreshInfo(boolean runAnalyzers, boolean refreshed) {
            this.m_runAnalyzers = runAnalyzers;
            this.m_refreshed = refreshed;
        }

        boolean runAnalyzers() {
            return this.m_runAnalyzers;
        }

        boolean refreshed() {
            return this.m_refreshed;
        }
    }
}

