/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controllerinterface.system.IAuthorsExtension;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.annotation.Annotation;
import com.hello2morrow.sonargraph.core.model.annotation.AnnotationValue;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.ElementAssignmentInfo;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureProvider;
import com.hello2morrow.sonargraph.core.model.author.AuthorsInfo;
import com.hello2morrow.sonargraph.core.model.author.SourceFilesToAuthorsInfo;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.INamedElementAdapter;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.element.pattern.DependencyIssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.IssuePattern;
import com.hello2morrow.sonargraph.core.model.element.pattern.NamedElementIssuePattern;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingLink;
import com.hello2morrow.sonargraph.core.model.path.scm.TemporalCouplingModel;
import com.hello2morrow.sonargraph.core.model.programming.IParserDependenciesProvidingEdge;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalSystemProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.Matching;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.IAnalyzerProvider;
import com.hello2morrow.sonargraph.core.model.system.IPropertiesProvider;
import com.hello2morrow.sonargraph.core.model.system.NamespaceUtility;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesExtension
extends Extension
implements IPropertiesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesExtension.class);
    private static final String ISSUE_LABEL = "Issue";

    private String getResolutionInfo(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getResolutionInfo' must not be null";
        Resolution nextResolution = issue.getResolution(Resolution.class);
        if (nextResolution != null) {
            return StringUtility.concat((char)',', (String[])new String[]{nextResolution.ignores() ? "Ignored" : "Task", nextResolution.getAssignee(), nextResolution.getPriority() != Priority.NONE ? nextResolution.getPriority().getPresentationName() : "", nextResolution.getDescription()});
        }
        if (!issue.getId().isResolvable() || issue.previewOnly()) {
            return null;
        }
        return "No resolution";
    }

    private void addResolutionInfo(Element element, Set<Pair<String, String>> properties) {
        String resolutionInfo;
        assert (element != null) : "Parameter 'element' of method 'addResolutionInfo' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addResolutionInfo' must not be null";
        if (element instanceof Resolution) {
            Resolution resolution = (Resolution)element;
            for (IssuePattern nextPattern : resolution.getChildren(IssuePattern.class)) {
                if (nextPattern instanceof DependencyIssuePattern) {
                    properties.add((Pair<String, String>)new Pair((Object)"Dependency Pattern", (Object)nextPattern.getPresentationName(true)));
                    continue;
                }
                if (!(nextPattern instanceof NamedElementIssuePattern)) continue;
                properties.add((Pair<String, String>)new Pair((Object)"Element Pattern", (Object)nextPattern.getPresentationName(true)));
            }
            Matching matchingInfo = resolution.getUniqueChild(Matching.class);
            if (matchingInfo != null) {
                StringBuilder builder = new StringBuilder("Information from issue: ");
                builder.append(matchingInfo.getInformation());
                LinkedHashSet<String> elementFqNames = new LinkedHashSet<String>(matchingInfo.getElementFqNames());
                builder.append(" with ");
                builder.append(elementFqNames.size());
                builder.append(" pattern(s).");
                properties.add((Pair<String, String>)new Pair((Object)"Matching Information", (Object)builder.toString()));
                for (String next : elementFqNames) {
                    properties.add((Pair<String, String>)new Pair((Object)"Matching Information Pattern", (Object)next));
                }
            }
        } else if (element instanceof Issue && (resolutionInfo = this.getResolutionInfo((Issue)element)) != null) {
            properties.add((Pair<String, String>)new Pair((Object)"Resolution", (Object)resolutionInfo));
        }
    }

    private void addAuthorsInfo(Element element, Set<Pair<String, String>> properties) {
        SourceFile sourceFile;
        SoftwareSystem softwareSystem;
        assert (element != null) : "Parameter 'element' of method 'addAuthorsInfo' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addAuthorsInfo' must not be null";
        if (element instanceof SourceFile && (softwareSystem = (sourceFile = (SourceFile)element).getParent(SoftwareSystem.class, new Class[0])) != null) {
            IAuthorsExtension authorsExtension = softwareSystem.getExtension(IAuthorsExtension.class);
            SourceFilesToAuthorsInfo sourceFilesToAuthorsInfo = authorsExtension.getSourceFilesToAuthors();
            if (sourceFilesToAuthorsInfo == null) {
                return;
            }
            AuthorsInfo authorsInfo = sourceFilesToAuthorsInfo.getInfo().get(sourceFile);
            if (authorsInfo == null) {
                return;
            }
            properties.add((Pair<String, String>)new Pair((Object)"Authors 30 Days", (Object)AuthorsInfo.getAuthorsAsString(authorsInfo.getAuthors30())));
            properties.add((Pair<String, String>)new Pair((Object)"Authors 90 Days", (Object)AuthorsInfo.getAuthorsAsString(authorsInfo.getAuthors90())));
            properties.add((Pair<String, String>)new Pair((Object)"Authors 365 Days", (Object)AuthorsInfo.getAuthorsAsString(authorsInfo.getAuthors365())));
            properties.add((Pair<String, String>)new Pair((Object)"Authors 2 Years", (Object)AuthorsInfo.getAuthorsAsString(authorsInfo.getAuthors2y())));
            properties.add((Pair<String, String>)new Pair((Object)"Authors 5 Years", (Object)AuthorsInfo.getAuthorsAsString(authorsInfo.getAuthors5y())));
        }
    }

    private void addTemporalCouplingInfo(Element element, Set<Pair<String, String>> properties) {
        assert (element != null) : "Parameter 'element' of method 'addTemporalCouplingInfo' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addTemporalCouplingInfo' must not be null";
        if (element instanceof SourceFile) {
            SourceFile sourceFile = (SourceFile)element;
            SoftwareSystem softwareSystem = sourceFile.getParent(SoftwareSystem.class, new Class[0]);
            if (softwareSystem == null) {
                return;
            }
            IAnalyzerProvider analyzerExtension = softwareSystem.getExtension(IAnalyzerProvider.class);
            TemporalCouplingModel model = analyzerExtension.getTemporalCouplingModel(false);
            if (model == null) {
                return;
            }
            List<TemporalCouplingLink> links = model.getTemporalCouplingFor(sourceFile);
            if (links == null) {
                return;
            }
            int size = Math.min(5, links.size());
            if (size == 0) {
                return;
            }
            int i = 0;
            while (i < size) {
                properties.add((Pair<String, String>)new Pair((Object)("Temporal Coupling " + (i + 1)), (Object)links.get(i).toString()));
                ++i;
            }
        }
    }

    private void addProperty(Set<String> keys, Element element, Pair<String, String> property, Set<Pair<String, String>> properties) {
        assert (keys != null) : "Parameter 'keys' of method 'addProperty' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addProperty' must not be null";
        assert (property != null) : "Parameter 'property' of method 'addProperty' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addProperty' must not be null";
        if (!properties.contains(property)) {
            if (keys.add((String)property.getFirst())) {
                properties.add(property);
            } else if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Ignoring different property value for duplicate key: " + String.valueOf(property) + "\nElement: " + String.valueOf(element));
            }
        }
    }

    private void addProperties(Set<String> keys, Element element, Set<Pair<String, String>> properties) {
        assert (keys != null) : "Parameter 'keys' of method 'addProperties' must not be null";
        assert (element != null) : "Parameter 'propertiesOfElement' of method 'addProperties' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addProperties' must not be null";
        for (Map.Entry<String, Object> nextEntry : element.getProperties().entrySet()) {
            String nextKeyAsString = StringUtility.convertMixedCaseToHumanizedString((String)nextEntry.getKey());
            Object nextValue = nextEntry.getValue();
            if (nextValue instanceof List) {
                for (Object nextValueInList : (List)nextValue) {
                    if (nextValueInList != null) {
                        this.addProperty(keys, element, (Pair<String, String>)new Pair((Object)nextKeyAsString, (Object)nextValueInList.toString()), properties);
                        continue;
                    }
                    this.addProperty(keys, element, (Pair<String, String>)new Pair((Object)nextKeyAsString, (Object)"null"), properties);
                }
                continue;
            }
            if (nextValue instanceof Number) {
                this.addProperty(keys, element, (Pair<String, String>)new Pair((Object)nextKeyAsString, (Object)NumberUtility.format((Number)((Number)nextValue))), properties);
                continue;
            }
            this.addProperty(keys, element, (Pair<String, String>)new Pair((Object)nextKeyAsString, (Object)nextValue.toString()), properties);
        }
    }

    private void addArchitectureAssignments(Element element, Set<Pair<String, String>> properties) {
        ElementAssignmentInfo info;
        SoftwareSystem softwareSystem;
        assert (element != null) : "Parameter 'element' of method 'addArchitectureAssignments' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addArchitectureAssignments' must not be null";
        IAssignableToArtifact assignableToArtifact = null;
        if (element instanceof LogicalProgrammingElement) {
            LogicalProgrammingElement logicalModuleProgrammingElement = null;
            logicalModuleProgrammingElement = element instanceof LogicalSystemProgrammingElement ? NamespaceUtility.getLogicalProgrammingElement(((LogicalProgrammingElement)element).getPrimaryProgrammingElement(), false) : (LogicalProgrammingElement)element;
            if (logicalModuleProgrammingElement != null) {
                assignableToArtifact = logicalModuleProgrammingElement.getParent(LogicalProgrammingElement.class, ParentMode.TOPMOST_PARENT_OR_SELF);
            }
        } else if (element instanceof ProgrammingElement) {
            assignableToArtifact = ((ProgrammingElement)element).getParent(IAssignableToArtifact.class, ParentMode.FIRST_PARENT);
        } else if (element instanceof IAssignableToArtifact) {
            assignableToArtifact = (IAssignableToArtifact)((Object)element);
        }
        if (assignableToArtifact != null && (softwareSystem = assignableToArtifact.getNamedElement().getParent(SoftwareSystem.class, new Class[0])) != null && (info = softwareSystem.getExtension(IArchitectureProvider.class).getAssignmentInfo(assignableToArtifact.getNamedElement())) != null) {
            String domain = info.getModel().getDomain().isPhysical() ? " Physical" : " Logical";
            for (ArchitectureBaseElement next : info.getElements()) {
                properties.add((Pair<String, String>)new Pair((Object)("Architecture Assignment" + domain), (Object)info.getAssignedToInfo(next)));
            }
        }
    }

    private void addIssueInfo(IContext context, Element element, Set<Pair<String, String>> properties) {
        assert (context != null) : "Parameter 'context' of method 'addIssueInfo' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addIssueInfo' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'addIssueInfo' must not be null";
        if (element instanceof ElementWithIssues) {
            ElementWithIssues elementWithIssues = (ElementWithIssues)element;
            for (Issue nextIssue : context.collectIssues(elementWithIssues, false)) {
                String resolutionInfo = this.getResolutionInfo(nextIssue);
                String description = nextIssue.getDescription();
                if (description != null && description.isEmpty()) {
                    description = null;
                }
                properties.add((Pair<String, String>)new Pair((Object)ISSUE_LABEL, (Object)(nextIssue.getPresentationName(false) + (String)(description != null ? " - " + nextIssue.getDescription() : "") + (String)(resolutionInfo != null ? " (" + resolutionInfo + ") " : " "))));
            }
        }
    }

    private void addAnnotationInfo(Element element, Set<Pair<String, String>> properties) {
        block5: {
            Annotation annotation;
            block4: {
                assert (element != null) : "Parameter 'element' of method 'addAnnotationInfo' must not be null";
                assert (properties != null) : "Parameter 'properties' of method 'addAnnotationInfo' must not be null";
                if (!(element instanceof ProgrammingElement)) break block4;
                for (Annotation nextAnnotation : ((ProgrammingElement)element).getAnnotations()) {
                    properties.add((Pair<String, String>)new Pair((Object)"Annotation", (Object)nextAnnotation.toString()));
                }
                break block5;
            }
            if (!(element instanceof ParserDependency) || (annotation = ((ParserDependency)element).getAnnotation()) == null) break block5;
            for (Map.Entry<String, AnnotationValue> nextEntry : annotation.getKeyToAnnotationValue().entrySet()) {
                properties.add((Pair<String, String>)new Pair((Object)("Annotation value of '" + nextEntry.getKey() + "'"), (Object)nextEntry.getValue().toPresentationString()));
            }
        }
    }

    private final Collection<Element> getCollectFor(Element element) {
        SequencedCollection<Element> collectFor;
        assert (element != null) : "Parameter 'element' of method 'getProperties' must not be null";
        if (!element.isValid()) {
            return Collections.emptyList();
        }
        if (element instanceof IMetricValue) {
            NamedElement associatedElement = ((IMetricValue)((Object)element)).getAssociatedElement();
            if (associatedElement != null && associatedElement.isValid()) {
                NamedElement associatedRealElement = associatedElement.getElement();
                if (associatedRealElement != null && associatedRealElement != associatedElement && associatedRealElement.isValid()) {
                    collectFor = new ArrayList(2);
                    collectFor.add(associatedElement);
                    collectFor.add(associatedRealElement);
                } else {
                    collectFor = Collections.singletonList(associatedElement);
                }
            } else {
                collectFor = Collections.emptyList();
            }
        } else if (element instanceof INamedElementAdapter) {
            List<NamedElement> adaptedTo = ((INamedElementAdapter)((Object)element)).getAdaptedTo();
            collectFor = new LinkedHashSet(5);
            collectFor.add(element);
            for (NamedElement nextAdaptedTo : adaptedTo) {
                if (nextAdaptedTo == null || !nextAdaptedTo.isValid()) continue;
                collectFor.add(nextAdaptedTo);
                NamedElement nextAdaptedToRealElement = nextAdaptedTo.getElement();
                if (nextAdaptedToRealElement == null || nextAdaptedToRealElement == nextAdaptedTo || !((Element)nextAdaptedToRealElement).isValid()) continue;
                collectFor.add(nextAdaptedToRealElement);
            }
        } else if (element instanceof IParserDependenciesProvidingEdge) {
            IParserDependenciesProvidingEdge edge = (IParserDependenciesProvidingEdge)((Object)element);
            if (edge.getNumberOfParserDependencies() == 1 && edge.getFirstParserDependency() != null && edge.getFirstParserDependency().isValid()) {
                collectFor = new ArrayList(2);
                collectFor.add(element);
                collectFor.add(edge.getFirstParserDependency());
            } else {
                collectFor = Collections.singletonList(element);
            }
        } else {
            Element nextRealElement = element.getElement();
            if (nextRealElement != null && nextRealElement != element && nextRealElement.isValid()) {
                collectFor = new ArrayList(2);
                collectFor.add(element);
                collectFor.add(nextRealElement);
            } else {
                collectFor = Collections.singletonList(element);
            }
        }
        return collectFor;
    }

    @Override
    public List<Pair<String, String>> getProperties(IContext context, Element element) {
        assert (context != null) : "Parameter 'context' of method 'getProperties' must not be null";
        assert (element != null) : "Parameter 'element' of method 'getProperties' must not be null";
        THashSet properties = new THashSet();
        THashSet keys = new THashSet();
        for (Element nextElement : this.getCollectFor(element)) {
            this.addProperties((Set<String>)keys, nextElement, (Set<Pair<String, String>>)properties);
            this.addIssueInfo(context, nextElement, (Set<Pair<String, String>>)properties);
            this.addAnnotationInfo(nextElement, (Set<Pair<String, String>>)properties);
            this.addResolutionInfo(nextElement, (Set<Pair<String, String>>)properties);
            this.addArchitectureAssignments(nextElement, (Set<Pair<String, String>>)properties);
            this.addAuthorsInfo(nextElement, (Set<Pair<String, String>>)properties);
            this.addTemporalCouplingInfo(nextElement, (Set<Pair<String, String>>)properties);
        }
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> propertiesAsList = new ArrayList<Pair<String, String>>((Collection<Pair<String, String>>)properties);
        Collections.sort(propertiesAsList, new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> o1, Pair<String, String> o2) {
                if (!$assertionsDisabled && o1 == null) {
                    throw new AssertionError((Object)"Parameter 'o1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && o2 == null) {
                    throw new AssertionError((Object)"Parameter 'o2' of method 'compare' must not be null");
                }
                String name1 = (String)o1.getFirst();
                String name2 = (String)o2.getFirst();
                if (name1.equals(PropertiesExtension.ISSUE_LABEL) && name2.equals(PropertiesExtension.ISSUE_LABEL)) {
                    return ((String)o1.getSecond()).compareTo((String)o2.getSecond());
                }
                if (name1.equals(PropertiesExtension.ISSUE_LABEL) && !name2.equals(PropertiesExtension.ISSUE_LABEL)) {
                    return 1;
                }
                if (!name1.equals(PropertiesExtension.ISSUE_LABEL) && name2.equals(PropertiesExtension.ISSUE_LABEL)) {
                    return -1;
                }
                if (name1.startsWith("Authors") && name2.startsWith("Authors")) {
                    if (name1.endsWith("Years") && name2.endsWith("Days")) {
                        return 1;
                    }
                    if (name1.endsWith("Days") && name2.endsWith("Years")) {
                        return -1;
                    }
                    try {
                        int pos1 = name1.indexOf(32) + 1;
                        int pos2 = name1.lastIndexOf(32);
                        String n1 = name1.substring(pos1, pos2);
                        pos1 = name2.indexOf(32) + 1;
                        pos2 = name2.lastIndexOf(32);
                        String n2 = name2.substring(pos1, pos2);
                        return Integer.valueOf(n1) - Integer.valueOf(n2);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to retrieve number from author property names:" + name1 + "/" + name2);
                    }
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        return propertiesAsList;
    }
}

