/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.settings;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.NoInteraction;
import com.hello2morrow.sonargraph.core.command.system.settings.AbstractSearchPathCommand;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationConfigCause;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchPathEditPathCommand
extends AbstractSearchPathCommand<ICommandInteraction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchPathEditPathCommand.class);
    private final TFile m_newPath;
    private final TFile m_oldPath;

    public SearchPathEditPathCommand(ISoftwareSystemProvider provider, ISearchPathProviderManager searchPathProvider, SearchPathDelta delta, TFile oldPath, TFile newPath) {
        super(provider, NoInteraction.INSTANCE, searchPathProvider, delta, new OperationResult("Edit directory of search path"));
        assert (oldPath != null) : "Parameter 'oldPath' of method 'SearchPathEditPathCommand' must not be null";
        assert (newPath != null) : "Parameter 'newPath' of method 'SearchPathEditPathCommand' must not be null";
        this.m_oldPath = oldPath;
        this.m_newPath = newPath;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SEARCH_PATH_EDIT;
    }

    @Override
    public void internalRun(IWorkerContext workerContext) {
        if (this.m_oldPath.equals((Object)this.m_newPath)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Paths did not change - nothing to be done.");
            }
            return;
        }
        this.checkIfPathExists(this.m_newPath);
        this.checkIfPathCanBeAdded(this.m_newPath, this.getResult());
        if (this.getDelta().getNewMap().containsKey(this.m_newPath)) {
            this.getResult().addError((OperationResult.IMessageCause)InstallationConfigCause.SEARCH_PATH_DIR_DUPLICATED, "Specified directory '" + this.m_newPath.getAbsolutePath() + "' already exists in search path.", new Object[0]);
            return;
        }
        this.getDelta().replace(this.m_oldPath, this.m_newPath);
        if (!this.getResult().isSuccess()) {
            return;
        }
        this.getProvider().readPathToDelta(this.getDelta(), this.m_newPath, this.getResult());
    }
}

