/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.settings;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.NoInteraction;
import com.hello2morrow.sonargraph.core.command.system.settings.AbstractSearchPathCommand;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchPathAddPathCommand
extends AbstractSearchPathCommand<ICommandInteraction> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchPathAddPathCommand.class);
    private final TFile m_newPath;

    public SearchPathAddPathCommand(ISoftwareSystemProvider provider, ISearchPathProviderManager searchPathProvider, SearchPathDelta delta, TFile newPath) {
        super(provider, NoInteraction.INSTANCE, searchPathProvider, delta, new OperationResult("Adding directory to search path"));
        assert (newPath != null) : "Parameter 'newPath' of method 'SearchPathAddPathCommand' must not be null";
        this.m_newPath = newPath;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SEARCH_PATH_ADD;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        LOGGER.debug("Adding search path");
        this.checkIfPathExists(this.m_newPath);
        this.checkIfPathCanBeAdded(this.m_newPath, this.getResult());
        if (!this.getResult().isSuccess()) {
            return;
        }
        this.getProvider().readPathToDelta(this.getDelta(), this.m_newPath, this.getResult());
    }
}

