/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.script;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import de.schlichtherle.truezip.file.TFile;

public final class GroovyScriptSaveAsCommand
extends SonargraphCommand {
    private final IInteraction m_interaction;

    public static ITextValidator getNameValidator(ISoftwareSystemProvider provider, DirectoryPath parentDirectoryPath) {
        return provider.getSoftwareSystem().getExtension(IGroovyExtension.class).getScriptNameValidator(parentDirectoryPath);
    }

    public static IPathValidator getPathValidator(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getPathValidator' must not be null";
        IGroovyExtension extension = provider.getSoftwareSystem().getExtension(IGroovyExtension.class);
        return extension.getDirectoryPathValidator();
    }

    public GroovyScriptSaveAsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'SaveGroovyScriptAsCommand' must not be null";
        this.m_interaction = interaction;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SAVE_GROOVY_SCRIPT_AS;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (false) : "Not yet implemented - see SGNG-1014";
        SaveAsGroovyScriptData saveAsGroovyScriptData = new SaveAsGroovyScriptData();
        if (!this.m_interaction.collect(saveAsGroovyScriptData)) {
            return;
        }
        IGroovyExtension extension = this.getController().getSoftwareSystem().getExtension(IGroovyExtension.class);
        OperationResultWithOutcome<GroovyScript> result = extension.saveScriptAs(saveAsGroovyScriptData.getOriginalScript(), saveAsGroovyScriptData.getModifiedName(), saveAsGroovyScriptData.getDirectory(), saveAsGroovyScriptData.getModifiedDescription());
        this.m_interaction.processSaveAsResult(result);
    }

    @Override
    public Result isEnabled() {
        Result result = new Result();
        if (!this.getController().hasSoftwareSystem()) {
            result.addErrorMessage("No system avaliable");
            return result;
        }
        return result;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(SaveAsGroovyScriptData var1);

        public void processSaveAsResult(OperationResultWithOutcome<GroovyScript> var1);
    }

    public static final class SaveAsGroovyScriptData
    implements ICommandInteractionData {
        private GroovyScript m_originalScript;
        private String m_modifiedName;
        private String m_modifiedDescription = "";
        private TFile m_directory;

        public GroovyScript getOriginalScript() {
            return this.m_originalScript;
        }

        public void setOriginalScript(GroovyScript originalScript) {
            this.m_originalScript = originalScript;
        }

        public String getModifiedName() {
            return this.m_modifiedName;
        }

        public void setModifiedName(String modifiedName) {
            this.m_modifiedName = modifiedName;
        }

        public String getModifiedDescription() {
            return this.m_modifiedDescription;
        }

        public void setModifiedDescription(String modifiedDescription) {
            this.m_modifiedDescription = modifiedDescription;
        }

        public TFile getDirectory() {
            assert (this.m_directory != null) : "'m_baseDirectory' of method 'getDirectory' must not be null";
            return this.m_directory;
        }

        public void setDirectory(TFile directory) {
            assert (directory != null) : "Parameter 'directory' of method 'setDirectory' must not be null";
            this.m_directory = directory;
        }
    }
}

