/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.qualitygate;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateConditionInfo;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public final class CreateQualityGateConditionCommand
extends SoftwareSystemBasedCommand<ICreateConditionInteraction> {
    public CreateQualityGateConditionCommand(ISoftwareSystemProvider provider, ICreateConditionInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_QUALITY_GATE_CONDITION;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (((ICreateConditionInteraction)this.getInteraction()).collect(data)) {
            IQualityGateExtension extension = this.getController().getSoftwareSystem().getExtension(IQualityGateExtension.class);
            OperationResultWithOutcome<IQualityGateCondition> result = extension.createCondition(workerContext, data.getQualityGate(), data.getParent(), data.getConditionInfo());
            ((ICreateConditionInteraction)this.getInteraction()).processResult(result);
        }
    }

    public static interface ICreateConditionInteraction
    extends ICommandInteraction {
        public boolean collect(InteractionData var1);

        public void processResult(OperationResultWithOutcome<IQualityGateCondition> var1);
    }

    public static final class InteractionData
    implements ICommandInteractionData {
        private QualityGate m_qualityGate;
        private NamedElement m_parent;
        private IQualityGateConditionInfo m_conditionInfo;

        public QualityGate getQualityGate() {
            return this.m_qualityGate;
        }

        public void setQualityGate(QualityGate qualityGate) {
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'setQualityGate' must not be null";
            this.m_qualityGate = qualityGate;
        }

        public void setParent(NamedElement parent) {
            assert (parent != null) : "Parameter 'parent' of method 'setParent' must not be null";
            this.m_parent = parent;
        }

        public NamedElement getParent() {
            return this.m_parent;
        }

        public IQualityGateConditionInfo getConditionInfo() {
            return this.m_conditionInfo;
        }

        public void setConditionInfo(IQualityGateConditionInfo conditionInfo) {
            assert (conditionInfo != null) : "Parameter 'conditionInfo' of method 'setConditionInfo' must not be null";
            this.m_conditionInfo = conditionInfo;
        }
    }
}

