/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.MovableTargetInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public final class MoveElementsCommand
extends ArchitecturalViewCommand<IMoveElementsInteraction> {
    public MoveElementsCommand(ISoftwareSystemProvider provider, IMoveElementsInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.MOVE_ARCHITECTURAL_VIEW_ELEMENTS;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        MoveElementsData data = new MoveElementsData();
        if (!((IMoveElementsInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.moveElements(workerContext, data.getElements(), data.getTargetInfo());
        ((IMoveElementsInteraction)this.getInteraction()).processMoveElementsResult(result);
    }

    public static interface IMoveElementsInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(MoveElementsData var1);

        public void processMoveElementsResult(OperationResult var1);
    }

    public static final class MoveElementsData
    implements IArchitecturalViewCommandInteractionData {
        private List<? extends ArchitecturalViewElement> m_elements;
        private MovableTargetInfo m_targetInfo;

        MoveElementsData() {
        }

        public final void set(List<? extends ArchitecturalViewElement> elements, MovableTargetInfo targetInfo) {
            assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'set' must not be empty";
            assert (targetInfo != null) : "Parameter 'targetInfo' of method 'set' must not be null";
            this.m_elements = new ArrayList<ArchitecturalViewElement>(elements);
            this.m_targetInfo = targetInfo;
        }

        List<? extends ArchitecturalViewElement> getElements() {
            assert (this.m_elements != null && !this.m_elements.isEmpty()) : "'m_elements' of method 'getElements' must not be empty";
            return this.m_elements;
        }

        MovableTargetInfo getTargetInfo() {
            assert (this.m_targetInfo != null) : "'m_targetInfo' of method 'getTargetInfo' must not be null";
            return this.m_targetInfo;
        }
    }
}

