/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ExpandCollapseData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IExpandCollapseInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class ExpandToAssignableToArtifactsCommand
extends ArchitecturalViewCommand<IExpandCollapseInteraction> {
    private final String m_presentationName;

    public ExpandToAssignableToArtifactsCommand(ISoftwareSystemProvider provider, IExpandCollapseInteraction interaction, String presentationName) {
        super(provider, interaction);
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'ExpandToAssignableToArtifactsCommand' must not be empty";
        this.m_presentationName = presentationName;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXPLORATION_VIEW_EXPAND_TO_ASSIGNABLE_TO_ARTIFACTS;
    }

    @Override
    public String getPresentationName() {
        return this.m_presentationName;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        ExpandCollapseData data = new ExpandCollapseData();
        if (!((IExpandCollapseInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        this.getController().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class).expandToAssignableToArtifacts(workerContext, data.getRequest());
    }
}

