/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.base.DynamicCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;

public abstract class CreateArchitecturalViewListCommand
extends DynamicCommand
implements IArchitecturalViewCommand {
    private final ExplorationViewRepresentation m_representation;
    private List<? extends ArchitecturalViewInfo<? extends Element>> m_list;

    public CreateArchitecturalViewListCommand(ISoftwareSystemProvider provider, ExplorationViewRepresentation representation) {
        super(provider);
        assert (representation != null) : "Parameter 'representation' of method 'CreateArchitecturalViewListCommand' must not be null";
        this.m_representation = representation;
    }

    @Override
    public final Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isSuccess() && !this.m_representation.isValid()) {
            result.addErrorMessage("Representation is not valid");
        }
        return result;
    }

    protected abstract List<? extends ArchitecturalViewInfo<? extends Element>> create(IArchitecturalViewExtension var1, IWorkerContext var2, ExplorationViewRepresentation var3);

    @Override
    protected final void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        this.m_list = this.create(this.getSoftwareSystem().getExtension(IArchitecturalViewExtension.class), workerContext, this.m_representation);
    }

    public final List<? extends ArchitecturalViewInfo<? extends Element>> getList() {
        return this.m_list;
    }
}

