/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class CollapseAllCommand
extends ArchitecturalViewCommand<ICollapseAllInteraction> {
    public CollapseAllCommand(ISoftwareSystemProvider provider, ICollapseAllInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXPLORATION_VIEW_COLLAPSE_ALL;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        ArchitecturalViewRepresentationData data = new ArchitecturalViewRepresentationData();
        if (!((ICollapseAllInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        this.getController().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class).collapseAll(data.getRepresentation());
    }

    public static interface ICollapseAllInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(ArchitecturalViewRepresentationData var1);
    }
}

