/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IAuthorsExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collection;
import java.util.Map;

public final class UpdateAuthorsCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public UpdateAuthorsCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.UPDATE_AUTHORS;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        UpdateAuthorsData data = new UpdateAuthorsData();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = new OperationResult("Updating Authors");
        this.getController().getSoftwareSystem().getExtension(IAuthorsExtension.class).updateAuthorsAndAliases(result, data.getAliasesMap(), data.getAuthors());
        if (result.isFailure()) {
            ((IInteraction)this.getInteraction()).processResult(result);
        }
    }

    public static interface IInteraction
    extends ICommandInteractionWithResult {
        public boolean collect(UpdateAuthorsData var1);
    }

    public static final class UpdateAuthorsData
    implements ICommandInteractionData {
        private Collection<String> m_authors;
        private Map<String, String> m_aliasesMap;

        public void setData(Map<String, String> aliases, Collection<String> authors) {
            assert (aliases != null) : "Parameter 'aliases' of method 'setData' must not be  null";
            assert (authors != null) : "Parameter 'authors' of method 'setData' must not be null";
            this.m_aliasesMap = aliases;
            this.m_authors = authors;
        }

        private Map<String, String> getAliasesMap() {
            assert (this.m_aliasesMap != null);
            return this.m_aliasesMap;
        }

        private Collection<String> getAuthors() {
            assert (this.m_authors != null);
            return this.m_authors;
        }
    }
}

