/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.RestoreCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.foundation.common.history.FileHistoryOperation;
import com.hello2morrow.sonargraph.core.model.history.IUndoRedoEntry;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class UndoCommand
extends RestoreCommand {
    public UndoCommand(ISoftwareSystemProvider provider, RestoreCommand.IRestoreInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.UNDO;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        String confirmationMessage = this.getExtension().getConfirmationMessageForNextRestore(FileHistoryOperation.UNDO);
        if (confirmationMessage != null && !((RestoreCommand.IRestoreInteraction)this.getInteraction()).confirm(confirmationMessage)) {
            return;
        }
        OperationResult result = this.getExtension().undo(workerContext);
        ((RestoreCommand.IRestoreInteraction)this.getInteraction()).processRestoreResult(result);
    }

    public static IUndoRedoEntry getNextEntryForUndo(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getNextEntryForUndo' must not be null";
        if (provider.hasSoftwareSystem()) {
            IUndoRedoExtension undoRedoExtension = provider.getSoftwareSystem().getExtension(IUndoRedoExtension.class);
            return undoRedoExtension.getNextEntryForUndo();
        }
        return null;
    }

    @Override
    public Result isEnabled() {
        Result result = super.isEnabled();
        if (result.isSuccess() && !this.getExtension().isUndoAvailable()) {
            result.addErrorMessage("Undo not available");
        }
        return result;
    }
}

