/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityModelImportExtension;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.path.QualityModelFileDescriptor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.EnumSet;
import java.util.List;

public final class CreateSoftwareSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    private final AbstractCreateSoftwareSystemCommand.IInteraction m_interaction;
    private boolean m_canceled;

    public static List<QualityModelFileDescriptor> getQualityModelFileDescriptors(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getQualityModelFileDescriptors' must not be null";
        return provider.getInstallation().getExtension(IQualityModelImportExtension.class).getQualityModelFileDescriptors();
    }

    public CreateSoftwareSystemCommand(ISoftwareSystemProvider provider, AbstractCreateSoftwareSystemCommand.IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CREATE_SOFTWARE_SYSTEM;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        AbstractCreateSoftwareSystemCommand.SoftwareSystemData softwareSystemData = new AbstractCreateSoftwareSystemCommand.SoftwareSystemData();
        if (!this.m_interaction.collect(softwareSystemData)) {
            this.m_canceled = true;
            return;
        }
        String overwriteInfo = this.getController().validateOverwrite(softwareSystemData.getBaseDirectory(), softwareSystemData.getName());
        if (overwriteInfo != null && !this.m_interaction.confirmOverwrite(overwriteInfo)) {
            this.m_canceled = true;
            return;
        }
        if (this.getController().hasSoftwareSystem()) {
            CloseSoftwareSystemCommand closeSoftwareSystemCommand = new CloseSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), this.m_interaction);
            this.runPrerequisiteCommand(closeSoftwareSystemCommand, workerContext);
            if (closeSoftwareSystemCommand.canceled()) {
                this.m_canceled = true;
                return;
            }
        }
        EnumSet<ISoftwareSystemProvider.OpenOption> openOptions = EnumSet.noneOf(ISoftwareSystemProvider.OpenOption.class);
        if (CommandRegistry.getInstance().isFeatureAvailable(SonargraphFeature.VIRTUAL_MODELS)) {
            openOptions.add(ISoftwareSystemProvider.OpenOption.SWITCH_TO_DEFAULT_MODEL);
        }
        OperationResult result = this.getController().createSoftwareSystem(workerContext, softwareSystemData.getBaseDirectory(), openOptions, softwareSystemData.getName(), softwareSystemData.getDescription(), softwareSystemData.getQualityModel());
        this.m_interaction.processCreateSoftwareSystemResult(result);
    }

    public boolean canceled() {
        return this.m_canceled;
    }
}

