/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class ClearSoftwareSystemCommand
extends SoftwareSystemBasedCommand<IClearSoftwareSystemInteraction> {
    public ClearSoftwareSystemCommand(ISoftwareSystemProvider provider, IClearSoftwareSystemInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CLEAR_SOFTWARE_SYSTEM;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public boolean invalidatesParserModel() {
        return true;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && !this.getController().getSoftwareSystem().isClearable()) {
            enabled.addErrorMessage("Software system not clearable");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        OperationResult result = this.getController().clear(workerContext);
        ((IClearSoftwareSystemInteraction)this.getInteraction()).processClearSoftwareSystemResult(result);
    }

    public static interface IClearSoftwareSystemInteraction
    extends ICommandInteraction {
        public void processClearSoftwareSystemResult(OperationResult var1);
    }
}

