/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphCategory;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class SonargraphLicense {
    public static final String LICENSE_FILE_EXTENSION = ".license";
    private final Map<Property, OperationResult.IMessageCause> m_propertyToValidationError = new HashMap<Property, OperationResult.IMessageCause>();
    private final String m_signedContent;
    private final Map<String, String> m_properties;
    private final OperationResult m_nonPropertyRelatedValidationResult;
    private OperationResult m_additionalOperationResult;
    private Map<Language, Integer> m_languageToSize;
    private EnumSet<SonargraphFeature> m_features;
    private EnumSet<SonargraphCategory> m_disabledCategories;
    private Date m_expirationDate;
    private Date m_supportExpirationDate;
    private Date m_ticketExpirationDate;

    SonargraphLicense(String signedContent, Map<String, String> licenseProperties, OperationResult contentStructureValidationResult) {
        assert (licenseProperties != null) : "Parameter 'properties' of method 'SonargraphLicense' must not be null";
        assert (contentStructureValidationResult != null) : "Parameter 'contentStructureValidationResult' of method 'SonargraphLicense' must not be null";
        this.m_signedContent = signedContent;
        this.m_properties = new LinkedHashMap<String, String>(licenseProperties);
        this.m_nonPropertyRelatedValidationResult = new OperationResult("License Validation");
        this.m_nonPropertyRelatedValidationResult.addMessagesFrom(contentStructureValidationResult);
    }

    public OperationResult getNonPropertyRelatedValidationResult() {
        return this.m_nonPropertyRelatedValidationResult;
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.m_properties);
    }

    void resetAdditionalInfo() {
        this.m_additionalOperationResult = null;
    }

    void addAdditionalInfo(OperationResult.IMessageCause cause, String msg) {
        assert (cause != null) : "Parameter 'cause' of method 'addAdditionalValidationResultInfo' must not be null";
        assert (msg != null && msg.length() > 0) : "Parameter 'msg' of method 'addAdditionalValidationResultInfo' must not be empty";
        if (this.m_additionalOperationResult == null) {
            this.m_additionalOperationResult = new OperationResult("Additonal validation info");
        }
        this.m_additionalOperationResult.addInfo(cause, msg);
    }

    public List<OperationResult> getAllValidationResults() {
        ArrayList<OperationResult> all = new ArrayList<OperationResult>();
        all.add(this.m_nonPropertyRelatedValidationResult);
        OperationResult propertyResult = new OperationResult("Properties");
        this.m_propertyToValidationError.values().stream().forEach(err -> propertyResult.addError(err, err.getPresentationName(), new Object[0]));
        all.add(propertyResult);
        if (this.m_additionalOperationResult != null) {
            all.add(this.m_additionalOperationResult);
        }
        return all;
    }

    public List<OperationResult> getNonPropertyValidationResults() {
        ArrayList<OperationResult> all = new ArrayList<OperationResult>();
        all.add(this.m_nonPropertyRelatedValidationResult);
        if (this.m_additionalOperationResult != null) {
            all.add(this.m_additionalOperationResult);
        }
        return all;
    }

    void setFeatures(EnumSet<SonargraphFeature> features) {
        assert (features != null) : "Parameter 'features' of method 'setFeatures' must not be null";
        assert (this.m_features == null) : "'m_features' of method 'setFeatures' must be null";
        this.m_features = EnumSet.noneOf(SonargraphFeature.class);
        this.m_features.add(SonargraphFeature.PLATFORM);
        this.m_features.addAll(features);
    }

    void setDisabledCategories(EnumSet<SonargraphCategory> disabledCategories) {
        assert (disabledCategories != null) : "Parameter 'disabledCategories' of method 'setDisabledCategories' must not be null";
        assert (this.m_disabledCategories == null) : "'m_disabledCategories' of method 'setDisabledCategories' must be null";
        this.m_disabledCategories = EnumSet.noneOf(SonargraphCategory.class);
        this.m_disabledCategories.addAll(disabledCategories);
    }

    boolean containsFeature(SonargraphFeature feature) {
        assert (feature != null) : "Parameter 'feature' of method 'containsFeature' must not be null";
        if (this.m_features != null) {
            return this.m_features.contains((Object)feature);
        }
        return false;
    }

    public EnumSet<SonargraphFeature> getFeatures() {
        if (this.m_features == null) {
            this.m_features = EnumSet.noneOf(SonargraphFeature.class);
            this.m_features.add(SonargraphFeature.PLATFORM);
        }
        return EnumSet.copyOf(this.m_features);
    }

    boolean containsCategory(SonargraphCategory category) {
        assert (category != null) : "Parameter 'category' of method 'containsCategory' must not be null";
        if (this.m_disabledCategories != null) {
            return !this.m_disabledCategories.contains((Object)category);
        }
        return true;
    }

    EnumSet<SonargraphCategory> getCategories() {
        if (this.m_disabledCategories == null) {
            this.m_disabledCategories = EnumSet.noneOf(SonargraphCategory.class);
        }
        return EnumSet.complementOf(this.m_disabledCategories);
    }

    void setLanguages(Map<Language, Integer> licensedLanguageToSize) {
        assert (licensedLanguageToSize != null) : "Parameter 'licensedLanguageToSize' of method 'setLanguages' must not be null";
        assert (this.m_languageToSize == null) : "'m_languageToSize' of method 'setLanguages' must be null";
        if (this.m_languageToSize == null) {
            this.m_languageToSize = new HashMap<Language, Integer>(licensedLanguageToSize);
        }
    }

    public boolean isAvailable(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isLicensed' must not be null";
        if (this.m_languageToSize != null) {
            return this.m_languageToSize.containsKey(language);
        }
        return false;
    }

    public Set<Language> getLicensedLanguages() {
        if (this.m_languageToSize != null) {
            return Collections.unmodifiableSet(this.m_languageToSize.keySet());
        }
        return Collections.emptySet();
    }

    public String getLicensedFeaturesAndLanguages() {
        ArrayList featuresAndLanguages = new ArrayList();
        this.m_features.forEach(f -> {
            boolean bl = featuresAndLanguages.add(f.getStandardName());
        });
        this.m_languageToSize.keySet().forEach(l -> {
            boolean bl = featuresAndLanguages.add(l.getStandardName());
        });
        return StringUtility.concat((Collection)featuresAndLanguages.stream().sorted().collect(Collectors.toList()), (String)", ");
    }

    public int getLicensedSize(Language language) {
        assert (language != null) : "Parameter 'language' of method 'getLicensedSize' must not be null";
        if (this.m_languageToSize != null) {
            Integer size = this.m_languageToSize.get(language);
            return size != null ? size : -1;
        }
        return -1;
    }

    public String getLicensedSizePresentationName(Language language) {
        Integer size;
        assert (language != null) : "Parameter 'language' of method 'getLicensedSizePresentationName' must not be null";
        if (this.m_languageToSize != null && (size = this.m_languageToSize.get(language)) != null) {
            if (size == 0) {
                return "Unlimited";
            }
            assert (size != -1) : "Unlicensed language entry: " + String.valueOf(language);
            return size.toString();
        }
        return "Not licensed";
    }

    public boolean isFloating() {
        return this.getValue(Property.TICKET_ID) != null;
    }

    public String getValue(Property property) {
        assert (property != null) : "Parameter 'property' of method 'getValue' must not be null";
        return this.m_properties.get(property.getStandardName());
    }

    void setValidationError(Property property, OperationResult.IMessageCause cause) {
        assert (property != null) : "Parameter 'property' of method 'setValidationResult' must not be null";
        assert (cause != null) : "Parameter 'cause' of method 'setValidationResult' must not be null";
        this.m_propertyToValidationError.put(property, cause);
    }

    public OperationResult.IMessageCause getValidationError(Property property) {
        assert (property != null) : "Parameter 'property' of method 'getValidationError' must not be null";
        return this.m_propertyToValidationError.get((Object)property);
    }

    public boolean isValid() {
        return this.m_nonPropertyRelatedValidationResult.isSuccess() && this.m_propertyToValidationError.isEmpty();
    }

    public Date getExpirationDate() {
        return this.m_expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        assert (expirationDate != null) : "Parameter 'expirationDate' of method 'setExpirationDate' must not be null";
        assert (this.m_expirationDate == null) : "'m_expirationDate' of method 'setExpirationDate' must be null";
        if (this.m_expirationDate == null) {
            this.m_expirationDate = expirationDate;
        }
    }

    public Date getSupportExpirationDate() {
        return this.m_supportExpirationDate;
    }

    public void setSupportExpirationDate(Date supportExpirationDate) {
        assert (supportExpirationDate != null) : "Parameter 'supportExpirationDate' of method 'setSupportExpirationDate' must not be null";
        assert (this.m_supportExpirationDate == null) : "'m_supportExpirationDate' of method 'setSupportExpirationDate' must be null";
        if (this.m_supportExpirationDate == null) {
            this.m_supportExpirationDate = supportExpirationDate;
        }
    }

    public Date getTicketExpirationDate() {
        return this.m_ticketExpirationDate;
    }

    public void setTicketExpirationDate(Date ticketExpirationDate) {
        assert (ticketExpirationDate != null) : "Parameter 'ticketExpirationDate' of method 'setTicketExpirationDate' must not be null";
        assert (this.m_ticketExpirationDate == null) : "'m_ticketExpirationDate' of method 'setTicketExpirationDate' must be null";
        if (this.m_ticketExpirationDate == null) {
            this.m_ticketExpirationDate = ticketExpirationDate;
        }
    }

    String getSignedContent() {
        return this.m_signedContent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.isValid() ? "Valid license" : "License not valid");
        builder.append(StringUtility.LINE_SEPARATOR);
        builder.append(this.m_properties);
        return builder.toString();
    }

    public static final class Property
    extends Enum<Property>
    implements IStandardEnumeration {
        public static final /* enum */ Property PRODUCT = new Property();
        public static final /* enum */ Property LICENSE = new Property();
        public static final /* enum */ Property LICENSOR = new Property();
        public static final /* enum */ Property COPYRIGHT = new Property();
        public static final /* enum */ Property LICENSEE = new Property();
        public static final /* enum */ Property USER = new Property();
        public static final /* enum */ Property CONTRACT = new Property();
        public static final /* enum */ Property CREATION = new Property();
        public static final /* enum */ Property EXPIRATION = new Property();
        public static final /* enum */ Property SUPPORT_EXPIRATION = new Property();
        public static final /* enum */ Property ACTIVATION_CODE = new Property();
        public static final /* enum */ Property TICKET_EXPIRATION = new Property();
        public static final /* enum */ Property VERSION = new Property();
        public static final /* enum */ Property BUILD_DATE = new Property();
        public static final /* enum */ Property LOGIN = new Property();
        public static final /* enum */ Property MAC_ADDRESSES = new Property();
        public static final /* enum */ Property SPECIAL_LICENSE_FEATURES = new Property("Features");
        public static final /* enum */ Property DISABLED_CATEGORIES = new Property();
        public static final /* enum */ Property TICKET_ID = new Property();
        public static final /* enum */ Property TICKET_MAGIC = new Property();
        public static final /* enum */ Property HEART_BEAT_SECONDS = new Property();
        private final String m_presentationName;
        private static final /* synthetic */ Property[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Property[]{PRODUCT, LICENSE, LICENSOR, COPYRIGHT, LICENSEE, USER, CONTRACT, CREATION, EXPIRATION, SUPPORT_EXPIRATION, ACTIVATION_CODE, TICKET_EXPIRATION, VERSION, BUILD_DATE, LOGIN, MAC_ADDRESSES, SPECIAL_LICENSE_FEATURES, DISABLED_CATEGORIES, TICKET_ID, TICKET_MAGIC, HEART_BEAT_SECONDS};
        }

        private Property(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'Property' must not be empty";
            this.m_presentationName = presentationName;
        }

        private Property() {
            this.m_presentationName = null;
        }

        public static Property fromStandardName(String standardName) {
            String name = StringUtility.convertStandardNameToConstantName((String)standardName);
            try {
                return Property.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            if (this.m_presentationName == null) {
                return StringUtility.convertConstantNameToPresentationName((String)this.name());
            }
            return this.m_presentationName;
        }

        public static Property[] values() {
            Property[] propertyArray = ENUM$VALUES;
            int n = propertyArray.length;
            Property[] propertyArray2 = new Property[n];
            System.arraycopy(ENUM$VALUES, 0, propertyArray2, 0, n);
            return propertyArray2;
        }

        public static Property valueOf(String string) {
            return Enum.valueOf(Property.class, string);
        }
    }
}

