/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.common;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandProvider;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandlerDevelopment;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MockUserInterfaceAdapterDevelopment {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockUserInterfaceAdapterDevelopment.class);
    private static MockUserInterfaceAdapterDevelopment s_instance;
    private int m_navigationStateId = 0;

    private MockUserInterfaceAdapterDevelopment(SonargraphProduct product, Set<Language> availableLanguages, List<ICommandProvider> commandProviders, Set<SonargraphFeature> disabledFeatures) {
        assert (disabledFeatures != null) : "Parameter 'disabledFeatures' of method 'MockUserInterfaceAdapterDevelopment' must not be null";
        HashSet<SonargraphFeature> disabledFeaturesToUse = new HashSet<SonargraphFeature>(disabledFeatures);
        disabledFeaturesToUse.add(SonargraphFeature.PLUGINS);
        SonargraphLicenseHandlerDevelopment licenseHandler = new SonargraphLicenseHandlerDevelopment(product, availableLanguages, disabledFeaturesToUse, null);
        licenseHandler.initialize();
        CommandRegistry.createInstance(licenseHandler, commandProviders);
    }

    public static MockUserInterfaceAdapterDevelopment createInstance(SonargraphProduct product, Set<Language> availableLanguages, List<ICommandProvider> commandProviders, Set<SonargraphFeature> disabledFeatures) {
        s_instance = new MockUserInterfaceAdapterDevelopment(product, availableLanguages, commandProviders, disabledFeatures);
        return s_instance;
    }

    public static MockUserInterfaceAdapterDevelopment getInstance() {
        assert (s_instance != null) : "'s_instance' of method 'getInstance' must not be null";
        return s_instance;
    }

    public void delete() {
        CommandRegistry.delete();
        MockUserInterfaceAdapterDevelopment.deleteInstance();
    }

    private static void deleteInstance() {
        s_instance = null;
    }

    public void process(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'process' must not be null";
        if (result.containsError()) {
            LOGGER.error(result.toString());
        } else if (result.containsWarning()) {
            LOGGER.warn(result.toString());
        } else if (result.containsInfo()) {
            LOGGER.info(result.toString());
        }
    }

    public int getNextNavigationStateId() {
        return this.m_navigationStateId++;
    }

    public SonargraphLicenseHandlerDevelopment getLicenseHandler() {
        return (SonargraphLicenseHandlerDevelopment)CommandRegistry.getInstance().getLicenseHandler();
    }

    public static final class LicenseProviderDevelopment
    implements ILicenseProvider {
        private final EnumSet<SonargraphFeature> m_availableFeatures = EnumSet.allOf(SonargraphFeature.class);

        public LicenseProviderDevelopment() {
            this.m_availableFeatures.remove((Object)SonargraphFeature.PLUGINS);
        }

        @Override
        public boolean isLanguageAvailable(Language language) {
            assert (language != null) : "Parameter 'language' of method 'isLanguageAvailable' must not be null";
            return true;
        }

        @Override
        public int getLicensedSize(Language language) {
            assert (language != null) : "Parameter 'language' of method 'getLicensedSize' must not be null";
            return 0;
        }

        @Override
        public List<String> getUserInfo() {
            return Collections.emptyList();
        }

        @Override
        public void addAdditionalLicenseInfo(OperationResult.IMessageCause info, String message) {
        }

        @Override
        public void resetAdditionalLicenseInfo() {
        }

        @Override
        public Version getProductVersion() {
            return Version.create((String)"9.9.0.000");
        }

        @Override
        public SonargraphProduct getProduct() {
            return SonargraphProduct.SONARGRAPH;
        }

        @Override
        public boolean isFeatureAvailable(SonargraphFeature feature) {
            assert (feature != null) : "Parameter 'feature' of method 'isFeatureAvailable' must not be null";
            return this.m_availableFeatures.contains((Object)feature);
        }

        @Override
        public EnumSet<SonargraphFeature> getAvailableFeatures() {
            return this.m_availableFeatures;
        }

        @Override
        public EnumSet<SonargraphFeature> getUnavailableFeatures() {
            return EnumSet.of(SonargraphFeature.PLUGINS);
        }
    }
}

